/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.function.LongConsumer;
import org.neo4j.index.internal.gbptree.CursorCreator;
import org.neo4j.index.internal.gbptree.IdProvider;
import org.neo4j.index.internal.gbptree.InternalAccess;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.StructurePropagation;
import org.neo4j.index.internal.gbptree.TreeNodeUtil;
import org.neo4j.index.internal.gbptree.TreeWriteOperation;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;

public class CleanupTree<K, V>
implements TreeWriteOperation<K, V> {
    @Override
    public boolean run(Layout<K, V> layout, InternalAccess<K, V> internalAccess, PageCursor cursor, StructurePropagation<K> structurePropagation, long stableGeneration, long unstableGeneration, CursorContext cursorContext, LongConsumer rootSetter, IdProvider freeList) throws IOException {
        if (!internalAccess.coordination().pessimistic()) {
            return false;
        }
        if (!TreeNodeUtil.isLeaf(cursor)) {
            long rootPageId = cursor.getCurrentPageId();
            long child = internalAccess.internalNode().childAt(cursor, 0, stableGeneration, unstableGeneration);
            while (child >= 0L) {
                child = this.cleanLevel(cursor, child, internalAccess, stableGeneration, unstableGeneration, freeList);
            }
            cursor.next(rootPageId);
        }
        internalAccess.leafNode().initialize(cursor, (byte)0, stableGeneration, unstableGeneration);
        TreeNodeUtil.setKeyCount(cursor, 0);
        rootSetter.accept(cursor.getCurrentPageId());
        return true;
    }

    private long cleanLevel(PageCursor cursor, long child, InternalAccess<K, V> internalAccess, long stableGeneration, long unstableGeneration, IdProvider freeList) throws IOException {
        TreeNodeUtil.goTo(cursor, "child", child);
        long leftMostChild = TreeNodeUtil.isLeaf(cursor) ? -1L : internalAccess.internalNode().childAt(cursor, 0, stableGeneration, unstableGeneration);
        while (true) {
            freeList.releaseId(stableGeneration, unstableGeneration, cursor.getCurrentPageId(), CursorCreator.bind(cursor));
            long rightSibling = TreeNodeUtil.rightSibling(cursor, stableGeneration, unstableGeneration).pointer();
            if (!TreeNodeUtil.isNode(rightSibling)) break;
            TreeNodeUtil.goTo(cursor, "right sibling", rightSibling);
        }
        return leftMostChild;
    }
}

