/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import org.neo4j.index.internal.gbptree.InternalNodeBehaviour;

public sealed interface GBPTreePointerType {
    public int offset(InternalNodeBehaviour<?> var1);

    public static GBPTreePointerType leftSibling() {
        return SimplePointer.LEFT_SIBLING;
    }

    public static GBPTreePointerType rightSibling() {
        return SimplePointer.RIGHT_SIBLING;
    }

    public static GBPTreePointerType successor() {
        return SimplePointer.SUCCESSOR;
    }

    public static GBPTreePointerType noPointer() {
        return SimplePointer.NO_POINTER;
    }

    public static GBPTreePointerType child(int pos) {
        return new ChildPointer(pos);
    }

    public static enum SimplePointer implements GBPTreePointerType
    {
        NO_POINTER{

            @Override
            public int offset(InternalNodeBehaviour<?> node) {
                return 0;
            }

            public String toString() {
                return "no pointer";
            }
        }
        ,
        LEFT_SIBLING{

            @Override
            public int offset(InternalNodeBehaviour<?> node) {
                return 34;
            }

            public String toString() {
                return "left sibling";
            }
        }
        ,
        RIGHT_SIBLING{

            @Override
            public int offset(InternalNodeBehaviour<?> node) {
                return 10;
            }

            public String toString() {
                return "right sibling";
            }
        }
        ,
        SUCCESSOR{

            @Override
            public int offset(InternalNodeBehaviour<?> node) {
                return 58;
            }

            public String toString() {
                return "successor";
            }
        };

    }

    public record ChildPointer(int pos) implements GBPTreePointerType
    {
        @Override
        public int offset(InternalNodeBehaviour<?> node) {
            return node.childOffset(this.pos);
        }

        @Override
        public String toString() {
            return "child(" + this.pos + ")";
        }
    }
}

