/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import org.neo4j.index.internal.gbptree.KeyLayout;
import org.neo4j.io.pagecache.PageCursor;

public interface Layout<KEY, VALUE>
extends KeyLayout<KEY> {
    public static final int FIXED_SIZE_VALUE = -1;

    default public boolean fixedValueSize() {
        return this.fixedSize();
    }

    public VALUE newValue();

    public int valueSize(VALUE var1);

    public void writeValue(PageCursor var1, VALUE var2);

    public void readValue(PageCursor var1, VALUE var2, int var3);

    default public void assertValidSeekKeys(KEY from, KEY to) {
    }

    public static long namedIdentifier(String name, int identifier) {
        char[] chars = name.toCharArray();
        if (chars.length > 4) {
            throw new IllegalArgumentException("Maximum 4 character name, was '" + name + "'");
        }
        long upperInt = 0L;
        for (char aChar : chars) {
            byte byteValue = (byte)((byte)aChar ^ (byte)(aChar >> 8));
            upperInt <<= 8;
            upperInt |= (long)(byteValue & 0xFF);
        }
        return upperInt << 32 | (long)identifier;
    }

    default public boolean neverVersioned() {
        return false;
    }

    public static abstract class Adapter<KEY, VALUE>
    extends KeyLayout.Adapter<KEY>
    implements Layout<KEY, VALUE> {
        protected Adapter(boolean fixedSize, long identifier, int majorVersion, int minorVersion) {
            super(fixedSize, identifier, majorVersion, minorVersion);
        }
    }
}

