/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.physicalplanning;

public final class SlotType {
    public static final int NodeNonNullLongSlot = 1;
    public static final int NodeNullableLongSlot = 2;
    public static final int RelNonNullLongSlot = 3;
    public static final int RelNullableLongSlot = 4;
    public static final int OtherNonNullLongSlot = 5;
    public static final int OtherNullableLongSlot = 6;
    public static final int NodeNonNullRefSlot = 7;
    public static final int NodeNullableRefSlot = 8;
    public static final int RelNonNullRefSlot = 9;
    public static final int RelNullableRefSlot = 10;
    public static final int OtherNonNullRefSlot = 11;
    public static final int OtherNullableRefSlot = 12;

    private SlotType() {
    }

    public static boolean isValidSlotType(int slotType) {
        return slotType >= 1 && slotType <= 12;
    }

    public static boolean isNullable(int slotType) {
        assert (SlotType.isValidSlotType(slotType));
        return slotType % 2 == 0;
    }

    public static boolean isLongSlot(int slotType) {
        assert (SlotType.isValidSlotType(slotType));
        return slotType <= 6;
    }

    public static boolean isRefSlot(int slotType) {
        assert (SlotType.isValidSlotType(slotType));
        return slotType >= 7;
    }
}

