/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.BuiltInFunctions;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.DistinctExpression;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.ExpressionList;
import org.neo4j.cypherdsl.core.Pattern;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.PatternExpressionImpl;
import org.neo4j.cypherdsl.core.RendererBridge;
import org.neo4j.cypherdsl.core.ast.TypedSubtree;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.STABLE, since="1.0")
public final class FunctionInvocation
implements Expression {
    private static final MessageFormat MESSAGE_FMT_EXP_REQUIRED = new MessageFormat(Cypher.MESSAGES.getString("assertions.expression-for-function-required"));
    private static final MessageFormat MESSAGE_FMT_PATTERN_REQUIRED = new MessageFormat(Cypher.MESSAGES.getString("assertions.pattern-for-function-required"));
    private static final MessageFormat MESSAGE_FMT_ARG_REQUIRED = new MessageFormat(Cypher.MESSAGES.getString("assertions.at-least-one-arg-required"));
    private final String functionName;
    private final Visitable arguments;

    public static FunctionInvocation create(FunctionDefinition definition) {
        return new FunctionInvocation(definition.getImplementationName(), new Expression[0]);
    }

    public static FunctionInvocation create(FunctionDefinition definition, Expression ... expressions) {
        String message = MESSAGE_FMT_EXP_REQUIRED.format(new Object[]{definition.getImplementationName()});
        Assertions.notEmpty(expressions, message);
        Assertions.notNull(expressions[0], message);
        return new FunctionInvocation(definition.getImplementationName(), expressions);
    }

    public static FunctionInvocation createDistinct(FunctionDefinition definition, Expression ... expressions) {
        Assertions.isTrue(definition.isAggregate(), Cypher.MESSAGES.getString("assertions.correct-usage-of-distinct"));
        String message = MESSAGE_FMT_EXP_REQUIRED.format(new Object[]{definition.getImplementationName()});
        Assertions.notEmpty(expressions, message);
        Assertions.notNull(expressions[0], message);
        Expression[] newExpressions = new Expression[expressions.length];
        newExpressions[0] = new DistinctExpression(expressions[0]);
        System.arraycopy(expressions, 1, newExpressions, 1, expressions.length - 1);
        return new FunctionInvocation(definition.getImplementationName(), newExpressions);
    }

    public static FunctionInvocation create(FunctionDefinition definition, PatternElement pattern) {
        String message = MESSAGE_FMT_PATTERN_REQUIRED.format(new Object[]{definition.getImplementationName()});
        Assertions.notNull(pattern, message);
        Predicate<FunctionDefinition> isShortestPath = d -> BuiltInFunctions.Scalars.SHORTEST_PATH.getImplementationName().equals(d.getImplementationName()) || "allShortestPaths".equals(d.getImplementationName());
        return new FunctionInvocation(definition.getImplementationName(), isShortestPath.test(definition) ? Pattern.of(List.of(pattern)) : new PatternExpressionImpl(pattern));
    }

    static FunctionInvocation create(FunctionDefinition definition, TypedSubtree<?> arguments) {
        Assertions.notNull(arguments, MESSAGE_FMT_ARG_REQUIRED.format(new Object[]{definition.getImplementationName()}));
        return new FunctionInvocation(definition.getImplementationName(), arguments);
    }

    private FunctionInvocation(String functionName, Expression ... arguments) {
        this.functionName = functionName;
        this.arguments = new ExpressionList(arguments);
    }

    private FunctionInvocation(String functionName, Visitable arguments) {
        this.functionName = functionName;
        this.arguments = arguments;
    }

    @API(status=API.Status.INTERNAL)
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.arguments.accept(visitor);
        visitor.leave(this);
    }

    @Override
    public String toString() {
        return RendererBridge.render(this);
    }

    @API(status=API.Status.STABLE, since="2020.1.0")
    public static interface FunctionDefinition {
        public String getImplementationName();

        default public boolean isAggregate() {
            return Arrays.stream(BuiltInFunctions.Aggregates.values()).map(BuiltInFunctions.Aggregates::getImplementationName).anyMatch(v -> v.equalsIgnoreCase(this.getImplementationName()));
        }
    }
}

