/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.communication;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.neo4j.fleetmanagement.bootstrap.PluginBuildProfile;
import com.neo4j.fleetmanagement.bootstrap.PluginTask;
import com.neo4j.fleetmanagement.communication.BaseService;
import com.neo4j.fleetmanagement.communication.model.ConfigurationResponse;
import com.neo4j.fleetmanagement.communication.model.ConnectMessage;
import com.neo4j.fleetmanagement.communication.upstream.Upstream;
import com.neo4j.fleetmanagement.configuration.ClusterSync;
import com.neo4j.fleetmanagement.configuration.Configuration;
import com.neo4j.fleetmanagement.configuration.State;
import com.neo4j.fleetmanagement.topology.TopologyMapper;
import com.neo4j.fleetmanagement.transactions.ITransactor;
import com.neo4j.fleetmanagement.utils.PluginVersion;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.identity.ServerIdentity;
import org.neo4j.io.fs.FileSystemAbstraction;

public class ConnectService
extends BaseService {
    private final TopologyMapper topologyMapper;
    private final Upstream upstream;
    private final Configuration configuration;
    private final PluginBuildProfile pluginBuildProfile;

    public ConnectService(Config config, FileSystemAbstraction fs, ITransactor transactor, ServerIdentity serverIdentity, Upstream upstream, PluginBuildProfile pluginBuildProfile) {
        super(transactor);
        this.topologyMapper = new TopologyMapper(config, fs, transactor, serverIdentity);
        this.upstream = upstream;
        this.configuration = Configuration.getInstance();
        this.pluginBuildProfile = pluginBuildProfile;
    }

    public synchronized void ensureConnected() {
        if (!this.state.isConnected()) {
            this.connect();
        }
    }

    public synchronized void disconnect(String errorMessage) {
        this.state.setDisconnected(errorMessage);
    }

    public synchronized void reconnect(String errorMessage) {
        this.disconnect(errorMessage);
        this.ensureConnected();
    }

    private void connect() {
        String pluginVersion;
        String dbmsId;
        String serverId;
        String serverVersion;
        try {
            serverVersion = this.topologyMapper.getServerVersion();
            serverId = this.topologyMapper.getServerId();
            dbmsId = this.topologyMapper.getDbmsId();
            pluginVersion = PluginVersion.getPluginVersion();
        }
        catch (Exception e) {
            this.userLog.error("Fleet management plugin failed to connect - exception in mapTopology: ", (Throwable)e);
            return;
        }
        String projectId = this.upstream.getApiKey().projectId();
        ConnectMessage msg = new ConnectMessage(serverId, "plugin", dbmsId, serverVersion, projectId, pluginVersion, this.pluginBuildProfile.name());
        try {
            String payload = this.objectMapper.writeValueAsString((Object)msg);
            this.pluginLog.debug("Fleet management plugin connecting.");
            this.pluginLog.payload("Fleet management plugin connecting with payload: " + payload);
            this.upstream.generateToken();
            Upstream.UpstreamPostRequest upstreamPostRequest = this.upstream.postTo(Upstream.Endpoint.CONNECT);
            int responseCode = upstreamPostRequest.transmit(payload.getBytes());
            byte[] responseBody = upstreamPostRequest.getResponseBody();
            if (responseCode == 200 && responseBody != null) {
                ConfigurationResponse configurationResponse;
                this.pluginLog.payload("Fleet management plugin connect received response: " + new String(responseBody));
                try {
                    configurationResponse = (ConfigurationResponse)this.objectMapper.readValue(responseBody, ConfigurationResponse.class);
                }
                catch (JsonProcessingException e) {
                    String errorMsg = "Fleet management plugin encountered an error after connecting to the API - Failed to deserialize configuration message: " + e.getMessage();
                    this.userLog.warn(errorMsg);
                    this.disconnect(errorMsg);
                    return;
                }
                if (configurationResponse != null) {
                    this.handleConfigurationResponse(configurationResponse);
                }
            } else {
                this.handleErrorResponse("Fleet management plugin failed to connect", responseCode, responseBody);
                return;
            }
            this.state.setConnected();
        }
        catch (JsonProcessingException e) {
            String errorMsg = "Fleet management plugin failed to connect to the API - Failed to serialize connect message: " + e.getMessage();
            this.userLog.error(errorMsg);
            this.state.setDisconnected(errorMsg);
            throw new RuntimeException(e);
        }
        catch (ProtocolException e) {
            String errorMsg = "Fleet management plugin failed to connect to the API - ProtocolException: " + e.getMessage();
            this.userLog.error(errorMsg);
            this.state.setDisconnected(errorMsg);
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            String errorMsg = "Fleet management plugin failed to connect to the API - MalformedURLException: " + e.getMessage();
            this.userLog.error(errorMsg);
            this.state.setDisconnected(errorMsg);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            Object errorMsg = "Fleet management plugin failed to connect to the API - IOException: " + e.getMessage();
            if (!this.upstream.isReachable()) {
                errorMsg = "Fleet management plugin failed to connect to the API - IOException: API is not reachable. Consider checking the connection and if failures continue, try again later.";
            }
            this.userLog.error((String)errorMsg);
            this.state.setDisconnected((String)errorMsg);
            throw new RuntimeException(e);
        }
    }

    private void handleConfigurationResponse(ConfigurationResponse configurationResponse) throws IOException, IllegalArgumentException {
        this.updateRotatedTokenIfPresent(configurationResponse);
        Configuration.updateConfigurationIfPresent(this.configuration, configurationResponse);
    }

    private void updateRotatedTokenIfPresent(ConfigurationResponse configurationResponse) throws IOException {
        if (configurationResponse.newToken() != null && !configurationResponse.newToken().isEmpty()) {
            this.transactor.setToken(configurationResponse.newToken());
            this.upstream.setToken(configurationResponse.newToken());
            this.state.setRotatingToken(false);
        }
    }

    public static class ConnectServiceTask
    extends PluginTask {
        private final ConnectService connectService;

        public ConnectServiceTask(State state, ClusterSync clusterSync, ConnectService connectService) {
            super(state, clusterSync);
            this.connectService = connectService;
        }

        @Override
        public void execute() {
            if (this.state.isActive() && !this.state.isRotatingToken()) {
                this.connectService.ensureConnected();
            }
        }
    }
}

