/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.communication;

import com.neo4j.fleetmanagement.bootstrap.PluginBuildProfile;
import com.neo4j.fleetmanagement.bootstrap.PluginTask;
import com.neo4j.fleetmanagement.communication.AbstractReportingService;
import com.neo4j.fleetmanagement.communication.model.DataPoint;
import com.neo4j.fleetmanagement.communication.model.MetricsMessage;
import com.neo4j.fleetmanagement.communication.upstream.Upstream;
import com.neo4j.fleetmanagement.configuration.ClusterSync;
import com.neo4j.fleetmanagement.configuration.State;
import com.neo4j.fleetmanagement.metrics.MetricsCollection;
import com.neo4j.fleetmanagement.topology.TopologyMapper;
import com.neo4j.fleetmanagement.transactions.ITransactor;
import java.util.List;
import java.util.Map;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.identity.ServerIdentity;

public class MetricsService
extends AbstractReportingService {
    private final ServerIdentity serverIdentity;
    private final MetricsCollection metricsCollection;

    public MetricsService(ITransactor transactor, ServerIdentity serverIdentity, Upstream upstream, Config config, PluginBuildProfile pluginBuildProfile) {
        super(transactor, upstream);
        this.metricsCollection = new MetricsCollection(config, pluginBuildProfile);
        this.serverIdentity = serverIdentity;
    }

    @Override
    public void report() {
        Map<String, List<DataPoint>> metricsData;
        if (!this.state.isConnected()) {
            return;
        }
        try {
            metricsData = this.metricsCollection.collect();
        }
        catch (Exception e) {
            this.userLog.error("Fleet management plugin failed to report metrics - exception in metric collection", (Throwable)e);
            return;
        }
        MetricsMessage msg = new MetricsMessage();
        msg.metrics = metricsData;
        msg.dbmsId = TopologyMapper.getDbmsId(this.transactor.getDatabases());
        msg.serverId = this.serverIdentity.serverId().uuid().toString();
        msg.projectId = this.upstream.getApiKey().projectId();
        this.transmitReport(msg, Upstream.Endpoint.METRICS);
    }

    public static class MetricsReportingTask
    extends PluginTask {
        private final MetricsService metricsService;

        public MetricsReportingTask(State state, ClusterSync clusterSync, MetricsService metricsService) {
            super(state, clusterSync);
            this.metricsService = metricsService;
        }

        @Override
        public void execute() {
            if (this.state.isConnected()) {
                this.metricsService.report();
            }
        }
    }
}

