/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.configuration;

import com.neo4j.fleetmanagement.communication.model.ConfigurationResponse;
import com.neo4j.fleetmanagement.metrics.model.MetricsDefinition;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Configuration {
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private List<MetricsDefinition> metrics;
    private List<String> neo4jConfigKeyGlobs;
    private Map<TaskType, Long> taskReportingInterval;
    public static final String METRICS_CHANGE = "metrics";
    public static final String NEO4J_CONFIGS_CHANGE = "neo4jConfigs";
    public static final String TASK_REPORTING_INTERVAL_CHANGE = "taskReportingInterval";
    private static Configuration instance;

    public static synchronized Configuration getInstance() {
        if (instance == null) {
            instance = new Configuration();
        }
        return instance;
    }

    private Configuration() {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void setMetrics(List<MetricsDefinition> metrics) {
        List<MetricsDefinition> oldMetrics = this.metrics;
        this.metrics = metrics;
        this.changeSupport.firePropertyChange(METRICS_CHANGE, oldMetrics, metrics);
    }

    public List<MetricsDefinition> getMetrics() {
        return this.metrics;
    }

    public void setTaskReportingInterval(Map<TaskType, Long> taskReportingInterval) {
        Map<TaskType, Long> oldTaskReportingInterval = this.taskReportingInterval;
        this.taskReportingInterval = taskReportingInterval;
        this.changeSupport.firePropertyChange(TASK_REPORTING_INTERVAL_CHANGE, oldTaskReportingInterval, taskReportingInterval);
    }

    public Map<TaskType, Long> getTaskReportingInterval() {
        return this.taskReportingInterval;
    }

    public void setNeo4jConfigKeyGlobs(List<String> neo4jConfigKeyGlobs) {
        List<String> oldNeo4jConfigs = this.neo4jConfigKeyGlobs;
        this.neo4jConfigKeyGlobs = neo4jConfigKeyGlobs;
        this.changeSupport.firePropertyChange(NEO4J_CONFIGS_CHANGE, oldNeo4jConfigs, neo4jConfigKeyGlobs);
    }

    public List<String> getNeo4jConfigKeyGlobs() {
        return this.neo4jConfigKeyGlobs;
    }

    public static void updateConfigurationIfPresent(Configuration configuration, ConfigurationResponse configurationResponse) throws IllegalArgumentException {
        if (configurationResponse.getMetrics() != null && !configurationResponse.getMetrics().isEmpty()) {
            configuration.setMetrics(configurationResponse.getMetrics().stream().map(MetricsDefinition::from).collect(Collectors.toList()));
        }
        if (configurationResponse.getNeo4jConfigKeyGlobs() != null && !configurationResponse.getNeo4jConfigKeyGlobs().isEmpty()) {
            configuration.setNeo4jConfigKeyGlobs(configurationResponse.getNeo4jConfigKeyGlobs());
        }
        if (configurationResponse.getReportingIntervals() != null && !configurationResponse.getReportingIntervals().isEmpty()) {
            try {
                Map<TaskType, Long> reportingIntervals = configurationResponse.getReportingIntervals().entrySet().stream().collect(Collectors.toMap(e -> TaskType.fromString((String)e.getKey()), e -> Duration.parse((CharSequence)e.getValue()).getSeconds()));
                configuration.setTaskReportingInterval(reportingIntervals);
            }
            catch (DateTimeParseException e2) {
                throw new IllegalArgumentException("Invalid duration format in reporting intervals: " + e2.getMessage(), e2);
            }
        }
    }

    public static enum TaskType {
        TOPOLOGY,
        METRICS,
        PING,
        UNKNOWN;


        public static TaskType fromString(String type) {
            try {
                return TaskType.valueOf(type.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }
    }
}

