/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.metrics;

import com.neo4j.fleetmanagement.communication.model.ReportingMessage;
import com.neo4j.fleetmanagement.utils.PluginVersion;

public class ServerMetadata {
    private static ServerMetadata instance;
    private final String pluginVersion;
    private final String osName = System.getProperty("os.name");
    private final String osVersion = System.getProperty("os.version");
    private final String osArch = System.getProperty("os.arch");
    private final String jvmVersion = System.getProperty("java.version");
    private final String jvmVendor = System.getProperty("java.vendor");

    public static synchronized ServerMetadata getInstance() {
        if (instance == null) {
            instance = new ServerMetadata();
        }
        return instance;
    }

    private ServerMetadata() {
        this.pluginVersion = PluginVersion.getPluginVersion();
    }

    public void populateStaticInfo(ReportingMessage message) {
        message.pluginVersion = this.pluginVersion;
        message.osName = this.osName;
        message.osVersion = this.osVersion;
        message.osArch = this.osArch;
        message.jvmVersion = this.jvmVersion;
        message.jvmVendor = this.jvmVendor;
    }
}

