/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.metrics.model;

import com.neo4j.fleetmanagement.communication.model.MetricsDefinitionResponse;
import java.util.List;

public class MetricsDefinition {
    private final String name;
    private final String metricName;
    private final List<String> tags;
    private final JmxMetricSpecification jmxMetricSpecification;

    public MetricsDefinition(String name, String metricName, List<String> tags, JmxMetricSpecification jmxMetricSpecification) {
        this.name = name;
        this.metricName = metricName;
        this.tags = tags;
        this.jmxMetricSpecification = jmxMetricSpecification;
    }

    public String getName() {
        return this.name;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public JmxMetricSpecification getJmxMetricSpecification() {
        return this.jmxMetricSpecification;
    }

    public static MetricsDefinition from(final MetricsDefinitionResponse metricsDefinitionResponse) {
        return new MetricsDefinition(metricsDefinitionResponse.name, metricsDefinitionResponse.metricName, metricsDefinitionResponse.tags, new JmxMetricSpecification(){
            {
                this.metricType = JmxMetricSpecification.MetricTypeEnum.valueOf(metricsDefinitionResponse.metricType.toUpperCase());
            }
        });
    }

    public static class JmxMetricSpecification {
        public MetricTypeEnum metricType;

        public static enum MetricTypeEnum {
            GAUGE,
            COUNTER,
            HISTOGRAM;

        }
    }
}

