/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.procedures;

import com.neo4j.fleetmanagement.common.TransactionUtil;
import com.neo4j.fleetmanagement.communication.upstream.ApiKeyProvider;
import com.neo4j.fleetmanagement.configuration.State;
import com.neo4j.fleetmanagement.transactions.ITransactor;
import com.neo4j.fleetmanagement.utils.TokenUtils;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.procedure.SystemProcedure;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Admin;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Configuration {
    @Context
    public Transaction tx;
    @Context
    public GraphDatabaseAPI db;
    @Context
    public ITransactor transactor;
    @Context
    public Log log;

    private void ensureSystemDb() {
        if (!Objects.equals(this.db.databaseName(), "system")) {
            throw new RuntimeException("This procedure can only be run on the system database");
        }
    }

    @Procedure(name="fleetManagement.registerToken", mode=Mode.DBMS)
    @SystemProcedure
    @Admin
    @Description(value="Add a token for authenticating to Neo4j Fleet Management")
    public Stream<Result> registerToken(@Name(value="token") String token) {
        State state = State.getInstance();
        boolean active = this.transactor.getTokenStatus();
        boolean connected = state.isConnected();
        this.ensureSystemDb();
        return TransactionUtil.withTransactionAndErrorHandling(this.db, tx -> {
            Optional<Node> maybeNode = tx.findNodes(Label.label((String)"FleetManagementConfiguration")).stream().findFirst();
            if (maybeNode.isPresent() && ((Node)maybeNode.get()).hasProperty("token")) {
                if (active) {
                    state.setActive(false);
                }
                if (connected) {
                    state.setDisconnected("Disconnecting before registering a new token");
                }
            }
            Node node = maybeNode.orElseGet(() -> tx.createNode(new Label[]{Label.label((String)"FleetManagementConfiguration")}));
            node.setProperty("token", (Object)token);
            tx.commit();
            state.setActive(true);
            ApiKeyProvider.ApiKey apiKey = TokenUtils.parseToken(token);
            return Stream.of(new Result("Token registered successfully to monitor this deployment for Project with ID: `" + apiKey.projectId() + "`"));
        }, e -> {
            String message = "An error occurred while registering the token: " + e.getMessage();
            this.log.error(message, (Throwable)e);
            return Stream.of(new Result(message));
        });
    }

    @Procedure(name="fleetManagement.inspectToken", mode=Mode.DBMS)
    @SystemProcedure
    @Admin
    @Description(value="Inspect the Neo4j Fleet Management token to validate")
    public Stream<TokenInspectResult> inspectToken(@Name(value="token", defaultValue="") String token) {
        if (token == null || token.isEmpty()) {
            this.ensureSystemDb();
            return TransactionUtil.withTransactionAndErrorHandling(this.db, tx -> {
                Optional maybeNode = tx.findNodes(Label.label((String)"FleetManagementConfiguration")).stream().findFirst();
                if (maybeNode.isEmpty()) {
                    return Stream.of(new TokenInspectResult(null, null, "Provide a token input to inspect"));
                }
                Node node = (Node)maybeNode.get();
                String registeredToken = (String)node.getProperty("token");
                ApiKeyProvider.ApiKey apiKey = TokenUtils.parseToken(registeredToken);
                return Stream.of(new TokenInspectResult(apiKey.projectId(), apiKey.expiryTime().toString(), null));
            }, e -> {
                String message = "An error occurred while inspecting the token: " + e.getMessage();
                this.log.error(message, (Throwable)e);
                return Stream.of(new TokenInspectResult(null, null, message));
            });
        }
        try {
            ApiKeyProvider.ApiKey apiKey = TokenUtils.parseToken(token);
            return Stream.of(new TokenInspectResult(apiKey.projectId(), apiKey.expiryTime().toString(), null));
        }
        catch (IOException e2) {
            String message = "An error occurred while inspecting the token: " + e2.getMessage();
            this.log.error(message, (Throwable)e2);
            return Stream.of(new TokenInspectResult(null, null, message));
        }
    }

    @Procedure(name="fleetManagement.disable", mode=Mode.DBMS)
    @SystemProcedure
    @Admin
    @Description(value="Disable fleet management")
    public Stream<Result> disable() {
        this.ensureSystemDb();
        return TransactionUtil.withTransactionAndErrorHandling(this.db, tx -> {
            Optional<Node> maybeNode = tx.findNodes(Label.label((String)"FleetManagementConfiguration")).stream().findFirst();
            maybeNode.ifPresent(Node::delete);
            tx.commit();
            State.getInstance().setActive(false);
            return Stream.of(new Result("Fleet management has been disabled"));
        }, e -> {
            String message = "An error occurred while disabling fleet management: " + e.getMessage();
            this.log.error(message, (Throwable)e);
            return Stream.of(new Result(message));
        });
    }

    @Procedure(name="fleetManagement.status", mode=Mode.READ)
    @SystemProcedure
    @Admin
    @Description(value="Check the status of fleet management")
    public Stream<StatusResult> status() {
        State state = State.getInstance();
        boolean active = this.transactor.getTokenStatus();
        boolean connected = state.isConnected();
        String errorMessage = !active && !connected && state.getConnectionMessage() == null ? "Fleet management is disabled. Use the procedure fleetManagement.registerToken to get started." : state.getConnectionMessage();
        return Stream.of(new StatusResult(active, connected, errorMessage));
    }

    @Procedure(name="fleetManagement.restart", mode=Mode.DBMS)
    @SystemProcedure
    @Admin
    @Description(value="Restart fleet management")
    public Stream<Result> restart() {
        State state = State.getInstance();
        boolean active = this.transactor.getTokenStatus();
        boolean connected = state.isConnected();
        this.ensureSystemDb();
        return TransactionUtil.withTransactionAndErrorHandling(this.db, tx -> {
            Optional maybeNode = tx.findNodes(Label.label((String)"FleetManagementConfiguration")).stream().findFirst();
            if (maybeNode.isPresent() && ((Node)maybeNode.get()).hasProperty("token")) {
                if (active) {
                    state.setActive(false);
                }
                if (connected) {
                    state.setDisconnected("Disconnecting before restarting fleet management");
                }
                State.getInstance().setActive(true);
                return Stream.of(new Result("Fleet management is restarted"));
            }
            state.setActive(false);
            return Stream.of(new Result("Register a token to enable Fleet Management"));
        }, e -> {
            String message = "An error occurred while restarting fleet management: " + e.getMessage();
            this.log.error(message, (Throwable)e);
            return Stream.of(new Result(message));
        });
    }

    public static class TokenInspectResult {
        public String projectId;
        public String tokenExpires;
        public String errorMessage;

        public TokenInspectResult(String projectId, String expiry, String errorMessage) {
            this.projectId = projectId;
            this.tokenExpires = expiry;
            this.errorMessage = errorMessage;
        }
    }

    public static class StatusResult {
        public boolean active;
        public boolean connected;
        public String statusMessage;

        public StatusResult(boolean active, boolean connected, String message) {
            this.active = active;
            this.connected = connected;
            this.statusMessage = message;
        }
    }

    public static class Result {
        public String result;

        public Result(String result) {
            this.result = result;
        }
    }

    public static class TokenRegistrationResult
    extends TokenInspectResult {
        public String status;

        public TokenRegistrationResult(String projectId, String expiry, String errorMessage, String status) {
            super(projectId, expiry, errorMessage);
            this.status = status;
        }
    }
}

