/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.procedures;

import com.neo4j.fleetmanagement.utils.Logger;
import java.util.stream.Stream;
import org.neo4j.kernel.api.procedure.SystemProcedure;
import org.neo4j.procedure.Admin;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class DebugLogging {
    @Procedure(name="fleetManagement.debugLogging", mode=Mode.DBMS)
    @SystemProcedure
    @Admin
    @Description(value="Enable debug or payload logging for fleet management plugin.")
    public Stream<Result> debugLogging(@Name(value="debugLoggingEnabled") Boolean enabled, @Name(value="payloadLoggingEnabled") Boolean payloadLogging) {
        Logger.setDebugEnabled(enabled);
        Logger.setPayloadLoggingEnabled(payloadLogging);
        Logger.getNeo4jLogger().info("Debug logging enabled: %s, Payload logging enabled: %s", new Object[]{enabled, payloadLogging});
        return Stream.of(new Result(String.format("Debug logging enabled: %s, Payload logging enabled: %s", enabled, payloadLogging)));
    }

    public static class Result {
        public String result;

        public Result(String result) {
            this.result = result;
        }
    }
}

