/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.procedures;

import com.neo4j.fleetmanagement.configuration.Configuration;
import com.neo4j.fleetmanagement.metrics.CpuCollector;
import com.neo4j.fleetmanagement.metrics.MemoryCollector;
import com.neo4j.fleetmanagement.metrics.model.MetricsDefinition;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class MetricNamesSupplier
implements Supplier<List<String>> {
    @Override
    public List<String> get() {
        Configuration configuration = Configuration.getInstance();
        if (configuration.getMetrics() == null || configuration.getMetrics().isEmpty()) {
            return List.of();
        }
        List<String> neo4jMetrics = configuration.getMetrics().stream().map(MetricsDefinition::getMetricName).collect(Collectors.toList());
        neo4jMetrics.addAll(Arrays.stream(MemoryCollector.MetricNames.values()).map(m -> m.metricName).collect(Collectors.toList()));
        neo4jMetrics.addAll(Arrays.stream(CpuCollector.MetricNames.values()).map(m -> m.metricName).collect(Collectors.toList()));
        return neo4jMetrics;
    }
}

