/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.topology.model;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.neo4j.fleetmanagement.topology.model.Database;
import java.util.List;

public class Server {
    @JsonPropertyDescription(value="Unique identifier for the server")
    public String serverId;
    @JsonPropertyDescription(value="Name of the server")
    public String name;
    @JsonPropertyDescription(value="Network address of the server")
    public String address;
    @JsonPropertyDescription(value="Current health status of the server")
    public String health;
    @JsonPropertyDescription(value="Current state of the server")
    public String state;
    @JsonPropertyDescription(value="Mode constraint of the server")
    public String modeConstraint;
    @JsonPropertyDescription(value="Neo4j version of the server")
    public String version;
    @JsonPropertyDescription(value="List of databases hosted on this server")
    public List<Database> databases;
    @JsonPropertyDescription(value="Main license information")
    public License license;
    @JsonPropertyDescription(value="Bloom license information")
    public License bloomLicense;
    @JsonPropertyDescription(value="GDS license information")
    public License gdsLicense;
    @JsonPropertyDescription(value="List of plugins installed on the server")
    public List<Plugin> plugins;

    public static class Plugin {
        @JsonPropertyDescription(value="Filename of the plugin")
        public String filename;
        @JsonPropertyDescription(value="Manifest name of the plugin, if available")
        public String name;
        @JsonPropertyDescription(value="Manifest version of the plugin, if available")
        public String version;
        @JsonPropertyDescription(value="Manifest vendor of the plugin, if available")
        public String vendor;
    }

    public static class License {
        @JsonPropertyDescription(value="Type of the license")
        public LicenseType type;
        @JsonPropertyDescription(value="Current state of the license")
        public LicenseState state;
        @JsonPropertyDescription(value="Number of days remaining in trial period")
        public Integer daysLeftOnTrial;
        @JsonPropertyDescription(value="Total number of days in trial period")
        public Integer totalTrialDays;

        public static enum LicenseState {
            VALID,
            EXPIRED,
            NOT_ACCEPTED,
            INVALID,
            UNKNOWN;

        }

        public static enum LicenseType {
            FREE,
            COMMERCIAL,
            EVALUATION,
            UNSUPPORTED;

        }
    }
}

