/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ObjectHandler {
    public static Object handleList(List<?> list) {
        if (list.isEmpty()) {
            return list;
        }
        boolean allBasicTypes = list.stream().allMatch(ObjectHandler::isBasicType);
        if (allBasicTypes) {
            return list;
        }
        return list.stream().map(item -> {
            if (item instanceof List) {
                return ObjectHandler.handleList((List)item);
            }
            if (item instanceof Map) {
                return ObjectHandler.handleMap((Map)item);
            }
            if (!ObjectHandler.isBasicType(item)) {
                return item.toString();
            }
            return item;
        }).collect(Collectors.toList());
    }

    public static Object handleMap(Map<?, ?> map) {
        if (map.isEmpty()) {
            return map;
        }
        HashMap result = new HashMap();
        map.forEach((key, value) -> {
            if (value != null) {
                if (value instanceof List) {
                    result.put(key, ObjectHandler.handleList((List)value));
                } else if (value instanceof Map) {
                    result.put(key, ObjectHandler.handleMap((Map)value));
                } else if (!ObjectHandler.isBasicType(value)) {
                    result.put(key, value.toString());
                } else {
                    result.put(key, value);
                }
            } else {
                result.put(key, null);
            }
        });
        return result;
    }

    public static boolean isBasicType(Object obj) {
        return obj instanceof String || obj instanceof Number || obj instanceof Boolean;
    }
}

