/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.batchimport.api.Configuration;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.internal.batchimport.BuildCompletionScheduler;
import org.neo4j.internal.batchimport.IncrementalBatchImportUtil;
import org.neo4j.internal.batchimport.PopulationWorkJobScheduler;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.memory.UnsafeDirectByteBufferAllocator;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryConflictHandler;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.storageengine.api.schema.SimpleEntityValueClient;
import org.neo4j.values.ElementIdMapper;
import org.neo4j.values.storable.Value;

public class ImportIndexBuilder
implements Closeable {
    static final int BATCH_SIZE = 2000;
    private final FileSystemAbstraction fileSystem;
    private final IndexProviderMap indexProviderMap;
    private final IndexProviderMap tempIndexes;
    private final TokenNameLookup tokenNameLookup;
    private final ImmutableSet<OpenOption> openOptions;
    private final PopulationWorkJobScheduler workScheduler;
    private final LongToLongFunction indexedEntityIdConverter;
    private final LongToLongFunction entityIdFromIndexIdConverter;
    private final Configuration configuration;
    private final IndexStatisticsStore indexStatisticsStore;
    private final Map<IndexDescriptor, IndexBuilder> indexBuilders = new ConcurrentHashMap<IndexDescriptor, IndexBuilder>();
    private final Lock builderConstructionLock = new ReentrantLock();
    private final ByteBufferFactory bufferFactory;
    private final StorageEngineIndexingBehaviour indexingBehaviour;
    private final Predicate<IndexDescriptor> excludedIndexes;
    private final IndexSamplingConfig indexSamplingConfig;
    private final long maxBatchByteSize;

    public ImportIndexBuilder(FileSystemAbstraction fileSystem, IndexProviderMap indexProviderMap, IndexProviderMap tempIndexes, TokenNameLookup tokenNameLookup, ImmutableSet<OpenOption> openOptions, PopulationWorkJobScheduler workScheduler, LongToLongFunction indexedEntityIdConverter, LongToLongFunction entityIdFromIndexIdConverter, Configuration configuration, IndexStatisticsStore indexStatisticsStore, StorageEngineIndexingBehaviour indexingBehaviour, Predicate<IndexDescriptor> excludedIndexes, Config config) {
        this.fileSystem = fileSystem;
        this.indexProviderMap = indexProviderMap;
        this.tempIndexes = tempIndexes;
        this.tokenNameLookup = tokenNameLookup;
        this.openOptions = openOptions;
        this.workScheduler = workScheduler;
        this.indexedEntityIdConverter = indexedEntityIdConverter;
        this.entityIdFromIndexIdConverter = entityIdFromIndexIdConverter;
        this.configuration = configuration;
        this.indexStatisticsStore = indexStatisticsStore;
        this.indexingBehaviour = indexingBehaviour;
        this.excludedIndexes = excludedIndexes;
        this.bufferFactory = new ByteBufferFactory(UnsafeDirectByteBufferAllocator::new, ((Long)config.get(GraphDatabaseInternalSettings.index_populator_block_size)).intValue());
        this.maxBatchByteSize = (Long)config.get(GraphDatabaseInternalSettings.index_population_batch_max_byte_size);
        this.indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
    }

    public void add(IndexEntryUpdate indexUpdate) {
        IndexDescriptor indexKey = indexUpdate.indexKey();
        if (!this.excludedIndexes.test(indexKey)) {
            this.getIndexBuilder(indexKey).add(this.convertEntityId(indexUpdate));
        }
    }

    public boolean addDirect(IndexEntryUpdate indexUpdate) {
        IndexDescriptor indexKey = indexUpdate.indexKey();
        if (!this.excludedIndexes.test(indexKey)) {
            return this.getIndexBuilder(indexKey).addDirect(this.convertEntityId(indexUpdate));
        }
        return true;
    }

    private IndexEntryUpdate convertEntityId(IndexEntryUpdate indexUpdate) {
        long convertedEntityId;
        long entityId = indexUpdate.getEntityId();
        return entityId != (convertedEntityId = this.indexedEntityIdConverter.applyAsLong(entityId)) ? indexUpdate.withEntityId(convertedEntityId) : indexUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexBuilder getIndexBuilder(IndexDescriptor index) {
        IndexBuilder builder = this.indexBuilders.get(index);
        if (builder == null) {
            this.builderConstructionLock.lock();
            try {
                builder = this.indexBuilders.get(index);
                if (builder == null) {
                    IndexPopulator populator = this.constructIndexPopulator(index);
                    IndexAccessor accessor = this.constructIndexAccessor(index);
                    builder = new IndexBuilder(populator, accessor, this.maxBatchByteSize);
                    this.indexBuilders.put(index, builder);
                }
            }
            finally {
                this.builderConstructionLock.unlock();
            }
        }
        return builder;
    }

    private IndexAccessor constructIndexAccessor(IndexDescriptor index) {
        IndexProvider indexProvider = this.indexProviderMap.lookup(index.getIndexProvider());
        try {
            IndexDescriptor completedIndex = indexProvider.completeConfiguration(index, this.indexingBehaviour);
            return indexProvider.getOnlineAccessor(completedIndex, this.indexSamplingConfig, this.tokenNameLookup, ElementIdMapper.PLACEHOLDER, this.openOptions, this.indexingBehaviour);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private IndexPopulator constructIndexPopulator(IndexDescriptor index) {
        IndexProvider indexProvider = this.tempIndexes.lookup(index.getIndexProvider());
        IndexPopulator populator = indexProvider.getPopulator(index, this.indexSamplingConfig, this.bufferFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup, ElementIdMapper.PLACEHOLDER, this.openOptions, this.indexingBehaviour);
        try {
            populator.create();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return populator;
    }

    private void completeBuild(MutableLongSet violatingEntityIds, Collector collector, Consumer<Runnable> scheduler) {
        for (Map.Entry<IndexDescriptor, IndexBuilder> population : this.indexBuilders.entrySet()) {
            IndexBuilder builder = population.getValue();
            builder.flush();
            IndexPopulator populator = builder.populator;
            scheduler.accept(() -> {
                RecordingIndexEntryConflictHandler conflictHandler = new RecordingIndexEntryConflictHandler(collector, violatingEntityIds, (IndexDescriptor)population.getKey(), this.tokenNameLookup, this.entityIdFromIndexIdConverter);
                boolean successful = false;
                try {
                    populator.scanCompleted(PhaseTracker.nullInstance, (IndexPopulator.PopulationWorkScheduler)this.workScheduler, (IndexEntryConflictHandler)conflictHandler, CursorContext.NULL_CONTEXT);
                    this.indexStatisticsStore.setSampleStats(((IndexDescriptor)population.getKey()).getId(), populator.sample(CursorContext.NULL_CONTEXT));
                    successful = true;
                }
                catch (IndexEntryConflictException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    populator.close(successful, CursorContext.NULL_CONTEXT);
                }
            });
        }
    }

    public LongSet validate(Collector collector) throws IOException {
        MutableLongSet violatingEntityIds = LongSets.mutable.empty().asSynchronized();
        try (BuildCompletionScheduler scheduler = new BuildCompletionScheduler(this.workScheduler.jobScheduler());){
            this.completeBuild(violatingEntityIds, collector, scheduler);
        }
        for (Map.Entry<IndexDescriptor, IndexBuilder> population : this.indexBuilders.entrySet()) {
            IndexDescriptor descriptor = population.getKey();
            IndexBuilder builder = population.getValue();
            RecordingIndexEntryConflictHandler conflictHandler = new RecordingIndexEntryConflictHandler(collector, violatingEntityIds, descriptor, this.tokenNameLookup, this.entityIdFromIndexIdConverter);
            if (!descriptor.isUnique() || this.isEmpty(builder.accessor)) continue;
            IndexAccessor builtIncrementIndex = this.tempIndexes.lookup(descriptor.getIndexProvider()).getOnlineAccessor(descriptor, this.indexSamplingConfig, this.tokenNameLookup, ElementIdMapper.PLACEHOLDER, this.openOptions, this.indexingBehaviour);
            try {
                builder.accessor.validate(builtIncrementIndex, true, (IndexEntryConflictHandler)conflictHandler, this.configuration.maxNumberOfWorkerThreads(), this.workScheduler.jobScheduler());
            }
            finally {
                if (builtIncrementIndex == null) continue;
                builtIncrementIndex.close();
            }
        }
        return violatingEntityIds;
    }

    public void writeToTarget(LongPredicate violatingIdMapperEntityIds, LongSet otherViolatingEntityIds) {
        try {
            LongPredicate filter = violatingIdMapperEntityIds == null && otherViolatingEntityIds.isEmpty() ? null : indexEntityId -> (violatingIdMapperEntityIds == null || !violatingIdMapperEntityIds.test(indexEntityId)) && !otherViolatingEntityIds.contains(this.entityIdFromIndexIdConverter.applyAsLong(indexEntityId));
            for (Map.Entry<IndexDescriptor, IndexBuilder> population : new HashMap<IndexDescriptor, IndexBuilder>(this.indexBuilders).entrySet()) {
                IndexDescriptor descriptor = population.getKey();
                IndexBuilder builder = population.getValue();
                boolean targetIndexEmpty = this.isEmpty(builder.accessor);
                if (targetIndexEmpty && filter == null) {
                    builder.close();
                    IncrementalBatchImportUtil.moveIndex(this.fileSystem, this.tempIndexes, this.indexProviderMap, descriptor);
                    this.indexBuilders.put(descriptor, new IndexBuilder(null, this.constructIndexAccessor(descriptor), this.maxBatchByteSize));
                    continue;
                }
                IndexAccessor builtIncrementIndex = this.tempIndexes.lookup(descriptor.getIndexProvider()).getOnlineAccessor(descriptor, this.indexSamplingConfig, this.tokenNameLookup, ElementIdMapper.PLACEHOLDER, this.openOptions, this.indexingBehaviour);
                try {
                    builder.accessor.insertFrom(builtIncrementIndex, null, false, IndexEntryConflictHandler.THROW, filter, this.configuration.maxNumberOfWorkerThreads(), this.workScheduler.jobScheduler(), ProgressListener.NONE);
                }
                finally {
                    if (builtIncrementIndex == null) continue;
                    builtIncrementIndex.close();
                }
            }
        }
        catch (IndexEntryConflictException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean isEmpty(IndexAccessor accessor) {
        try (ValueIndexReader reader = accessor.newValueReader(IndexUsageTracking.NO_USAGE_TRACKING);){
            boolean bl;
            try (SimpleEntityValueClient client = new SimpleEntityValueClient();){
                reader.query((IndexProgressor.EntityValueClient)client, QueryContext.NULL_CONTEXT, CursorContext.NULL_CONTEXT, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.allEntries()});
                bl = !client.next();
            }
            return bl;
        }
        catch (IndexNotApplicableKernelException e) {
            throw new RuntimeException(e);
        }
    }

    public LongSet affectedIndexes() {
        MutableLongSet ids = LongSets.mutable.empty();
        this.indexBuilders.keySet().stream().map(IndexDescriptor::getId).forEach(arg_0 -> ((MutableLongSet)ids).add(arg_0));
        return ids;
    }

    public Optional<IndexAccessor> openIndexAccessor(long indexId) throws IOException {
        Optional<IndexDescriptor> descriptor = this.indexDescriptor(indexId);
        if (descriptor.isEmpty()) {
            return Optional.empty();
        }
        IndexAccessor accessor = this.tempIndexes.lookup(descriptor.get().getIndexProvider()).getOnlineAccessor(descriptor.get(), this.indexSamplingConfig, this.tokenNameLookup, ElementIdMapper.PLACEHOLDER, this.openOptions, this.indexingBehaviour);
        return Optional.of(accessor);
    }

    public Optional<IndexDescriptor> indexDescriptor(long indexId) {
        return this.indexBuilders.keySet().stream().filter(index -> index.getId() == indexId).findFirst();
    }

    @Override
    public void close() throws IOException {
        ArrayList<IndexBuilder> toClose = new ArrayList<IndexBuilder>(this.indexBuilders.values());
        toClose.add((IndexBuilder)this.bufferFactory);
        IOUtils.closeAll(toClose);
    }

    public static Map<String, Object> asPropertyMap(IndexDescriptor descriptor, Value[] values, TokenNameLookup tokenNameLookup) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        int[] propertyIds = descriptor.schema().getPropertyIds();
        for (int i = 0; i < propertyIds.length; ++i) {
            properties.put(tokenNameLookup.propertyKeyGetName(propertyIds[i]), values[i].asObjectCopy());
        }
        return properties;
    }

    private static class IndexBuilder
    implements AutoCloseable {
        private final IndexPopulator populator;
        private final List<IndexUpdatesBatch> allChanges = new CopyOnWriteArrayList<IndexUpdatesBatch>();
        private final ThreadLocal<IndexUpdatesBatch> changes;
        private final IndexAccessor accessor;

        IndexBuilder(IndexPopulator populator, IndexAccessor accessor, long maxByteSize) {
            this.populator = populator;
            this.changes = ThreadLocal.withInitial(() -> {
                IndexUpdatesBatch indexUpdatesBatch = new IndexUpdatesBatch(populator, accessor, maxByteSize);
                this.allChanges.add(indexUpdatesBatch);
                return indexUpdatesBatch;
            });
            this.accessor = accessor;
        }

        void add(IndexEntryUpdate indexUpdate) {
            this.changes.get().add(indexUpdate);
        }

        boolean addDirect(IndexEntryUpdate indexUpdate) {
            assert (indexUpdate.updateMode() == UpdateMode.ADDED || indexUpdate.updateMode() == UpdateMode.REMOVED);
            try (IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.DIRECT, CursorContext.NULL_CONTEXT, true);){
                updater.process(indexUpdate);
            }
            catch (IndexEntryConflictException e) {
                return false;
            }
            return true;
        }

        boolean flush() {
            boolean hasChanges = false;
            for (IndexUpdatesBatch batch : this.allChanges) {
                hasChanges |= batch.flush();
            }
            return hasChanges;
        }

        @Override
        public void close() {
            this.flush();
            this.accessor.force(FileFlushEvent.NULL, CursorContext.NULL_CONTEXT);
            this.accessor.close();
        }
    }

    private record RecordingIndexEntryConflictHandler(Collector badCollector, MutableLongSet violatingEntities, IndexDescriptor descriptor, TokenNameLookup tokenNameLookup, LongToLongFunction entityIdFromIndexIdConverter) implements IndexEntryConflictHandler
    {
        public IndexEntryConflictHandler.IndexEntryConflictAction indexEntryConflict(long firstEntityId, long otherEntityId, Value[] values) {
            long realId = this.entityIdFromIndexIdConverter.applyAsLong(otherEntityId);
            this.violatingEntities.add(realId);
            this.badCollector.collectEntityViolatingConstraint(null, realId, ImportIndexBuilder.asPropertyMap(this.descriptor, values, this.tokenNameLookup), this.descriptor.userDescription(this.tokenNameLookup), this.descriptor.schema().entityType());
            return IndexEntryConflictHandler.IndexEntryConflictAction.DELETE;
        }
    }

    private static class IndexUpdatesBatch {
        private final List<IndexEntryUpdate> changes = new ArrayList<IndexEntryUpdate>();
        private List<IndexEntryUpdate> additions = new ArrayList<IndexEntryUpdate>(2000);
        private final IndexPopulator populator;
        private final IndexAccessor accessor;
        private final long maxByteSize;
        private long additionsByteSize;
        private long changesByteSize;

        IndexUpdatesBatch(IndexPopulator populator, IndexAccessor accessor, long maxByteSize) {
            this.populator = populator;
            this.accessor = accessor;
            this.maxByteSize = maxByteSize;
        }

        void add(IndexEntryUpdate indexUpdate) {
            if (indexUpdate.updateMode() == UpdateMode.ADDED) {
                this.additionsByteSize += indexUpdate.roughSizeOfUpdate();
                this.additions.add(indexUpdate);
                this.populator.includeSample(indexUpdate);
                if (this.additions.size() == 2000) {
                    this.flushAdditions();
                }
            } else {
                this.changesByteSize += indexUpdate.roughSizeOfUpdate();
                this.changes.add(indexUpdate);
                if (this.changes.size() == 2000) {
                    this.flushChanges();
                }
            }
            if (this.additionsByteSize + this.changesByteSize >= this.maxByteSize) {
                this.flush();
            }
        }

        private boolean flush() {
            boolean hasChanges = false;
            hasChanges |= this.flushAdditions();
            return hasChanges |= this.flushChanges();
        }

        private boolean flushAdditions() {
            try {
                if (!this.additions.isEmpty()) {
                    this.populator.add(this.additions, CursorContext.NULL_CONTEXT);
                    this.additions = new ArrayList<IndexEntryUpdate>(2000);
                    this.additionsByteSize = 0L;
                    return true;
                }
                return false;
            }
            catch (IndexEntryConflictException e) {
                throw new RuntimeException(e);
            }
        }

        private boolean flushChanges() {
            boolean bl;
            block10: {
                if (this.changes.isEmpty()) {
                    return false;
                }
                IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL_CONTEXT, true);
                try {
                    for (IndexEntryUpdate change : this.changes) {
                        updater.process(change);
                    }
                    this.changes.clear();
                    this.changesByteSize = 0L;
                    bl = true;
                    if (updater == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (updater != null) {
                            try {
                                updater.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IndexEntryConflictException e) {
                        throw new RuntimeException(e);
                    }
                }
                updater.close();
            }
            return bl;
        }
    }
}

