/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.procedure.primitive.IntObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.factory.primitive.IntSets;
import org.eclipse.collections.api.factory.set.primitive.MutableIntSetFactory;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.neo4j.common.EntityType;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.SchemaCache;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.internal.schema.constraints.TypeConstraintDescriptor;

public class ImportPropertyConstraintEnforcer {
    private final IntObjectMap<MutableIntSet> entityTokenToPropertyKeys;
    private final IntObjectMap<MutableIntSet> propertyKeyToEntityTokens;
    private final IntObjectMap<List<PropertyAndType>> typeConstraints;

    public ImportPropertyConstraintEnforcer(SchemaCache schemaCache, EntityType entityType) {
        this.entityTokenToPropertyKeys = ImportPropertyConstraintEnforcer.buildPropertyExistenceConstraintsMap(schemaCache, entityType);
        this.typeConstraints = ImportPropertyConstraintEnforcer.buildPropertyTypeConstraintsMap(schemaCache, entityType);
        this.propertyKeyToEntityTokens = this.entityTokenToPropertyKeys != null ? this.reverse(this.entityTokenToPropertyKeys) : null;
    }

    private static IntObjectMap<MutableIntSet> buildPropertyExistenceConstraintsMap(SchemaCache schemaCache, EntityType entityType) {
        MutableIntObjectMap map = IntObjectMaps.mutable.empty();
        for (ConstraintDescriptor constraint : schemaCache.constraints()) {
            if (!constraint.enforcesPropertyExistence() || constraint.schema().entityType() != entityType) continue;
            SchemaDescriptor schema = constraint.schema();
            for (int entityToken : schema.getEntityTokenIds()) {
                ((MutableIntSet)map.getIfAbsentPut(entityToken, (Object)IntSets.mutable.empty())).addAll(schema.getPropertyIds());
            }
        }
        return map.isEmpty() ? null : map;
    }

    private static IntObjectMap<List<PropertyAndType>> buildPropertyTypeConstraintsMap(SchemaCache schemaCache, EntityType entityType) {
        MutableIntObjectMap map = IntObjectMaps.mutable.empty();
        for (ConstraintDescriptor constraint : schemaCache.constraints()) {
            if (!constraint.enforcesPropertyType() || constraint.schema().entityType() != entityType) continue;
            TypeConstraintDescriptor typeConstraint = constraint.asPropertyTypeConstraint();
            SchemaDescriptor schema = constraint.schema();
            for (int entityToken : schema.getEntityTokenIds()) {
                ((List)map.getIfAbsentPut(entityToken, ArrayList::new)).add(new PropertyAndType(schema.getPropertyId(), typeConstraint.propertyType()));
            }
        }
        return map;
    }

    private IntObjectMap<MutableIntSet> reverse(IntObjectMap<MutableIntSet> entityTokenToPropertyKeys) {
        MutableIntObjectMap reversed = IntObjectMaps.mutable.empty();
        entityTokenToPropertyKeys.forEachKeyValue((IntObjectProcedure & Serializable)(entityToken, propertyKeys) -> propertyKeys.forEach((IntProcedure & Serializable)key -> ((MutableIntSet)reversed.getIfAbsentPut(key, () -> ((MutableIntSetFactory)IntSets.mutable).empty())).add(entityToken)));
        return reversed;
    }

    public boolean hasPropertyExistenceConstraints() {
        return this.entityTokenToPropertyKeys != null;
    }

    public IntSet mandatoryPropertyKeys(int entityToken) {
        return !this.hasPropertyExistenceConstraints() ? IntSets.immutable.empty() : (IntSet)this.entityTokenToPropertyKeys.get(entityToken);
    }

    public IntSet mandatoryPropertyKeys(int[] entityTokens) {
        return this.buildTokenIds(entityTokens, this.entityTokenToPropertyKeys);
    }

    public IntSet entityTokensRelatedToPropertyKeys(int[] propertyKeys) {
        return this.buildTokenIds(propertyKeys, this.propertyKeyToEntityTokens);
    }

    private IntSet buildTokenIds(int[] tokens, IntObjectMap<MutableIntSet> mapping) {
        if (!this.hasPropertyExistenceConstraints()) {
            return IntSets.immutable.empty();
        }
        MutableIntSet result = IntSets.mutable.empty();
        for (int entityToken : tokens) {
            MutableIntSet mapped = (MutableIntSet)mapping.get(entityToken);
            if (mapped == null) continue;
            result.addAll((IntIterable)mapped);
        }
        return result;
    }

    public boolean hasPropertyTypeConstraints() {
        return this.typeConstraints != null;
    }

    public Iterable<PropertyAndType> propertyTypeConstraints(int entityToken) {
        if (!this.hasPropertyTypeConstraints()) {
            return Collections.emptyList();
        }
        return (Iterable)this.typeConstraints.getIfAbsent(entityToken, Collections::emptyList);
    }

    record PropertyAndType(int propertyKeyId, PropertyTypeSet type) {
    }
}

