/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

public class Utils {
    public static boolean unsignedCompare(long dataA, long dataB, CompareType compareType) {
        switch (compareType.ordinal()) {
            case 0: {
                return dataA == dataB;
            }
            case 2: {
                if (dataA == dataB) {
                    return true;
                }
            }
            case 1: {
                return dataA < dataB == (dataA < 0L != dataB < 0L);
            }
            case 4: {
                if (dataA == dataB) {
                    return true;
                }
            }
            case 3: {
                return dataA < dataB ^ dataA < 0L != dataB < 0L;
            }
            case 5: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown compare type: " + String.valueOf((Object)compareType));
    }

    public static CompareType unsignedDifference(long dataA, long dataB) {
        if (dataA == dataB) {
            return CompareType.EQ;
        }
        return dataA < dataB ^ dataA < 0L != dataB < 0L ? CompareType.LT : CompareType.GT;
    }

    public static boolean anyIdCollides(long[] first, int firstLength, long[] other, int otherLength) {
        int f = 0;
        int o = 0;
        while (f < firstLength && o < otherLength) {
            if (first[f] == other[o]) {
                return true;
            }
            if (first[f] < other[o]) {
                while (++f < firstLength && first[f] < other[o]) {
                }
                continue;
            }
            while (++o < otherLength && first[f] > other[o]) {
            }
        }
        return false;
    }

    public static void mergeSortedInto(long[] values, long[] into, int intoLengthBefore) {
        int v = values.length - 1;
        int i = intoLengthBefore - 1;
        int t = i + values.length;
        while (v >= 0 || i >= 0) {
            if (i == -1) {
                into[t--] = values[v--];
                continue;
            }
            if (v == -1) {
                into[t--] = into[i--];
                continue;
            }
            if (values[v] >= into[i]) {
                into[t--] = values[v--];
                continue;
            }
            into[t--] = into[i--];
        }
    }

    private Utils() {
    }

    public static enum CompareType {
        EQ,
        GT,
        GE,
        LT,
        LE,
        NE;

    }
}

