/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping.cuckoo;

import java.util.HashMap;
import org.neo4j.batchimport.api.PropertyValueLookup;
import org.neo4j.batchimport.api.input.Group;
import org.neo4j.batchimport.api.input.ReadableGroups;
import org.neo4j.hashing.RapidHash;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.cache.idmapping.IdMapper;
import org.neo4j.internal.batchimport.cache.idmapping.cuckoo.CuckooIdMapper;
import org.neo4j.internal.batchimport.cache.idmapping.cuckoo.KeyCollisionException;
import org.neo4j.internal.batchimport.cache.idmapping.cuckoo.StringHash;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;

public class StringCuckooIdMapper
extends CuckooIdMapper {
    private static final StringHash WY_HASH = RapidHash::hash;
    private final StringHash stringHash;
    private final HashMap<IdGroup, Long> collisions = new HashMap();
    private final PropertyValueLookup stringArray;

    public StringCuckooIdMapper(long estimatedNumberOfNodes, NumberArrayFactory arrayFactory, ReadableGroups groups, MemoryTracker memoryTracker, PropertyValueLookup stringArray) {
        this(estimatedNumberOfNodes, arrayFactory, groups, memoryTracker, WY_HASH, stringArray);
    }

    @VisibleForTesting
    StringCuckooIdMapper(long estimatedNumberOfNodes, NumberArrayFactory arrayFactory, ReadableGroups groups, MemoryTracker memoryTracker, StringHash stringHash, PropertyValueLookup stringArray) {
        super(estimatedNumberOfNodes, arrayFactory, groups, memoryTracker);
        this.stringHash = stringHash;
        this.stringArray = stringArray;
    }

    @Override
    public IdMapper.Setter newSetter() {
        return (objectInputId, actualId, group) -> {
            String inputId = objectInputId.toString();
            try {
                this.cuckooTable.insert(this.getKey(inputId, group), actualId);
            }
            catch (KeyCollisionException e) {
                if (this.isHashCollision(inputId, actualId, group)) {
                    return;
                }
                throw e;
            }
        };
    }

    @Override
    public IdMapper.Getter newGetter() {
        return new IdMapper.Getter(){

            @Override
            public long get(Object objectInputId, Group group) {
                Long collidedActualId;
                String inputId = objectInputId.toString();
                if (!StringCuckooIdMapper.this.collisions.isEmpty() && (collidedActualId = StringCuckooIdMapper.this.collisions.get(new IdGroup(inputId, group))) != null) {
                    return collidedActualId;
                }
                return StringCuckooIdMapper.this.cuckooTable.get(StringCuckooIdMapper.this.getKey(inputId, group));
            }

            @Override
            public void close() {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHashCollision(String inputId, long actualId, Group group) {
        long existingActualId = this.cuckooTable.get(this.getKey(inputId, group));
        try (PropertyValueLookup.Lookup lookup = this.stringArray.newLookup(false);){
            String existingActualString = String.valueOf(lookup.lookupProperty(existingActualId, (MemoryTracker)EmptyMemoryTracker.INSTANCE));
            if (!inputId.equals(existingActualString)) {
                HashMap<IdGroup, Long> hashMap = this.collisions;
                synchronized (hashMap) {
                    this.collisions.put(new IdGroup(inputId, group), actualId);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private long getKey(String inputId, Group group) {
        return this.stringHash.hash(inputId) << this.groupShift | (long)group.id();
    }

    private record IdGroup(String id, Group group) {
    }
}

