/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping.string;

import org.neo4j.internal.batchimport.cache.idmapping.string.Encoder;
import org.neo4j.util.Preconditions;

public class LongEncoder
implements Encoder {
    private static final long ID_BITS = 0xFFFFFFFFFFFFFFL;
    private static final long RESERVED_BITS = -72057594037927936L;

    @Override
    public long encode(Object value) {
        long longValue = LongEncoder.convertToLong(value);
        Preconditions.checkArgument(((longValue & 0xFF00000000000000L) == 0L ? 1 : 0) != 0, (String)"Invalid integer ID %d, it must be %d <= id <= 0", (Object[])new Object[]{longValue, 0xFFFFFFFFFFFFFFL});
        long length = LongEncoder.numberOfDigits(longValue);
        long returnVal = (length <<= 57) | longValue;
        return returnVal;
    }

    static long convertToLong(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.parseLong(value.toString());
    }

    private static int numberOfDigits(long value) {
        return Math.max(1, (int)(Math.log10(value) + 1.0));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

