/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.staging;

import org.neo4j.batchimport.api.Configuration;
import org.neo4j.internal.batchimport.staging.ProcessContext;
import org.neo4j.internal.batchimport.staging.ProducerStep;
import org.neo4j.internal.batchimport.staging.StageControl;

public abstract class PullingProducerStep<T extends ProcessContext>
extends ProducerStep {
    public PullingProducerStep(StageControl control, Configuration config) {
        super(control, config);
    }

    @Override
    protected void process() {
        try (T batchContext = this.processContext();){
            while (true) {
                long startTime = System.nanoTime();
                Object batch = this.nextBatchOrNull(this.doneBatches.get(), this.batchSize, batchContext);
                if (batch == null) {
                    break;
                }
                this.totalProcessingTime.add(System.nanoTime() - startTime);
                this.sendDownstream(batch);
                this.assertHealthy();
            }
        }
    }

    protected T processContext() {
        return (T)ProcessContext.EMPTY_CONTEXT;
    }

    protected abstract Object nextBatchOrNull(long var1, int var3, T var4);
}

