/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Locale;
import java.util.UUID;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.cypher.internal.AdministrationCommandRuntime;
import org.neo4j.cypher.internal.AdministrationCommandRuntime$IdentityConverter$;
import org.neo4j.cypher.internal.AdministrationCommandRuntimeContext;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.cypher.internal.ExecutionEngine;
import org.neo4j.cypher.internal.ExecutionPlan;
import org.neo4j.cypher.internal.ast.DatabaseName;
import org.neo4j.cypher.internal.ast.ExternalAuth;
import org.neo4j.cypher.internal.ast.HomeDatabaseAction;
import org.neo4j.cypher.internal.ast.NamespacedName;
import org.neo4j.cypher.internal.ast.NativeAuth;
import org.neo4j.cypher.internal.ast.ParameterName;
import org.neo4j.cypher.internal.ast.Password;
import org.neo4j.cypher.internal.ast.RemoveAuth;
import org.neo4j.cypher.internal.ast.RemoveHomeDatabaseAction$;
import org.neo4j.cypher.internal.ast.SetHomeDatabaseAction;
import org.neo4j.cypher.internal.ast.prettifier.ExpressionStringifier$;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.ListLiteral;
import org.neo4j.cypher.internal.expressions.Parameter;
import org.neo4j.cypher.internal.expressions.StringLiteral;
import org.neo4j.cypher.internal.logical.plans.NameValidator$;
import org.neo4j.cypher.internal.procs.Continue$;
import org.neo4j.cypher.internal.procs.InitAndFinallyFunctions;
import org.neo4j.cypher.internal.procs.InitAndFinallyFunctions$;
import org.neo4j.cypher.internal.procs.ParameterTransformer;
import org.neo4j.cypher.internal.procs.ParameterTransformer$;
import org.neo4j.cypher.internal.procs.QueryHandler$;
import org.neo4j.cypher.internal.procs.QueryHandlerBuilder;
import org.neo4j.cypher.internal.procs.QueryHandlerResult;
import org.neo4j.cypher.internal.procs.ThrowException;
import org.neo4j.cypher.internal.procs.UpdatingSystemCommandExecutionPlan;
import org.neo4j.cypher.internal.procs.UpdatingSystemCommandExecutionPlan$;
import org.neo4j.cypher.internal.util.HomeDatabaseNotPresent;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.cypher.internal.util.symbols.StringType;
import org.neo4j.cypher.internal.util.symbols.package$;
import org.neo4j.dbms.systemgraph.SecurityGraphDbmsModel;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.exceptions.CypherExecutionException;
import org.neo4j.exceptions.DatabaseAdministrationOnFollowerException;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.exceptions.ParameterNotFoundException;
import org.neo4j.exceptions.ParameterWrongTypeException;
import org.neo4j.gqlstatus.PrivilegeGqlCodeEntity;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.server.security.SecureHasher;
import org.neo4j.server.security.SystemGraphCredential;
import org.neo4j.server.security.systemgraph.UserSecurityGraphComponent;
import org.neo4j.string.UTF8;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.PrettyPrinter;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Using;
import scala.util.Using$;

public final class AdministrationCommandRuntime$ {
    public static final AdministrationCommandRuntime$ MODULE$ = new AdministrationCommandRuntime$();
    private static final SecureHasher secureHasher = new SecureHasher();
    private static final String internalPrefix = "__internal_";

    private SecureHasher secureHasher() {
        return secureHasher;
    }

    private String internalPrefix() {
        return internalPrefix;
    }

    public String internalKey(String name) {
        return this.internalPrefix() + name;
    }

    public byte[] validatePassword(byte[] password, Config config) {
        byte[] byArray;
        if (password == null || password.length == 0) {
            throw InvalidArgumentException.providedPasswordEmpty();
        }
        Integer minimumPasswordLength = (Integer)config.get(GraphDatabaseSettings.auth_minimum_password_length);
        CharBuffer cb = StandardCharsets.UTF_8.decode(ByteBuffer.wrap(password));
        try {
            if (cb.codePoints().count() < (long)Predef$.MODULE$.Integer2int(minimumPasswordLength)) {
                throw InvalidArgumentException.shortPassword((int)Predef$.MODULE$.Integer2int(minimumPasswordLength));
            }
            byArray = password;
        }
        finally {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), cb.length()).foreach((Function1 & Serializable)i -> cb.put(BoxesRunTime.unboxToInt((Object)i), '0'));
        }
        return byArray;
    }

    public TextValue hashPassword(byte[] initialPassword) {
        return Values.utf8Value((String)SystemGraphCredential.createCredentialForPassword((byte[])initialPassword, (SecureHasher)this.secureHasher()).serialize());
    }

    public TextValue validateAndFormatEncryptedPassword(byte[] password) {
        TextValue textValue = Values.utf8Value((String)SystemGraphCredential.serialize((byte[])password));
        return textValue;
    }

    public AdministrationCommandRuntime.PasswordExpression getPasswordExpression(Expression password, boolean isEncryptedPassword, String[] otherParams, Config config) {
        Expression expression = password;
        if (expression instanceof Parameter) {
            Parameter parameter = (Parameter)expression;
            this.validateStringParameterType(parameter);
            String hashedPwKey = this.ensureUniqueParamName(this.internalKey(parameter.name()) + "_hashed", otherParams);
            String passwordByteKey = this.ensureUniqueParamName(this.internalKey(parameter.name()) + "_bytes", otherParams);
            return new AdministrationCommandRuntime.PasswordExpression(hashedPwKey, Values.NO_VALUE, passwordByteKey, Values.NO_VALUE, (Function2<Transaction, MapValue, MapValue>)(Function2 & Serializable)(x$1, params) -> this.convertPasswordParameters$1((MapValue)params, parameter, isEncryptedPassword, config, hashedPwKey, passwordByteKey));
        }
        throw new IllegalStateException("Internal error when processing password.");
    }

    public byte[] getValidPasswordParameter(MapValue params, String passwordParameter) {
        AnyValue anyValue = params.get(passwordParameter);
        if (anyValue instanceof ByteArray) {
            ByteArray byteArray = (ByteArray)anyValue;
            return byteArray.asObject();
        }
        if (anyValue instanceof StringValue) {
            StringValue stringValue = (StringValue)anyValue;
            return UTF8.encode((String)stringValue.stringValue());
        }
        Value value = Values.NO_VALUE;
        AnyValue anyValue2 = anyValue;
        if (!(value != null ? !value.equals(anyValue2) : anyValue2 != null)) {
            throw ParameterNotFoundException.expectedParam((String)passwordParameter, (Iterable)params.keySet());
        }
        throw ParameterWrongTypeException.expectedPasswordToBeString((String)passwordParameter, (String)anyValue.getTypeName());
    }

    public String ensureUniqueParamName(String originalName, String[] otherParams) {
        ObjectRef uniqueName = ObjectRef.create((Object)originalName);
        IndexedSeq params = Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])otherParams), (Ordering)Ordering.String$.MODULE$));
        params.foreach((Function1 & Serializable)otherParamName -> {
            AdministrationCommandRuntime$.$anonfun$ensureUniqueParamName$1(uniqueName, otherParamName);
            return BoxedUnit.UNIT;
        });
        return (String)uniqueName.elem;
    }

    public void validateStringParameterType(Parameter param) {
        CypherType cypherType = param.parameterType();
        if (cypherType instanceof StringType) {
            return;
        }
        throw ParameterWrongTypeException.onlyStringValuesAsPassword((String)param.name(), (String)String.valueOf(package$.MODULE$.CTString()), (String)String.valueOf(param.parameterType()));
    }

    public Option<String> getParameterName(Either<String, Parameter> parameter) {
        return parameter.toOption().map((Function1 & Serializable)x$2 -> x$2.name());
    }

    public ExecutionPlan makeCreateUserExecutionPlan(Either<String, Parameter> userName, boolean suspended, Option<HomeDatabaseAction> defaultDatabase, Option<NativeAuth> nativeAuth, Seq<ExternalAuth> externalAuths, Function2<Seq<ExternalAuth>, Option<NativeAuth>, QueryHandlerResult> validateAuth, Option<ExecutionPlan> sourcePlan, ExecutionEngine normalExecutionEngine, SecurityAuthorizationHandler securityAuthorizationHandler, Config config) {
        Option changeRequiredOption = nativeAuth.map((Function1 & Serializable)auth -> BoxesRunTime.boxToBoolean((boolean)AdministrationCommandRuntime$.$anonfun$makeCreateUserExecutionPlan$1(auth)));
        String passwordChangeRequiredKey = this.internalKey("passwordChangeRequired");
        String suspendedKey = this.internalKey("suspended");
        String uuidKey = this.internalKey("uuid");
        String authKey = this.internalKey("auth");
        Option homeDatabaseFields = defaultDatabase.map((Function1 & Serializable)x0$1 -> {
            HomeDatabaseAction homeDatabaseAction = x0$1;
            if (RemoveHomeDatabaseAction$.MODULE$.equals(homeDatabaseAction)) {
                return new AdministrationCommandRuntime.DatabaseNameFields(MODULE$.internalPrefix() + "homeDatabase", Values.NO_VALUE, MODULE$.internalPrefix() + "homeDatabase_namespace", Values.NO_VALUE, MODULE$.internalPrefix() + "homeDatabase_displayName", Values.NO_VALUE, MODULE$.internalPrefix() + "homeDatabase_quotedDisplayName", Values.NO_VALUE, false, AdministrationCommandRuntime$IdentityConverter$.MODULE$);
            }
            if (homeDatabaseAction instanceof SetHomeDatabaseAction) {
                SetHomeDatabaseAction setHomeDatabaseAction = (SetHomeDatabaseAction)homeDatabaseAction;
                DatabaseName name = setHomeDatabaseAction.name();
                return MODULE$.getDatabaseNameFields("homeDatabase", name, true);
            }
            throw new MatchError((Object)homeDatabaseAction);
        });
        AdministrationCommandRuntime.NameFields userNameFields = this.getNameFields("username", userName, this.getNameFields$default$3());
        String[] nonPasswordParameterNames = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{userNameFields.nameKey(), uuidKey, suspendedKey, authKey}), (IterableOnce)homeDatabaseFields.map((Function1 & Serializable)x$5 -> x$5.displayNameKey()), ClassTag$.MODULE$.apply(String.class))), (IterableOnce)changeRequiredOption.map((Function1 & Serializable)x$6 -> passwordChangeRequiredKey), ClassTag$.MODULE$.apply(String.class));
        Option credentialsOption = Option$.MODULE$.option2Iterable(nativeAuth.map((Function1 & Serializable)x$7 -> x$7.password())).collectFirst((PartialFunction)new Serializable(nonPasswordParameterNames, config){
            private static final long serialVersionUID = 0L;
            private final String[] nonPasswordParameterNames$1;
            private final Config config$2;

            public final <A1 extends Option<Password>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Some some;
                Password password;
                A1 A1 = x1;
                if (A1 instanceof Some && (password = (Password)(some = (Some)A1).value()) != null) {
                    Expression password2 = password.password();
                    boolean isEncrypted = password.isEncrypted();
                    return (B1)AdministrationCommandRuntime$.MODULE$.getPasswordExpression(password2, isEncrypted, this.nonPasswordParameterNames$1, this.config$2);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Option<Password> x1) {
                Some some;
                Password password;
                Option<Password> option = x1;
                return option instanceof Some && (password = (Password)(some = (Some)option).value()) != null;
            }
            {
                this.nonPasswordParameterNames$1 = nonPasswordParameterNames$1;
                this.config$2 = config$2;
            }
        });
        String homeDatabaseCypher = (String)homeDatabaseFields.map((Function1 & Serializable)ddf -> ", homeDatabase: $`" + ddf.displayNameKey() + "`").getOrElse((Function0 & Serializable)() -> "");
        String nativeAuthCypher = (String)credentialsOption.map((Function1 & Serializable)credentials -> ", credentials: $`" + credentials.key() + "`, passwordChangeRequired: $`" + passwordChangeRequiredKey + "`").getOrElse((Function0 & Serializable)() -> "");
        ParameterTransformer parameterTransformer = ParameterTransformer$.MODULE$.apply((Function3<Transaction, SecurityContext, MapValue, MapValue>)AdministrationCommandRuntime$.authMapGenerator$1(externalAuths, nativeAuth, authKey, uuidKey)).convert(userNameFields.nameConverter()).optionallyConvert((Option<Function2<Transaction, MapValue, MapValue>>)homeDatabaseFields.map((Function1 & Serializable)x$11 -> x$11.nameConverter())).optionallyConvert((Option<Function2<Transaction, MapValue, MapValue>>)credentialsOption.map((Function1 & Serializable)x$12 -> x$12.mapValueConverter())).validate((Function2<Transaction, MapValue, Tuple2<MapValue, Set<InternalNotification>>>)(Function2 & Serializable)(tx, params) -> MODULE$.isHomeDatabasePresent((Option<AdministrationCommandRuntime.DatabaseNameFields>)homeDatabaseFields, (Transaction)tx, (MapValue)params));
        String x$17 = "CreateUser";
        ExecutionEngine x$2 = normalExecutionEngine;
        SecurityAuthorizationHandler x$3 = securityAuthorizationHandler;
        String x$4 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE (u:" + SecurityGraphDbmsModel.USER + " {name: $`" + userNameFields.nameKey() + "`, id: $`" + uuidKey + "`, suspended: $`" + suspendedKey + "`\n         |" + nativeAuthCypher + "\n         |" + homeDatabaseCypher + " })\n         |WITH u\n         |CALL {\n         |  WITH u\n         |  UNWIND $`" + authKey + "` AS auth\n         |  CREATE (u)-[:" + SecurityGraphDbmsModel.HAS_AUTH + "]->(:" + SecurityGraphDbmsModel.AUTH + " {provider: auth.provider, id: auth.id})\n         |}\n         |RETURN u.name"));
        MapValue x$52 = VirtualValues.map((String[])((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])credentialsOption.map((Function1 & Serializable)credentials -> (String[])((Object[])new String[]{credentials.key(), credentials.bytesKey()})).getOrElse((Function0 & Serializable)() -> (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)))), (Object)nonPasswordParameterNames, ClassTag$.MODULE$.apply(String.class))), (AnyValue[])((AnyValue[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])credentialsOption.map((Function1 & Serializable)credentials -> (AnyValue[])((Object[])new AnyValue[]{credentials.value(), credentials.bytesValue()})).getOrElse((Function0 & Serializable)() -> (AnyValue[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(AnyValue.class)))), (Object)new AnyValue[]{userNameFields.nameValue(), Values.NO_VALUE, Values.booleanValue((boolean)suspended), Values.NO_VALUE}, ClassTag$.MODULE$.apply(AnyValue.class))), (IterableOnce)homeDatabaseFields.map((Function1 & Serializable)x$13 -> x$13.displayNameValue()), ClassTag$.MODULE$.apply(AnyValue.class))), (IterableOnce)changeRequiredOption.map((Function1 & Serializable)x$1 -> AdministrationCommandRuntime$.$anonfun$makeCreateUserExecutionPlan$22(BoxesRunTime.unboxToBoolean((Object)x$1))), ClassTag$.MODULE$.apply(AnyValue.class))));
        QueryHandlerBuilder x$62 = QueryHandler$.MODULE$.handleNoResult((Function1<MapValue, Option<QueryHandlerResult>>)(Function1 & Serializable)params -> new Some((Object)new ThrowException((Throwable)CypherExecutionException.createEntity((String)"user", (String)MODULE$.runtimeStringValue(userName, (MapValue)params, MODULE$.runtimeStringValue$default$3()))))).handleError((Function2<Throwable, MapValue, Throwable>)(Function2 & Serializable)(error, params) -> {
            Throwable e;
            Throwable e2;
            Tuple2 tuple2 = new Tuple2(error, (Object)error.getCause());
            if (tuple2 != null && (e2 = (Throwable)tuple2._2()) instanceof UniquePropertyValueValidationException) {
                UniquePropertyValueValidationException uniquePropertyValueValidationException = (UniquePropertyValueValidationException)e2;
                if (uniquePropertyValueValidationException.constraint().getName().equals("auth-constraint")) {
                    return InvalidArgumentException.providerIdCombinationAlreadyInUseCreate((String)MODULE$.runtimeStringValue(userName, (MapValue)params, MODULE$.runtimeStringValue$default$3()));
                }
                return InvalidArgumentException.createEntityAlreadyExists((PrivilegeGqlCodeEntity)PrivilegeGqlCodeEntity.USER, (String)MODULE$.runtimeStringValue(userName, (MapValue)params, MODULE$.runtimeStringValue$default$3()));
            }
            if (tuple2 != null && (e = (Throwable)tuple2._1()) instanceof Status.HasStatus) {
                Throwable throwable = e;
                Status status = ((Status.HasStatus)throwable).status();
                Status.Cluster cluster = Status.Cluster.NotALeader;
                if (!(status != null ? !status.equals(cluster) : cluster != null)) {
                    return DatabaseAdministrationOnFollowerException.notALeader((String)"CREATE USER", (String)("Failed to create the specified user '" + MODULE$.runtimeStringValue(userName, (MapValue)params, MODULE$.runtimeStringValue$default$3()) + "'"), (Throwable)error);
                }
            }
            return CypherExecutionException.createEntityCause((String)"user", (String)MODULE$.runtimeStringValue(userName, (MapValue)params, MODULE$.runtimeStringValue$default$3()), (Throwable)error);
        }).handleResult((Function3<Object, AnyValue, MapValue, QueryHandlerResult>)(Function3 & Serializable)(x$14, x$15, x$16) -> AdministrationCommandRuntime$.$anonfun$makeCreateUserExecutionPlan$25(validateAuth, externalAuths, nativeAuth, BoxesRunTime.unboxToInt((Object)x$14), x$15, x$16));
        Option<ExecutionPlan> x$72 = sourcePlan;
        InitAndFinallyFunctions x$8 = new InitAndFinallyFunctions((Function1<MapValue, Object>)(Function1 & Serializable)params -> BoxesRunTime.boxToBoolean((boolean)NameValidator$.MODULE$.assertValidUsername(AdministrationCommandRuntime$.MODULE$.runtimeStringValue((Either<String, Parameter>)userName, params, AdministrationCommandRuntime$.MODULE$.runtimeStringValue$default$3()))), (Function1<MapValue, BoxedUnit>)(Function1 & Serializable)p -> {
            credentialsOption.foreach((Function1 & Serializable)credentials -> {
                AdministrationCommandRuntime$.$anonfun$makeCreateUserExecutionPlan$28(p, credentials);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        ParameterTransformer x$9 = parameterTransformer;
        boolean x$10 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$8();
        Function1<Transaction, BoxedUnit> x$112 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$11();
        return new UpdatingSystemCommandExecutionPlan("CreateUser", x$2, x$3, x$4, x$52, x$62, x$72, x$10, x$8, x$9, x$112);
    }

    public Function2<Seq<ExternalAuth>, Option<NativeAuth>, QueryHandlerResult> makeCreateUserExecutionPlan$default$6() {
        return (Function2 & Serializable)(x$3, x$4) -> Continue$.MODULE$;
    }

    public ExecutionPlan makeAlterUserExecutionPlan(Either<String, Parameter> userName, Option<Object> suspended, Option<HomeDatabaseAction> homeDatabase, Option<NativeAuth> nativeAuth, Seq<ExternalAuth> externalAuths, RemoveAuth removeAuths, Function2<Seq<ExternalAuth>, Option<NativeAuth>, QueryHandlerResult> validateAuth, Option<ExecutionPlan> sourcePlan, ExecutionEngine normalExecutionEngine, SecurityAuthorizationHandler securityAuthorizationHandler, UserSecurityGraphComponent userSecurityGraphComponent, Config config) {
        AdministrationCommandRuntime.NameFields userNameFields = this.getNameFields("username", userName, this.getNameFields$default$3());
        String setAuthKey = this.internalKey("setAuth");
        String removeAuthKey = this.internalKey("removeAuth");
        String removeNativeKey = this.internalKey("removeNative");
        String enforceAuthKey = this.internalKey("enforceAuth");
        Option homeDatabaseFields = homeDatabase.map((Function1 & Serializable)x0$1 -> {
            HomeDatabaseAction homeDatabaseAction = x0$1;
            if (RemoveHomeDatabaseAction$.MODULE$.equals(homeDatabaseAction)) {
                return new AdministrationCommandRuntime.DatabaseNameFields(MODULE$.internalPrefix() + "homeDatabase", Values.NO_VALUE, MODULE$.internalPrefix() + "homeDatabase_namespace", Values.NO_VALUE, MODULE$.internalPrefix() + "homeDatabase_displayName", Values.NO_VALUE, MODULE$.internalPrefix() + "homeDatabase_quotedDisplayName", Values.NO_VALUE, false, AdministrationCommandRuntime$IdentityConverter$.MODULE$);
            }
            if (homeDatabaseAction instanceof SetHomeDatabaseAction) {
                SetHomeDatabaseAction setHomeDatabaseAction = (SetHomeDatabaseAction)homeDatabaseAction;
                DatabaseName name = setHomeDatabaseAction.name();
                return MODULE$.getDatabaseNameFields("homeDatabase", name, true);
            }
            throw new MatchError((Object)homeDatabaseAction);
        });
        String[] nonPasswordParameterNames = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{userNameFields.nameKey()}), (IterableOnce)homeDatabaseFields.map((Function1 & Serializable)x$19 -> x$19.displayNameKey()), ClassTag$.MODULE$.apply(String.class))), (Object)new String[]{setAuthKey, removeAuthKey, removeNativeKey, enforceAuthKey}, ClassTag$.MODULE$.apply(String.class));
        Option maybePw = Option$.MODULE$.option2Iterable(nativeAuth.map((Function1 & Serializable)x$20 -> x$20.password())).collectFirst((PartialFunction)new Serializable(nonPasswordParameterNames, config){
            private static final long serialVersionUID = 0L;
            private final String[] nonPasswordParameterNames$2;
            private final Config config$3;

            public final <A1 extends Option<Password>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Some some;
                Password password;
                A1 A1 = x1;
                if (A1 instanceof Some && (password = (Password)(some = (Some)A1).value()) != null) {
                    Expression password2 = password.password();
                    boolean isEncrypted = password.isEncrypted();
                    return (B1)AdministrationCommandRuntime$.MODULE$.getPasswordExpression(password2, isEncrypted, this.nonPasswordParameterNames$2, this.config$3);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Option<Password> x1) {
                Some some;
                Password password;
                Option<Password> option = x1;
                return option instanceof Some && (password = (Password)(some = (Some)option).value()) != null;
            }
            {
                this.nonPasswordParameterNames$2 = nonPasswordParameterNames$2;
                this.config$3 = config$3;
            }
        });
        Seq params2 = (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)maybePw), (Object)"credentials"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nativeAuth.flatMap((Function1 & Serializable)x$21 -> x$21.changeRequired())), (Object)"passwordChangeRequired"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(suspended), (Object)"suspended"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)homeDatabaseFields), (Object)"homeDatabase"), (List)Nil$.MODULE$)))).flatMap((Function1 & Serializable)param -> {
            Object nameFields;
            Object nameFields2;
            Object passwordExpression;
            boolean bl = false;
            Some some = null;
            Option option = (Option)param._1();
            if (None$.MODULE$.equals(option)) {
                return (Seq)scala.package$.MODULE$.Seq().empty();
            }
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                Object boolExpr = some.value();
                if (boolExpr instanceof Boolean) {
                    boolean bl2 = BoxesRunTime.unboxToBoolean((Object)boolExpr);
                    return new .colon.colon((Object)new Tuple3(param._2(), (Object)MODULE$.internalKey((String)param._2()), (Object)Values.booleanValue((boolean)bl2)), (List)Nil$.MODULE$);
                }
            }
            if (bl && (passwordExpression = some.value()) instanceof AdministrationCommandRuntime.PasswordExpression) {
                AdministrationCommandRuntime.PasswordExpression passwordExpression2 = (AdministrationCommandRuntime.PasswordExpression)passwordExpression;
                return new .colon.colon((Object)new Tuple3(param._2(), (Object)passwordExpression2.key(), (Object)passwordExpression2.value()), (List)Nil$.MODULE$);
            }
            if (bl && (nameFields2 = some.value()) instanceof AdministrationCommandRuntime.NameFields) {
                AdministrationCommandRuntime.NameFields nameFields3 = (AdministrationCommandRuntime.NameFields)nameFields2;
                return new .colon.colon((Object)new Tuple3(param._2(), (Object)nameFields3.nameKey(), (Object)nameFields3.nameValue()), (List)Nil$.MODULE$);
            }
            if (bl && (nameFields = some.value()) instanceof AdministrationCommandRuntime.DatabaseNameFields) {
                AdministrationCommandRuntime.DatabaseNameFields databaseNameFields = (AdministrationCommandRuntime.DatabaseNameFields)nameFields;
                return new .colon.colon((Object)new Tuple3(param._2(), (Object)databaseNameFields.displayNameKey(), (Object)databaseNameFields.displayNameValue()), (List)Nil$.MODULE$);
            }
            if (bl) {
                Object p = some.value();
                throw InvalidArgumentException.invalidOptionTypeForAlterUser((String)String.valueOf(p), (String)String.valueOf(p.getClass().getSimpleName()));
            }
            throw new MatchError((Object)option);
        });
        Tuple3 tuple3 = (Tuple3)params2.foldLeft((Object)new Tuple3((Object)"", (Object)scala.package$.MODULE$.Seq().empty(), (Object)scala.package$.MODULE$.Seq().empty()), (Function2 & Serializable)(acc, param) -> {
            String propertyName = (String)param._1();
            String key = (String)param._2();
            Value value = (Value)param._3();
            return new Tuple3((Object)((String)acc._1() + " SET user." + propertyName + " = $`" + key + "`"), ((SeqOps)acc._2()).$colon$plus((Object)key), ((SeqOps)acc._3()).$colon$plus((Object)value));
        });
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        String setParts = (String)tuple3._1();
        Seq keys = (Seq)tuple3._2();
        Seq values2 = (Seq)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)setParts, (Object)keys, (Object)values2);
        String setParts2 = (String)tuple32._1();
        Seq keys2 = (Seq)tuple32._2();
        Seq values3 = (Seq)tuple32._3();
        String[] parameterKeys = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])((IterableOnceOps)((SeqOps)keys2.$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(maybePw.map((Function1 & Serializable)x$23 -> x$23.bytesKey())).toSeq())).$colon$plus((Object)userNameFields.nameKey())).toArray(ClassTag$.MODULE$.apply(String.class))), (Object)new String[]{setAuthKey, removeAuthKey, removeNativeKey, enforceAuthKey}, ClassTag$.MODULE$.apply(String.class));
        AnyValue[] parameterValues = (AnyValue[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])((IterableOnceOps)((SeqOps)values3.$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(maybePw.map((Function1 & Serializable)x$24 -> x$24.bytesValue())).toSeq())).$colon$plus((Object)userNameFields.nameValue())).toArray(ClassTag$.MODULE$.apply(Value.class))), (Object)new AnyValue[]{Values.NO_VALUE, Values.NO_VALUE, Values.NO_VALUE, Values.NO_VALUE}, ClassTag$.MODULE$.apply(AnyValue.class));
        String authMatch = removeAuths.all() ? "OPTIONAL MATCH (user)-[:" + SecurityGraphDbmsModel.HAS_AUTH + "]->(a:" + SecurityGraphDbmsModel.AUTH + ")" : StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("UNWIND $`" + removeAuthKey + "` AS auth\n             |  OPTIONAL MATCH (user)-[:" + SecurityGraphDbmsModel.HAS_AUTH + "]->(a:" + SecurityGraphDbmsModel.AUTH + " {provider: auth})"));
        String removeAuthString = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("WITH user, oldCredentials\n         |CALL {\n         |  WITH user\n         |  WITH user,\n         |  CASE\n         |    WHEN $`" + removeNativeKey + "` THEN {credentials: null, change: null}\n         |    ELSE {credentials: user.credentials, change: user.passwordChangeRequired}\n         |  END AS cMap\n         |  SET user.credentials = cMap.credentials, user.passwordChangeRequired = cMap.change\n         |}\n         |WITH user, oldCredentials\n         |CALL {\n         |  WITH user\n         |  " + authMatch + "\n         |  DETACH DELETE (a)\n         |}"));
        String addNativeAuthString = nativeAuth.nonEmpty() ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("MERGE (user)-[:" + SecurityGraphDbmsModel.HAS_AUTH + "]->(:" + SecurityGraphDbmsModel.AUTH + " {provider: 'native', id: user.id})\n           |SET user.passwordChangeRequired = coalesce(user.passwordChangeRequired, true)")) : "";
        String nativeAuthValid = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |WITH user, oldCredentials\n         |OPTIONAL MATCH (user)-[:" + SecurityGraphDbmsModel.HAS_AUTH + "]->(nativeAuth:" + SecurityGraphDbmsModel.AUTH + " {provider: 'native'})\n         |WITH user, oldCredentials,\n         | CASE EXISTS { (nativeAuth) }\n         |  WHEN true THEN EXISTS { (user) WHERE user.credentials IS NOT NULL AND user.passwordChangeRequired IS NOT NULL }\n         |  ELSE true\n         | END AS validNativeAuth\n         |"));
        String addAuthString = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("WITH user, oldCredentials\n         |CALL {\n         |  WITH user\n         |  UNWIND $`" + setAuthKey + "` AS auth\n         |  MERGE (user)-[:" + SecurityGraphDbmsModel.HAS_AUTH + "]->(a:" + SecurityGraphDbmsModel.AUTH + " {provider: auth.provider}) SET a.id = auth.id\n         |}"));
        String enforceAuthString = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CASE $`" + enforceAuthKey + "`\n         | WHEN true THEN EXISTS { (user)-[:" + SecurityGraphDbmsModel.HAS_AUTH + "]->(:" + SecurityGraphDbmsModel.AUTH + ") }\n         | ELSE true\n         |END AS authOk\n         |"));
        ParameterTransformer parameterTransformer = new ParameterTransformer(ParameterTransformer$.MODULE$.apply$default$1(), ParameterTransformer$.MODULE$.apply$default$2()).generate((Function3<Transaction, SecurityContext, MapValue, MapValue>)AdministrationCommandRuntime$.enforceAuthGen$1(userSecurityGraphComponent, enforceAuthKey)).generate((Function3<Transaction, SecurityContext, MapValue, MapValue>)AdministrationCommandRuntime$.authMapGenerator$2(externalAuths, removeAuths, setAuthKey, removeAuthKey, removeNativeKey)).convert(userNameFields.nameConverter()).optionallyConvert((Option<Function2<Transaction, MapValue, MapValue>>)homeDatabaseFields.map((Function1 & Serializable)x$29 -> x$29.nameConverter())).optionallyConvert((Option<Function2<Transaction, MapValue, MapValue>>)maybePw.map((Function1 & Serializable)x$30 -> x$30.mapValueConverter())).validate((Function2<Transaction, MapValue, Tuple2<MapValue, Set<InternalNotification>>>)(Function2 & Serializable)(tx, params) -> MODULE$.isHomeDatabasePresent((Option<AdministrationCommandRuntime.DatabaseNameFields>)homeDatabaseFields, (Transaction)tx, (MapValue)params));
        String x$3 = "AlterUser";
        ExecutionEngine x$4 = normalExecutionEngine;
        SecurityAuthorizationHandler x$5 = securityAuthorizationHandler;
        String x$6 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("MATCH (user:" + SecurityGraphDbmsModel.USER + " {name: $`" + userNameFields.nameKey() + "`})\n         |WITH user, user.credentials AS oldCredentials\n         |" + removeAuthString + "\n         |" + setParts2 + "\n         |" + addNativeAuthString + "\n         |" + addAuthString + "\n         |" + nativeAuthValid + "\n         |RETURN EXISTS { (user:" + SecurityGraphDbmsModel.USER + " {name: $`" + userNameFields.nameKey() + "`}) } AS exists,\n         |oldCredentials, " + enforceAuthString + ", validNativeAuth "));
        MapValue x$7 = VirtualValues.map((String[])parameterKeys, (AnyValue[])parameterValues);
        QueryHandlerBuilder x$8 = QueryHandler$.MODULE$.handleNoResult((Function1<MapValue, Option<QueryHandlerResult>>)(Function1 & Serializable)p -> new Some((Object)new ThrowException(InvalidArgumentException.alterMissingUser((String)MODULE$.runtimeStringValue(userName, (MapValue)p, MODULE$.runtimeStringValue$default$3()), (String)((String)MODULE$.getParameterName(userName).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())))))).handleError((Function2<Throwable, MapValue, Throwable>)(Function2 & Serializable)(error, p) -> {
            Throwable e;
            Tuple2 tuple2 = new Tuple2(error, (Object)error.getCause());
            if (tuple2 != null && tuple2._2() instanceof UniquePropertyValueValidationException) {
                return InvalidArgumentException.providerIdCombinationAlreadyInUseAlter((String)MODULE$.runtimeStringValue(userName, (MapValue)p, MODULE$.runtimeStringValue$default$3()));
            }
            if (tuple2 != null && (e = (Throwable)tuple2._1()) instanceof Status.HasStatus) {
                Throwable throwable = e;
                Status status = ((Status.HasStatus)throwable).status();
                Status.Cluster cluster = Status.Cluster.NotALeader;
                if (!(status != null ? !status.equals(cluster) : cluster != null)) {
                    return DatabaseAdministrationOnFollowerException.notALeader((String)"ALTER USER", (String)("Failed to alter the specified user '" + MODULE$.runtimeStringValue(userName, (MapValue)p, MODULE$.runtimeStringValue$default$3()) + "'"), (Throwable)error);
                }
            }
            return CypherExecutionException.alterEntityCause((String)"user", (String)MODULE$.runtimeStringValue(userName, (MapValue)p, MODULE$.runtimeStringValue$default$3()), (Throwable)error);
        }).handleResult((Function3<Object, AnyValue, MapValue, QueryHandlerResult>)(Function3 & Serializable)(x0$2, x1$1, x2$1) -> AdministrationCommandRuntime$.$anonfun$makeAlterUserExecutionPlan$19(userName, maybePw, validateAuth, externalAuths, nativeAuth, BoxesRunTime.unboxToInt((Object)x0$2), x1$1, x2$1));
        Option<ExecutionPlan> x$9 = sourcePlan;
        Function1 & Serializable x$1 = (Function1 & Serializable)p -> {
            maybePw.foreach((Function1 & Serializable)newPw -> {
                AdministrationCommandRuntime$.$anonfun$makeAlterUserExecutionPlan$23(p, newPw);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        };
        Function1<MapValue, Object> x$2 = InitAndFinallyFunctions$.MODULE$.apply$default$1();
        InitAndFinallyFunctions x$10 = new InitAndFinallyFunctions(x$2, (Function1<MapValue, BoxedUnit>)x$1);
        ParameterTransformer x$11 = parameterTransformer;
        boolean x$12 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$8();
        Function1<Transaction, BoxedUnit> x$13 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$11();
        return new UpdatingSystemCommandExecutionPlan("AlterUser", x$4, x$5, x$6, x$7, x$8, x$9, x$12, x$10, x$11, x$13);
    }

    public Function2<Seq<ExternalAuth>, Option<NativeAuth>, QueryHandlerResult> makeAlterUserExecutionPlan$default$7() {
        return (Function2 & Serializable)(x$17, x$18) -> Continue$.MODULE$;
    }

    private Tuple2<MapValue, Set<InternalNotification>> isHomeDatabasePresent(Option<AdministrationCommandRuntime.DatabaseNameFields> homeDatabaseFields, Transaction tx, MapValue params) {
        return (Tuple2)homeDatabaseFields.map((Function1 & Serializable)ddf -> {
            AnyValue anyValue = params.get(ddf.displayNameKey());
            if (anyValue instanceof TextValue) {
                TextValue textValue = (TextValue)anyValue;
                Set notifications = Iterators.asList((Iterator)tx.findNodes(TopologyGraphDbmsModel.DATABASE_NAME_LABEL, "displayName", (Object)textValue.stringValue())).isEmpty() ? (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InternalNotification[]{new HomeDatabaseNotPresent(textValue.stringValue())})) : Predef$.MODULE$.Set().empty();
                return new Tuple2((Object)params, (Object)notifications);
            }
            return new Tuple2((Object)params, (Object)Predef$.MODULE$.Set().empty());
        }).getOrElse((Function0 & Serializable)() -> new Tuple2((Object)params, (Object)Predef$.MODULE$.Set().empty()));
    }

    public ExecutionPlan makeRenameExecutionPlan(PrivilegeGqlCodeEntity entityType, String namePropKey, Either<String, Parameter> fromName, Either<String, Parameter> toName, Function1<MapValue, Object> initFunction, Option<ExecutionPlan> sourcePlan, ExecutionEngine normalExecutionEngine, SecurityAuthorizationHandler securityAuthorizationHandler) {
        String string;
        PrivilegeGqlCodeEntity privilegeGqlCodeEntity = entityType;
        if (PrivilegeGqlCodeEntity.USER.equals(privilegeGqlCodeEntity)) {
            string = SecurityGraphDbmsModel.USER;
        } else if (PrivilegeGqlCodeEntity.ROLE.equals(privilegeGqlCodeEntity)) {
            string = SecurityGraphDbmsModel.ROLE;
        } else if (PrivilegeGqlCodeEntity.DATABASE.equals(privilegeGqlCodeEntity)) {
            string = TopologyGraphDbmsModel.DATABASE_NAME;
        } else if (PrivilegeGqlCodeEntity.DATABASE_ALIAS.equals(privilegeGqlCodeEntity)) {
            string = TopologyGraphDbmsModel.DATABASE_NAME;
        } else {
            throw new MatchError((Object)privilegeGqlCodeEntity);
        }
        String entity = string;
        AdministrationCommandRuntime.NameFields fromNameFields = this.getNameFields("fromName", fromName, this.getNameFields$default$3());
        AdministrationCommandRuntime.NameFields toNameFields = this.getNameFields("toName", toName, this.getNameFields$default$3());
        ParameterTransformer parameterTransformer = new ParameterTransformer(ParameterTransformer$.MODULE$.apply$default$1(), ParameterTransformer$.MODULE$.apply$default$2()).convert(fromNameFields.nameConverter()).convert(toNameFields.nameConverter());
        String x$1 = "Create" + entity;
        ExecutionEngine x$2 = normalExecutionEngine;
        SecurityAuthorizationHandler x$3 = securityAuthorizationHandler;
        String x$4 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("MATCH (old:" + entity + " {" + namePropKey + ": $`" + fromNameFields.nameKey() + "`})\n         |SET old." + namePropKey + " = $`" + toNameFields.nameKey() + "`\n         |RETURN old." + namePropKey + "\n        "));
        MapValue x$5 = VirtualValues.map((String[])((String[])((Object[])new String[]{fromNameFields.nameKey(), toNameFields.nameKey()})), (AnyValue[])((AnyValue[])((Object[])new AnyValue[]{fromNameFields.nameValue(), toNameFields.nameValue()})));
        QueryHandlerBuilder x$6 = QueryHandler$.MODULE$.handleNoResult((Function1<MapValue, Option<QueryHandlerResult>>)(Function1 & Serializable)p -> new Some((Object)new ThrowException(InvalidArgumentException.renameEntityNotFound((PrivilegeGqlCodeEntity)entityType, (String)MODULE$.runtimeStringValue(fromName, (MapValue)p, MODULE$.runtimeStringValue$default$3()), (String)MODULE$.runtimeStringValue(toName, (MapValue)p, MODULE$.runtimeStringValue$default$3()), (String)((String)MODULE$.getParameterName(fromName).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())))))).handleError((Function2<Throwable, MapValue, Throwable>)(Function2 & Serializable)(error, p) -> {
            Throwable e;
            Tuple2 tuple2 = new Tuple2(error, (Object)error.getCause());
            if (tuple2 != null && tuple2._2() instanceof UniquePropertyValueValidationException) {
                return InvalidArgumentException.renameEntityAlreadyExists((PrivilegeGqlCodeEntity)entityType, (String)MODULE$.runtimeStringValue(fromName, (MapValue)p, MODULE$.runtimeStringValue$default$3()), (String)MODULE$.runtimeStringValue(toName, (MapValue)p, MODULE$.runtimeStringValue$default$3()));
            }
            if (tuple2 != null && (e = (Throwable)tuple2._1()) instanceof Status.HasStatus) {
                Throwable throwable = e;
                Status status = ((Status.HasStatus)throwable).status();
                Status.Cluster cluster = Status.Cluster.NotALeader;
                if (!(status != null ? !status.equals(cluster) : cluster != null)) {
                    return DatabaseAdministrationOnFollowerException.notALeader((String)("RENAME " + entity.toUpperCase(Locale.ROOT)), (String)("Failed to rename the specified " + entity.toLowerCase(Locale.ROOT) + " '" + MODULE$.runtimeStringValue(fromName, (MapValue)p, MODULE$.runtimeStringValue$default$3()) + "'"), (Throwable)error);
                }
            }
            return CypherExecutionException.renameEntityCause((String)entity.toLowerCase(Locale.ROOT), (String)MODULE$.runtimeStringValue(fromName, (MapValue)p, MODULE$.runtimeStringValue$default$3()), (String)MODULE$.runtimeStringValue(toName, (MapValue)p, MODULE$.runtimeStringValue$default$3()), (Throwable)error);
        });
        Option<ExecutionPlan> x$7 = sourcePlan;
        InitAndFinallyFunctions x$8 = new InitAndFinallyFunctions(initFunction, InitAndFinallyFunctions$.MODULE$.apply$default$2());
        ParameterTransformer x$9 = parameterTransformer;
        boolean x$10 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$8();
        Function1<Transaction, BoxedUnit> x$11 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$11();
        return new UpdatingSystemCommandExecutionPlan(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$10, x$8, x$9, x$11);
    }

    public AdministrationCommandRuntime.NameFields getNameFields(String key, Either<String, Parameter> name, Function1<String, String> valueMapper) {
        Either<String, Parameter> either = name;
        if (either instanceof Left) {
            Left left = (Left)either;
            String u = (String)left.value();
            return new AdministrationCommandRuntime.NameFields(this.internalKey(key), (Value)Values.utf8Value((String)((String)valueMapper.apply((Object)u))), AdministrationCommandRuntime$IdentityConverter$.MODULE$);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Parameter parameter = (Parameter)right.value();
            return new AdministrationCommandRuntime.NameFields(this.internalKey(key), Values.NO_VALUE, new AdministrationCommandRuntime.RenamingStringParameterConverter(parameter.name(), this.internalKey(key), (Function1<TextValue, TextValue>)(Function1 & Serializable)v -> Values.utf8Value((String)((String)valueMapper.apply((Object)v.stringValue())))));
        }
        throw new MatchError(either);
    }

    public Function1<String, String> getNameFields$default$3() {
        return (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x);
    }

    public AdministrationCommandRuntime.DatabaseNameFields getDatabaseNameFields(String nameKey, DatabaseName name, boolean emulateGetNameFields) {
        Option option;
        Function1 & Serializable valueMapper = (Function1 & Serializable)x$1 -> NormalizedDatabaseName.normalize((String)x$1);
        boolean bl = false;
        NamespacedName namespacedName = null;
        DatabaseName databaseName = name;
        if (databaseName instanceof NamespacedName) {
            bl = true;
            namespacedName = (NamespacedName)databaseName;
            Option option2 = namespacedName.namespace();
            if (None$.MODULE$.equals(option2)) {
                return new AdministrationCommandRuntime.DatabaseNameFields(this.internalPrefix() + nameKey, (Value)Values.utf8Value((String)((String)valueMapper.apply((Object)namespacedName.name()))), this.internalPrefix() + nameKey + "_namespace", (Value)Values.utf8Value((String)"system-root"), this.internalPrefix() + nameKey + "_displayName", (Value)Values.utf8Value((String)((String)valueMapper.apply((Object)namespacedName.name()))), this.internalPrefix() + nameKey + "_quotedDisplayName", (Value)Values.utf8Value((String)AdministrationCommandRuntime$.backtick$1((String)valueMapper.apply((Object)namespacedName.name()))), false, AdministrationCommandRuntime$IdentityConverter$.MODULE$);
            }
        }
        if (bl && (option = namespacedName.namespace()) instanceof Some) {
            Some some = (Some)option;
            String namespace = (String)some.value();
            String string = namespace;
            String string2 = "system-root";
            String string3 = namespace;
            String string4 = "system-root";
            return new AdministrationCommandRuntime.DatabaseNameFields(this.internalPrefix() + nameKey, (Value)Values.utf8Value((String)((String)valueMapper.apply((Object)namespacedName.name()))), this.internalPrefix() + nameKey + "_namespace", (Value)Values.utf8Value((String)((String)valueMapper.apply((Object)namespace))), this.internalPrefix() + nameKey + "_displayName", (Value)Values.utf8Value((String)(!(string != null ? !string.equals(string2) : string2 != null) ? (String)valueMapper.apply((Object)namespacedName.name()) : (String)valueMapper.apply((Object)namespace) + "." + valueMapper.apply((Object)namespacedName.name()))), this.internalPrefix() + nameKey + "_quotedDisplayName", (Value)Values.utf8Value((String)(!(string3 != null ? !string3.equals(string4) : string4 != null) ? AdministrationCommandRuntime$.backtick$1((String)valueMapper.apply((Object)namespacedName.name())) : AdministrationCommandRuntime$.backtick$1((String)valueMapper.apply((Object)namespace)) + "." + AdministrationCommandRuntime$.backtick$1((String)valueMapper.apply((Object)namespacedName.name())))), false, AdministrationCommandRuntime$IdentityConverter$.MODULE$);
        }
        if (databaseName instanceof ParameterName) {
            ParameterName parameterName = (ParameterName)databaseName;
            String displayNameKey = this.internalKey(nameKey + "_displayName");
            String quotedDisplayNameKey = this.internalKey(nameKey + "_quotedDisplayName");
            return new AdministrationCommandRuntime.DatabaseNameFields(this.internalKey(nameKey), Values.NO_VALUE, this.internalKey(nameKey + "_namespace"), (Value)Values.utf8Value((String)"system-root"), displayNameKey, Values.NO_VALUE, quotedDisplayNameKey, Values.NO_VALUE, true, (Function2<Transaction, MapValue, MapValue>)(Function2 & Serializable)(x$31, params) -> {
                Tuple4 tuple4 = parameterName.getNameParts(params, "system-root", emulateGetNameFields);
                if (tuple4 == null) {
                    throw new MatchError((Object)tuple4);
                }
                Option namespace = (Option)tuple4._1();
                String name = (String)tuple4._2();
                String displayName = (String)tuple4._3();
                String quotedDisplayName = (String)tuple4._4();
                Tuple4 tuple42 = new Tuple4((Object)namespace, (Object)name, (Object)displayName, (Object)quotedDisplayName);
                Option namespace2 = (Option)tuple42._1();
                String name2 = (String)tuple42._2();
                String displayName2 = (String)tuple42._3();
                String quotedDisplayName2 = (String)tuple42._4();
                return params.updatedWith(MODULE$.internalKey(nameKey + "_namespace"), (AnyValue)Values.utf8Value((String)((String)valueMapper.apply(namespace2.getOrElse((Function0 & Serializable)() -> "system-root"))))).updatedWith(MODULE$.internalKey(nameKey), (AnyValue)Values.utf8Value((String)((String)valueMapper.apply((Object)name2)))).updatedWith(displayNameKey, (AnyValue)Values.utf8Value((String)((String)valueMapper.apply((Object)displayName2)))).updatedWith(quotedDisplayNameKey, (AnyValue)Values.utf8Value((String)((String)valueMapper.apply((Object)quotedDisplayName2))));
            });
        }
        throw new MatchError((Object)databaseName);
    }

    public boolean getDatabaseNameFields$default$3() {
        return false;
    }

    public String runtimeStringValue(DatabaseName field, MapValue params) {
        DatabaseName databaseName = field;
        if (databaseName instanceof NamespacedName) {
            NamespacedName namespacedName = (NamespacedName)databaseName;
            return namespacedName.toString();
        }
        if (databaseName instanceof ParameterName) {
            ParameterName parameterName = (ParameterName)databaseName;
            Parameter p = parameterName.parameter();
            return this.runtimeStringValue(p.name(), params, false);
        }
        throw new MatchError((Object)databaseName);
    }

    public String runtimeStringValue(Either<String, Parameter> field, MapValue params, Function1<String, String> literalValueMapper) {
        Either<String, Parameter> either = field;
        if (either instanceof Left) {
            Left left = (Left)either;
            String s = (String)left.value();
            return (String)literalValueMapper.apply((Object)s);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Parameter p = (Parameter)right.value();
            return this.runtimeStringValue(p.name(), params, false);
        }
        throw new MatchError(either);
    }

    public String runtimeStringValue(Expression field, MapValue params, boolean prettyPrint) {
        return (String)new Serializable(params, prettyPrint){
            private static final long serialVersionUID = 0L;
            private final MapValue params$4;
            private final boolean prettyPrint$1;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof StringLiteral) {
                    StringLiteral stringLiteral = (StringLiteral)A1;
                    String s = stringLiteral.value();
                    return (B1)s;
                }
                if (A1 instanceof Parameter) {
                    Parameter parameter = (Parameter)A1;
                    return (B1)AdministrationCommandRuntime$.MODULE$.runtimeStringValue(parameter.name(), this.params$4, this.prettyPrint$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                if (expression instanceof StringLiteral) {
                    return true;
                }
                return expression instanceof Parameter;
            }
            {
                this.params$4 = params$4;
                this.prettyPrint$1 = prettyPrint$1;
            }
        }.apply(field);
    }

    public String runtimeStringValue(String parameter, MapValue params, boolean prettyPrint) {
        AnyValue value = params.containsKey(parameter) ? params.get(parameter) : params.get(this.internalKey(parameter));
        AnyValue anyValue = value;
        if (anyValue instanceof TextValue) {
            TextValue textValue = (TextValue)anyValue;
            return textValue.stringValue();
        }
        throw ParameterWrongTypeException.expectedParameterToBeString42N51((boolean)prettyPrint, (String)parameter, (String)String.valueOf(value), (String)value.prettify());
    }

    public Function1<String, String> runtimeStringValue$default$3() {
        return (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x);
    }

    public List<String> runtimeStringListValue(Expression field, MapValue params) {
        ListLiteral listLiteral;
        StringLiteral stringLiteral;
        String s;
        Expression expression = field;
        if (expression instanceof StringLiteral && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s = (stringLiteral = (StringLiteral)expression).value()))) {
            return new .colon.colon((Object)s, (List)Nil$.MODULE$);
        }
        if (expression instanceof ListLiteral && (listLiteral = (ListLiteral)expression).expressions().forall((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)AdministrationCommandRuntime$.$anonfun$runtimeStringListValue$1(e))) && listLiteral.expressions().nonEmpty()) {
            return ((IterableOnceOps)listLiteral.expressions().map((Function1 & Serializable)x$33 -> ((StringLiteral)x$33).value())).toList();
        }
        if (expression instanceof Parameter) {
            ListValue listValue;
            TextValue textValue;
            Parameter parameter = (Parameter)expression;
            AnyValue value = params.containsKey(parameter.name()) ? params.get(parameter.name()) : params.get(this.internalKey(parameter.name()));
            PrettyPrinter pp = new PrettyPrinter();
            AnyValue anyValue = value;
            if (anyValue instanceof TextValue && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((textValue = (TextValue)anyValue).stringValue()))) {
                return new .colon.colon((Object)textValue.stringValue(), (List)Nil$.MODULE$);
            }
            if (anyValue instanceof ListValue && (listValue = (ListValue)anyValue).nonEmpty()) {
                return CollectionConverters$.MODULE$.IteratorHasAsScala(listValue.iterator()).asScala().map((Function1 & Serializable)x0$1 -> {
                    TextValue textValue;
                    AnyValue anyValue = x0$1;
                    if (anyValue instanceof TextValue && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((textValue = (TextValue)anyValue).stringValue()))) {
                        return textValue.stringValue();
                    }
                    anyValue.writeTo((AnyValueWriter)pp);
                    throw ParameterWrongTypeException.expectedListParameterToContainStrings((String)parameter.name(), (String)pp.value());
                }).toList();
            }
            value.writeTo((AnyValueWriter)pp);
            throw ParameterWrongTypeException.expectedStringOrStringList2((String)parameter.name(), (String)pp.value());
        }
        throw CypherExecutionException.internalError((String)("Expected non-empty String or non-empty List of non-empty Strings but was `" + field.asCanonicalStringVal() + "`."), (String)"", null);
    }

    private void validateAuthId(String id) {
        if (id.isEmpty()) {
            throw InvalidArgumentException.notAllowedToBeEmptyString((String)"Auth id");
        }
    }

    public Tuple2<MapValue, Set<InternalNotification>> checkNamespaceExists(AdministrationCommandRuntime.DatabaseNameFields aliasNameFields, AdministrationCommandRuntimeContext context, Transaction tx, MapValue params) {
        String namespace;
        CypherVersion cypherVersion = context.runtimeContext().cypherVersion();
        CypherVersion cypherVersion2 = CypherVersion.Cypher5;
        if (cypherVersion == null ? cypherVersion2 != null : !cypherVersion.equals(cypherVersion2)) {
            return new Tuple2((Object)params, (Object)Predef$.MODULE$.Set().empty());
        }
        String string = namespace = this.runtimeStringValue(aliasNameFields.namespaceKey(), params, false);
        String string2 = "system-root";
        if (!(string == null ? string2 != null : !string.equals(string2)) || this.compositeNamespaces(tx).contains((Object)namespace)) {
            return new Tuple2((Object)params, (Object)Predef$.MODULE$.Set().empty());
        }
        return this.interpretNamespaceAsPartOfName(aliasNameFields, params);
    }

    public MapValue updateNamespaceToMatchingComposite(CypherVersion cypherVersion, AdministrationCommandRuntime.DatabaseNameFields aliasNameFields, Transaction tx, MapValue params) {
        Some some;
        Tuple2 tuple2;
        CypherVersion cypherVersion2 = cypherVersion;
        CypherVersion cypherVersion3 = CypherVersion.Cypher5;
        if (!(cypherVersion2 != null ? !cypherVersion2.equals(cypherVersion3) : cypherVersion3 != null)) {
            return params;
        }
        String fullName = this.runtimeStringValue(aliasNameFields.displayNameKey(), params, false);
        Option<Tuple2<String, String>> option = this.findNamespaceNameSplit(this.compositeNamespaces(tx), fullName);
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            String namespace = (String)tuple2._1();
            String name = (String)tuple2._2();
            return params.updatedWith(aliasNameFields.namespaceKey(), (AnyValue)Values.utf8Value((String)namespace)).updatedWith(aliasNameFields.nameKey(), (AnyValue)Values.utf8Value((String)name));
        }
        if (None$.MODULE$.equals(option)) {
            return params.updatedWith(aliasNameFields.namespaceKey(), (AnyValue)Values.utf8Value((String)"system-root")).updatedWith(aliasNameFields.nameKey(), (AnyValue)Values.utf8Value((String)fullName));
        }
        throw new MatchError(option);
    }

    private Seq<String> compositeNamespaces(Transaction tx) {
        return (Seq)Using$.MODULE$.resource((Object)tx.findNodes(TopologyGraphDbmsModel.DATABASE_NAME_LABEL), (Function1 & Serializable)nodes -> CollectionConverters$.MODULE$.IteratorHasAsScala((Iterator)nodes).asScala().filter((Function1 & Serializable)x$34 -> BoxesRunTime.boxToBoolean((boolean)AdministrationCommandRuntime$.$anonfun$compositeNamespaces$2(x$34))).filter((Function1 & Serializable)nameNode -> BoxesRunTime.boxToBoolean((boolean)AdministrationCommandRuntime$.$anonfun$compositeNamespaces$3(nameNode))).map((Function1 & Serializable)x$36 -> x$36.getProperty("name")).flatMap((Function1 & Serializable)x0$1 -> {
            Object object = x0$1;
            if (object instanceof String) {
                String string = (String)object;
                return new Some((Object)string);
            }
            return None$.MODULE$;
        }).toList(), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private Option<Tuple2<String, String>> findNamespaceNameSplit(Seq<String> compositeNamespaces, String fullName) {
        IndexedSeq dotIndexes = (IndexedSeq)((IndexedSeqOps)((IterableOps)Predef$.MODULE$.wrapString(fullName).zipWithIndex()).filter((Function1 & Serializable)x$37 -> BoxesRunTime.boxToBoolean((boolean)AdministrationCommandRuntime$.$anonfun$findNamespaceNameSplit$1(x$37)))).map((Function1 & Serializable)x$38 -> BoxesRunTime.boxToInteger((int)x$38._2$mcI$sp()));
        IndexedSeq namespaceNamePairs = (IndexedSeq)dotIndexes.map((Function1 & Serializable)index -> AdministrationCommandRuntime$.$anonfun$findNamespaceNameSplit$3(fullName, BoxesRunTime.unboxToInt((Object)index)));
        return namespaceNamePairs.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AdministrationCommandRuntime$.$anonfun$findNamespaceNameSplit$4(compositeNamespaces, x0$1)));
    }

    private Tuple2<MapValue, Set<InternalNotification>> interpretNamespaceAsPartOfName(AdministrationCommandRuntime.DatabaseNameFields aliasNameFields, MapValue params) {
        String namespace = this.runtimeStringValue(aliasNameFields.namespaceKey(), params, false);
        String name = this.runtimeStringValue(aliasNameFields.nameKey(), params, false);
        String aliasName = namespace + "." + name;
        return new Tuple2((Object)params.updatedWith(aliasNameFields.nameKey(), (AnyValue)Values.utf8Value((String)aliasName)).updatedWith(aliasNameFields.namespaceKey(), (AnyValue)Values.utf8Value((String)"system-root")), (Object)Predef$.MODULE$.Set().empty());
    }

    public String translateDefaultLanguagePropertyToShowOutput(String node) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CASE " + node + ".defaultLanguage\n       |WHEN '" + CypherVersion.Cypher5.persistedValue + "' THEN '" + CypherVersion.Cypher5.description + "'\n       |WHEN '" + CypherVersion.Cypher25.persistedValue + "' THEN '" + CypherVersion.Cypher25.description + "'\n       |ELSE NULL\n       |END"));
    }

    private final MapValue convertPasswordParameters$1(MapValue params, Parameter x2$1, boolean isEncryptedPassword$1, Config config$1, String hashedPwKey$1, String passwordByteKey$1) {
        byte[] encodedPassword = this.getValidPasswordParameter(params, x2$1.name());
        TextValue hashedPassword = isEncryptedPassword$1 ? this.validateAndFormatEncryptedPassword(encodedPassword) : this.hashPassword(this.validatePassword(encodedPassword, config$1));
        return params.updatedWith(hashedPwKey$1, (AnyValue)hashedPassword).updatedWith(passwordByteKey$1, (AnyValue)Values.byteArray((byte[])encodedPassword));
    }

    public static final /* synthetic */ void $anonfun$ensureUniqueParamName$1(ObjectRef uniqueName$1, String otherParamName) {
        if (otherParamName.equals((String)uniqueName$1.elem)) {
            uniqueName$1.elem = (String)uniqueName$1.elem + "_";
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$makeCreateUserExecutionPlan$1(NativeAuth auth) {
        return BoxesRunTime.unboxToBoolean((Object)auth.changeRequired().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true));
    }

    private static final Function3 authMapGenerator$1(Seq externalAuths$1, Option nativeAuth$1, String authKey$1, String uuidKey$1) {
        return (Function3 & Serializable)(x$8, x$9, params) -> {
            TextValue userId = Values.utf8Value((String)UUID.randomUUID().toString());
            Seq authList = (Seq)((IterableOps)externalAuths$1.map((Function1 & Serializable)auth -> {
                String id = MODULE$.runtimeStringValue(auth.id(), (MapValue)params, true);
                MODULE$.validateAuthId(id);
                return VirtualValues.map((String[])((String[])((Object[])new String[]{"provider", "id"})), (AnyValue[])((AnyValue[])((Object[])new AnyValue[]{Values.utf8Value((String)auth.provider()), Values.utf8Value((String)id)})));
            })).$plus$plus((IterableOnce)nativeAuth$1.map((Function1 & Serializable)x$10 -> VirtualValues.map((String[])((String[])((Object[])new String[]{"provider", "id"})), (AnyValue[])((AnyValue[])((Object[])new AnyValue[]{Values.utf8Value((String)"native"), userId})))));
            return VirtualValues.map((String[])((String[])((Object[])new String[]{authKey$1, uuidKey$1})), (AnyValue[])((AnyValue[])((Object[])new AnyValue[]{VirtualValues.list((AnyValue[])((AnyValue[])authList.toArray(ClassTag$.MODULE$.apply(MapValue.class)))), userId})));
        };
    }

    public static final /* synthetic */ BooleanValue $anonfun$makeCreateUserExecutionPlan$22(boolean x$1) {
        return Values.booleanValue((boolean)x$1);
    }

    public static final /* synthetic */ QueryHandlerResult $anonfun$makeCreateUserExecutionPlan$25(Function2 validateAuth$1, Seq externalAuths$1, Option nativeAuth$1, int x$14, AnyValue x$15, MapValue x$16) {
        return (QueryHandlerResult)validateAuth$1.apply((Object)externalAuths$1, (Object)nativeAuth$1);
    }

    public static final /* synthetic */ void $anonfun$makeCreateUserExecutionPlan$28(MapValue p$1, AdministrationCommandRuntime.PasswordExpression credentials) {
        ((ByteArray)p$1.get(credentials.bytesKey())).zero();
    }

    private static final Function3 enforceAuthGen$1(UserSecurityGraphComponent userSecurityGraphComponent$1, String enforceAuthKey$1) {
        return (Function3 & Serializable)(transaction, x$25, x$26) -> {
            BooleanValue enforced = Values.booleanValue((boolean)userSecurityGraphComponent$1.requiresAuthObject(transaction));
            return VirtualValues.map((String[])((String[])((Object[])new String[]{enforceAuthKey$1})), (AnyValue[])((AnyValue[])((Object[])new AnyValue[]{enforced})));
        };
    }

    private static final Function3 authMapGenerator$2(Seq externalAuths$2, RemoveAuth removeAuths$1, String setAuthKey$1, String removeAuthKey$1, String removeNativeKey$1) {
        return (Function3 & Serializable)(x$27, x$28, params) -> {
            Seq setAuthList = (Seq)externalAuths$2.map((Function1 & Serializable)auth -> {
                String id = MODULE$.runtimeStringValue(auth.id(), (MapValue)params, true);
                MODULE$.validateAuthId(id);
                return VirtualValues.map((String[])((String[])((Object[])new String[]{"provider", "id"})), (AnyValue[])((AnyValue[])((Object[])new AnyValue[]{Values.utf8Value((String)auth.provider()), Values.utf8Value((String)id)})));
            });
            List providers = (List)removeAuths$1.auths().flatMap((Function1 & Serializable)expr -> MODULE$.runtimeStringListValue((Expression)expr, (MapValue)params)).distinct();
            boolean removeNative = providers.contains((Object)"native");
            List removeAuthList = providers.map((Function1 & Serializable)x$1 -> Values.utf8Value((String)x$1));
            return VirtualValues.map((String[])((String[])((Object[])new String[]{setAuthKey$1, removeAuthKey$1, removeNativeKey$1})), (AnyValue[])((AnyValue[])((Object[])new AnyValue[]{VirtualValues.list((AnyValue[])((AnyValue[])setAuthList.toArray(ClassTag$.MODULE$.apply(MapValue.class)))), VirtualValues.list((AnyValue[])((AnyValue[])removeAuthList.toArray(ClassTag$.MODULE$.apply(TextValue.class)))), Values.booleanValue((boolean)removeNative)})));
        };
    }

    public static final /* synthetic */ QueryHandlerResult $anonfun$makeAlterUserExecutionPlan$19(Either userName$2, Option maybePw$1, Function2 validateAuth$2, Seq externalAuths$2, Option nativeAuth$2, int x0$2, AnyValue x1$1, MapValue x2$1) {
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)x0$2), (Object)x1$1, (Object)x2$1);
        if (tuple3 != null) {
            BooleanValue booleanValue;
            int n = BoxesRunTime.unboxToInt((Object)tuple3._1());
            AnyValue value = (AnyValue)tuple3._2();
            MapValue p = (MapValue)tuple3._3();
            if (0 == n && value instanceof BooleanValue && !(booleanValue = (BooleanValue)value).booleanValue()) {
                return new ThrowException(InvalidArgumentException.alterMissingUser((String)MODULE$.runtimeStringValue((Either<String, Parameter>)userName$2, p, MODULE$.runtimeStringValue$default$3()), (String)((String)MODULE$.getParameterName((Either<String, Parameter>)userName$2).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))));
            }
        }
        if (tuple3 != null) {
            int n = BoxesRunTime.unboxToInt((Object)tuple3._1());
            AnyValue value = (AnyValue)tuple3._2();
            MapValue p = (MapValue)tuple3._3();
            if (1 == n && value instanceof TextValue) {
                TextValue textValue = (TextValue)value;
                return (QueryHandlerResult)maybePw$1.map((Function1 & Serializable)newPw -> {
                    byte[] newValue;
                    SystemGraphCredential oldCredentials = SystemGraphCredential.deserialize((String)textValue.stringValue(), (SecureHasher)MODULE$.secureHasher());
                    if (oldCredentials.matchesPassword(newValue = ((ByteArray)p.get(newPw.bytesKey())).asObject())) {
                        return new ThrowException(InvalidArgumentException.oldPasswordEqualsNew((String)MODULE$.runtimeStringValue((Either<String, Parameter>)userName$2, p, MODULE$.runtimeStringValue$default$3()), (Boolean)Predef$.MODULE$.boolean2Boolean(false)));
                    }
                    return (QueryHandlerResult)validateAuth$2.apply((Object)externalAuths$2, (Object)nativeAuth$2);
                }).getOrElse((Function0 & Serializable)() -> (QueryHandlerResult)validateAuth$2.apply((Object)externalAuths$2, (Object)nativeAuth$2));
            }
        }
        if (tuple3 != null) {
            BooleanValue booleanValue;
            int n = BoxesRunTime.unboxToInt((Object)tuple3._1());
            AnyValue value = (AnyValue)tuple3._2();
            if (2 == n && value instanceof BooleanValue && !(booleanValue = (BooleanValue)value).booleanValue()) {
                return new ThrowException(InvalidArgumentException.atLeastOneAuthProviderRequired());
            }
        }
        if (tuple3 != null) {
            BooleanValue booleanValue;
            int n = BoxesRunTime.unboxToInt((Object)tuple3._1());
            AnyValue value = (AnyValue)tuple3._2();
            if (3 == n && value instanceof BooleanValue && !(booleanValue = (BooleanValue)value).booleanValue()) {
                return new ThrowException(InvalidArgumentException.missingMandatoryAuthClause((String)"SET PASSWORD", (String)"native", (String)"Clause `SET PASSWORD` is mandatory for auth provider `native`."));
            }
        }
        return (QueryHandlerResult)validateAuth$2.apply((Object)externalAuths$2, (Object)nativeAuth$2);
    }

    public static final /* synthetic */ void $anonfun$makeAlterUserExecutionPlan$23(MapValue p$3, AdministrationCommandRuntime.PasswordExpression newPw) {
        ((ByteArray)p$3.get(newPw.bytesKey())).zero();
    }

    private static final String backtick$1(String s) {
        return ExpressionStringifier$.MODULE$.apply(ExpressionStringifier$.MODULE$.apply$default$1(), ExpressionStringifier$.MODULE$.apply$default$2(), ExpressionStringifier$.MODULE$.apply$default$3(), ExpressionStringifier$.MODULE$.apply$default$4(), ExpressionStringifier$.MODULE$.apply$default$5()).backtick(s);
    }

    public static final /* synthetic */ boolean $anonfun$runtimeStringListValue$1(Expression e) {
        return e instanceof StringLiteral && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(((StringLiteral)e).value()));
    }

    public static final /* synthetic */ boolean $anonfun$compositeNamespaces$2(Node x$34) {
        return x$34.getProperty("namespace").equals("system-root");
    }

    public static final /* synthetic */ boolean $anonfun$compositeNamespaces$4(Relationship x$35) {
        return x$35.getEndNode().hasLabel(TopologyGraphDbmsModel.COMPOSITE_DATABASE_LABEL);
    }

    public static final /* synthetic */ boolean $anonfun$compositeNamespaces$3(Node nameNode) {
        return Option$.MODULE$.apply((Object)nameNode.getSingleRelationship(TopologyGraphDbmsModel.TARGETS_RELATIONSHIP, Direction.OUTGOING)).exists((Function1 & Serializable)x$35 -> BoxesRunTime.boxToBoolean((boolean)AdministrationCommandRuntime$.$anonfun$compositeNamespaces$4(x$35)));
    }

    public static final /* synthetic */ boolean $anonfun$findNamespaceNameSplit$1(Tuple2 x$37) {
        return ((Object)BoxesRunTime.boxToCharacter((char)x$37._1$mcC$sp())).equals(BoxesRunTime.boxToCharacter((char)'.'));
    }

    public static final /* synthetic */ Tuple2 $anonfun$findNamespaceNameSplit$3(String fullName$1, int index) {
        String namespace = StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(fullName$1), index);
        String name = StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(fullName$1), index + 1);
        return new Tuple2((Object)namespace, (Object)name);
    }

    public static final /* synthetic */ boolean $anonfun$findNamespaceNameSplit$4(Seq compositeNamespaces$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String namespace = (String)tuple2._1();
            return compositeNamespaces$1.contains((Object)namespace);
        }
        throw new MatchError((Object)tuple2);
    }

    private AdministrationCommandRuntime$() {
    }
}

