/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Closeable;
import java.io.Serializable;
import java.time.Clock;
import java.util.Optional;
import java.util.UUID;
import org.neo4j.cypher.internal.CachingPreParser;
import org.neo4j.cypher.internal.CompilerWithExpressionCodeGenOption;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.cypher.internal.DefaultQueryLanguageScope;
import org.neo4j.cypher.internal.ExecutableQuery;
import org.neo4j.cypher.internal.ExecutionEngine$;
import org.neo4j.cypher.internal.ExecutionEngineConst$;
import org.neo4j.cypher.internal.FunctionWithInformation$;
import org.neo4j.cypher.internal.MasterCompiler;
import org.neo4j.cypher.internal.QueryCache;
import org.neo4j.cypher.internal.QueryCache$;
import org.neo4j.cypher.internal.SchemaHelper;
import org.neo4j.cypher.internal.ast.semantics.SemanticFeature;
import org.neo4j.cypher.internal.cache.CypherQueryCaches;
import org.neo4j.cypher.internal.config.CypherConfiguration;
import org.neo4j.cypher.internal.expressions.IterablePredicateExpression$;
import org.neo4j.cypher.internal.expressions.functions.Function$;
import org.neo4j.cypher.internal.frontend.phases.BaseState;
import org.neo4j.cypher.internal.options.CypherReplanOption;
import org.neo4j.cypher.internal.planning.CompilationException$;
import org.neo4j.cypher.internal.preparser.FullyParsedQuery;
import org.neo4j.cypher.internal.preparser.InputQuery;
import org.neo4j.cypher.internal.preparser.PreParsedQuery;
import org.neo4j.cypher.internal.runtime.InputDataStream;
import org.neo4j.cypher.internal.runtime.NoInput$;
import org.neo4j.cypher.internal.runtime.QueryRuntimeConfig;
import org.neo4j.cypher.internal.runtime.QueryRuntimeConfig$;
import org.neo4j.cypher.internal.tracing.CompilationTracer;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.InternalNotificationLogger;
import org.neo4j.cypher.internal.util.RecordingNotificationLogger;
import org.neo4j.dbms.systemgraph.DefaultQueryLanguageLookup;
import org.neo4j.exceptions.ParameterNotFoundException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.StaticAccessMode;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedCatalogEntry;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.kernel.impl.query.FunctionInformation;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\ref!B\u00193\u0003\u0003Y\u0004\u0002\u0003&\u0001\u0005\u000b\u0007I\u0011A&\t\u0011I\u0003!\u0011!Q\u0001\n1C\u0001b\u0015\u0001\u0003\u0006\u0004%\t\u0001\u0016\u0005\t7\u0002\u0011\t\u0011)A\u0005+\"AA\f\u0001BC\u0002\u0013\u0005Q\f\u0003\u0005e\u0001\t\u0005\t\u0015!\u0003_\u0011!)\u0007A!b\u0001\n\u00031\u0007\u0002\u00037\u0001\u0005\u0003\u0005\u000b\u0011B4\t\u00115\u0004!Q1A\u0005\u00029D\u0001b\u001d\u0001\u0003\u0002\u0003\u0006Ia\u001c\u0005\ti\u0002\u0011)\u0019!C\u0001k\"AA\u0010\u0001B\u0001B\u0003%a\u000f\u0003\u0005~\u0001\t\u0015\r\u0011\"\u0001\u007f\u0011%\tY\u0001\u0001B\u0001B\u0003%q\u0010\u0003\u0006\u0002\u000e\u0001\u0011)\u0019!C\u0001\u0003\u001fA!\"!\b\u0001\u0005\u0003\u0005\u000b\u0011BA\t\u0011\u001d\ty\u0002\u0001C\u0001\u0003CA\u0011\"!\u000e\u0001\u0005\u0004%\t!a\u000e\t\u0011\u0005%\u0003\u0001)A\u0005\u0003sA\u0011\"a\u0013\u0001\u0005\u0004%I!!\u0014\t\u0011\u0005U\u0003\u0001)A\u0005\u0003\u001fB\u0011\"a\u0016\u0001\u0005\u0004%I!!\u0017\t\u0011\u0005-\u0004\u0001)A\u0005\u00037B\u0011\"!\u001c\u0001\u0005\u0004%I!a\u001c\t\u0011\u0005M\u0006\u0001)A\u0005\u0003cB\u0011\"!.\u0001\u0005\u0004%I!a.\t\u0011\u0005}\u0006\u0001)A\u0005\u0003sCq!!1\u0001\t\u0003\t\u0019\rC\u0005\u0003\u001e\u0001\t\n\u0011\"\u0001\u0003 !9\u0011\u0011\u0019\u0001\u0005\u0002\tU\u0002b\u0002B.\u0001\u0011\u0005!Q\f\u0005\n\u0005c\u0002\u0011\u0013!C\u0001\u0005?AqAa\u001d\u0001\t\u0013\u0011)\bC\u0004\u00034\u0002!IA!.\t\u000f\t}\u0007\u0001\"\u0003\u0003b\"91q\u0001\u0001\u0005\n\r%\u0001bBB\f\u0001\u0011\u00051\u0011\u0004\u0005\b\u0007C\u0001A\u0011AB\r\u0011\u001d\u0019\u0019\u0003\u0001C\u0001\u00073Aqa!\n\u0001\t\u0003\u0019I\u0002C\u0004\u0004(\u0001!\ta!\u000b\t\u000f\r\u0005\u0004\u0001\"\u0001\u0004d!91Q\u000f\u0001\u0005B\r]\u0004bBB=\u0001\u0011%11P\u0004\n\u0007K\u0013\u0014\u0011!E\u0001\u0007O3\u0001\"\r\u001a\u0002\u0002#\u00051\u0011\u0016\u0005\b\u0003?qC\u0011ABY\u0011%\u0019\u0019LLI\u0001\n\u0003\u0019)LA\bFq\u0016\u001cW\u000f^5p]\u0016sw-\u001b8f\u0015\t\u0019D'\u0001\u0005j]R,'O\\1m\u0015\t)d'\u0001\u0004dsBDWM\u001d\u0006\u0003oa\nQA\\3pi)T\u0011!O\u0001\u0004_J<7\u0001A\n\u0004\u0001q\"\u0005CA\u001fC\u001b\u0005q$BA A\u0003\u0011a\u0017M\\4\u000b\u0003\u0005\u000bAA[1wC&\u00111I\u0010\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001d\u0003\u0015AA5p\u0013\tIeIA\u0005DY>\u001cX-\u00192mK\u0006a\u0011/^3ssN+'O^5dKV\tA\n\u0005\u0002N!6\taJ\u0003\u0002Pm\u000511.\u001a:oK2L!!\u0015(\u00033\u001d\u0013\u0018\r\u001d5ECR\f'-Y:f#V,'/_*feZL7-Z\u0001\u000ecV,'/_*feZL7-\u001a\u0011\u0002\u001d-,'O\\3m\u001b>t\u0017\u000e^8sgV\tQ\u000b\u0005\u0002W36\tqK\u0003\u0002Ym\u0005QQn\u001c8ji>\u0014\u0018N\\4\n\u0005i;&\u0001C'p]&$xN]:\u0002\u001f-,'O\\3m\u001b>t\u0017\u000e^8sg\u0002\na\u0001\u001e:bG\u0016\u0014X#\u00010\u0011\u0005}\u0013W\"\u00011\u000b\u0005\u0005\u0014\u0014a\u0002;sC\u000eLgnZ\u0005\u0003G\u0002\u0014\u0011cQ8na&d\u0017\r^5p]R\u0013\u0018mY3s\u0003\u001d!(/Y2fe\u0002\naaY8oM&<W#A4\u0011\u0005!TW\"A5\u000b\u0005\u0015\u0014\u0014BA6j\u0005M\u0019\u0015\u0010\u001d5fe\u000e{gNZ5hkJ\fG/[8o\u0003\u001d\u0019wN\u001c4jO\u0002\na\"\\1ti\u0016\u00148i\\7qS2,'/F\u0001p!\t\u0001\u0018/D\u00013\u0013\t\u0011(G\u0001\bNCN$XM]\"p[BLG.\u001a:\u0002\u001f5\f7\u000f^3s\u0007>l\u0007/\u001b7fe\u0002\n1\"];fef\u001c\u0015m\u00195fgV\ta\u000f\u0005\u0002xu6\t\u0001P\u0003\u0002ze\u0005)1-Y2iK&\u00111\u0010\u001f\u0002\u0012\u0007f\u0004\b.\u001a:Rk\u0016\u0014\u0018pQ1dQ\u0016\u001c\u0018\u0001D9vKJL8)Y2iKN\u0004\u0013a\u00037pOB\u0013xN^5eKJ,\u0012a \t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011Q\u0001\u001c\u0002\u000f1|wmZ5oO&!\u0011\u0011BA\u0002\u0005MIe\u000e^3s]\u0006dGj\\4Qe>4\u0018\u000eZ3s\u00031awn\u001a)s_ZLG-\u001a:!\u0003\u0015\u0019Gn\\2l+\t\t\t\u0002\u0005\u0003\u0002\u0014\u0005eQBAA\u000b\u0015\r\t9\u0002Q\u0001\u0005i&lW-\u0003\u0003\u0002\u001c\u0005U!!B\"m_\u000e\\\u0017AB2m_\u000e\\\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0013\u0003G\t)#a\n\u0002*\u0005-\u0012QFA\u0018\u0003c\t\u0019\u0004\u0005\u0002q\u0001!)!*\u0005a\u0001\u0019\")1+\u0005a\u0001+\")A,\u0005a\u0001=\")Q-\u0005a\u0001O\")Q.\u0005a\u0001_\")A/\u0005a\u0001m\")Q0\u0005a\u0001\u007f\"I\u0011QB\t\u0011\u0002\u0003\u0007\u0011\u0011C\u0001\u001dI\u00164\u0017-\u001e7u#V,'/_#yK\u000e,H/[8o\u001b>t\u0017\u000e^8s+\t\tI\u0004\u0005\u0003\u0002<\u0005\u0015SBAA\u001f\u0015\u0011\ty$!\u0011\u0002\u000bE,XM]=\u000b\u0007\u0005\rc*\u0001\u0003j[Bd\u0017\u0002BA$\u0003{\u0011Q#U;fef,\u00050Z2vi&|g.T8oSR|'/A\u000feK\u001a\fW\u000f\u001c;Rk\u0016\u0014\u00180\u0012=fGV$\u0018n\u001c8N_:LGo\u001c:!\u0003%\u0001(/\u001a)beN,'/\u0006\u0002\u0002PA\u0019\u0001/!\u0015\n\u0007\u0005M#G\u0001\tDC\u000eD\u0017N\\4Qe\u0016\u0004\u0016M]:fe\u0006Q\u0001O]3QCJ\u001cXM\u001d\u0011\u0002+\u0011,g-Y;mi2\u000bgnZ;bO\u0016dun\\6vaV\u0011\u00111\f\t\u0005\u0003;\n9'\u0004\u0002\u0002`)!\u0011\u0011MA2\u0003-\u0019\u0018p\u001d;f[\u001e\u0014\u0018\r\u001d5\u000b\u0007\u0005\u0015d'\u0001\u0003eE6\u001c\u0018\u0002BA5\u0003?\u0012!\u0004R3gCVdG/U;fefd\u0015M\\4vC\u001e,Gj\\8lkB\fa\u0003Z3gCVdG\u000fT1oOV\fw-\u001a'p_.,\b\u000fI\u0001\u000bcV,'/_\"bG\",WCAA9!\u001d\u0001\u00181OA<\u0003[K1!!\u001e3\u0005)\tV/\u001a:z\u0007\u0006\u001c\u0007.\u001a\t\u0007\u0003s\n)*a'\u000f\t\u0005m\u0014\u0011\u0013\b\u0005\u0003{\nyI\u0004\u0003\u0002\u0000\u00055e\u0002BAA\u0003\u0017sA!a!\u0002\n6\u0011\u0011Q\u0011\u0006\u0004\u0003\u000fS\u0014A\u0002\u001fs_>$h(C\u0001:\u0013\t9\u0004(\u0003\u00026m%\u00111\u0007N\u0005\u0004\u0003'\u0013\u0014AC)vKJL8)Y2iK&!\u0011qSAM\u0005!\u0019\u0015m\u00195f\u0017\u0016L(bAAJeA!\u0011QTAU\u001d\u0011\ty*!*\u000e\u0005\u0005\u0005&bAARe\u0005I\u0001O]3qCJ\u001cXM]\u0005\u0005\u0003O\u000b\t+\u0001\u0006J]B,H/U;fefLA!a&\u0002,*!\u0011qUAQ!\r\u0001\u0018qV\u0005\u0004\u0003c\u0013$aD#yK\u000e,H/\u00192mKF+XM]=\u0002\u0017E,XM]=DC\u000eDW\rI\u0001\rg\u000eDW-\\1IK2\u0004XM]\u000b\u0003\u0003s\u00032\u0001]A^\u0013\r\tiL\r\u0002\r'\u000eDW-\\1IK2\u0004XM]\u0001\u000eg\u000eDW-\\1IK2\u0004XM\u001d\u0011\u0002\u000f\u0015DXmY;uKR\u0001\u0012QYAf\u0003C\f)0a@\u0003\f\t=!\u0011\u0004\t\u0005\u0003w\t9-\u0003\u0003\u0002J\u0006u\"AD)vKJLX\t_3dkRLwN\u001c\u0005\b\u0003\u007fa\u0002\u0019AAg!\u0011\ty-a7\u000f\t\u0005E\u0017q\u001b\t\u0005\u0003\u0007\u000b\u0019N\u0003\u0002\u0002V\u0006)1oY1mC&!\u0011\u0011\\Aj\u0003\u0019\u0001&/\u001a3fM&!\u0011Q\\Ap\u0005\u0019\u0019FO]5oO*!\u0011\u0011\\Aj\u0011\u001d\t\u0019\u000f\ba\u0001\u0003K\fa\u0001]1sC6\u001c\b\u0003BAt\u0003cl!!!;\u000b\t\u0005-\u0018Q^\u0001\bm&\u0014H/^1m\u0015\r\tyON\u0001\u0007m\u0006dW/Z:\n\t\u0005M\u0018\u0011\u001e\u0002\t\u001b\u0006\u0004h+\u00197vK\"9\u0011q\u001f\u000fA\u0002\u0005e\u0018aB2p]R,\u0007\u0010\u001e\t\u0005\u0003w\tY0\u0003\u0003\u0002~\u0006u\"\u0001\u0006+sC:\u001c\u0018m\u0019;j_:\fGnQ8oi\u0016DH\u000fC\u0004\u0003\u0002q\u0001\rAa\u0001\u0002\u000fA\u0014xNZ5mKB!!Q\u0001B\u0004\u001b\t\t\u0019.\u0003\u0003\u0003\n\u0005M'a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005\u001ba\u0002\u0019\u0001B\u0002\u0003-\u0001(/\u001a)paVd\u0017\r^3\t\u000f\tEA\u00041\u0001\u0003\u0014\u0005Q1/\u001e2tGJL'-\u001a:\u0011\t\u0005m\"QC\u0005\u0005\u0005/\tiDA\bRk\u0016\u0014\u0018pU;cg\u000e\u0014\u0018NY3s\u0011%\u0011Y\u0002\bI\u0001\u0002\u0004\tI$A\u0004n_:LGo\u001c:\u0002#\u0015DXmY;uK\u0012\"WMZ1vYR$s'\u0006\u0002\u0003\")\"\u0011\u0011\bB\u0012W\t\u0011)\u0003\u0005\u0003\u0003(\tERB\u0001B\u0015\u0015\u0011\u0011YC!\f\u0002\u0013Ut7\r[3dW\u0016$'\u0002\u0002B\u0018\u0003'\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\u0019D!\u000b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0006\t\u0002F\n]\"q\bB!\u0005\u0007\u0012)E!\u0016\u0003Z!9\u0011q\b\u0010A\u0002\te\u0002\u0003BAP\u0005wIAA!\u0010\u0002\"\n\u0001b)\u001e7msB\u000b'o]3e#V,'/\u001f\u0005\b\u0003Gt\u0002\u0019AAs\u0011\u001d\t9P\ba\u0001\u0003sDqA!\u0004\u001f\u0001\u0004\u0011\u0019\u0001C\u0004\u0003Hy\u0001\rA!\u0013\u0002\u000b%t\u0007/\u001e;\u0011\t\t-#\u0011K\u0007\u0003\u0005\u001bR1Aa\u00143\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\u0015\u0003N\ty\u0011J\u001c9vi\u0012\u000bG/Y*ue\u0016\fW\u000eC\u0004\u0003Xy\u0001\r!!\u000f\u0002\u0019E,XM]=N_:LGo\u001c:\t\u000f\tEa\u00041\u0001\u0003\u0014\u0005yQ\r_3dkR,7+\u001e2rk\u0016\u0014\u0018\u0010\u0006\n\u0002F\n}#\u0011\rB2\u0005K\u0012IGa\u001b\u0003n\t=\u0004bBA ?\u0001\u0007\u0011Q\u001a\u0005\b\u0003G|\u0002\u0019AAs\u0011\u001d\t9p\ba\u0001\u0003sDqAa\u001a \u0001\u0004\u0011\u0019!\u0001\tjg>+H/\u001a:n_N$\u0018+^3ss\"9!\u0011A\u0010A\u0002\t\r\u0001b\u0002B\u0007?\u0001\u0007!1\u0001\u0005\b\u0005#y\u0002\u0019\u0001B\n\u0011%\u0011Yb\bI\u0001\u0002\u0004\tI$A\rfq\u0016\u001cW\u000f^3Tk\n\fX/\u001a:zI\u0011,g-Y;mi\u0012B\u0014aB2m_NLgnZ\u000b\u0005\u0005o\u0012y\b\u0006\u0004\u0003z\tm%Q\u0014\u000b\u0005\u0005w\u0012\t\n\u0005\u0003\u0003~\t}D\u0002\u0001\u0003\b\u0005\u0003\u000b#\u0019\u0001BB\u0005\u0005!\u0016\u0003\u0002BC\u0005\u0017\u0003BA!\u0002\u0003\b&!!\u0011RAj\u0005\u001dqu\u000e\u001e5j]\u001e\u0004BA!\u0002\u0003\u000e&!!qRAj\u0005\r\te.\u001f\u0005\t\u0005'\u000bC\u00111\u0001\u0003\u0016\u0006!1m\u001c3f!\u0019\u0011)Aa&\u0003|%!!\u0011TAj\u0005!a$-\u001f8b[\u0016t\u0004bBA|C\u0001\u0007\u0011\u0011 \u0005\b\u0005?\u000b\u0003\u0019\u0001BQ\u0003)!(/Y2f\u000bZ,g\u000e\u001e\t\u0005\u0005G\u0013iK\u0004\u0003\u0003&\n%f\u0002BA>\u0005OK!!\u0019\u001a\n\u0007\t-\u0006-A\tD_6\u0004\u0018\u000e\\1uS>tGK]1dKJLAAa,\u00032\n)\u0012+^3ss\u000e{W\u000e]5mCRLwN\\#wK:$(b\u0001BVA\u0006IAm\\#yK\u000e,H/\u001a\u000b\u0017\u0003\u000b\u00149La0\u0003B\n\r'Q\u0019Bd\u0005\u0013\u0014YM!4\u0003P\"9\u0011q\b\u0012A\u0002\te\u0006\u0003BAP\u0005wKAA!0\u0002\"\nQ\u0011J\u001c9viF+XM]=\t\u000f\u0005\r(\u00051\u0001\u0002f\"9\u0011q\u001f\u0012A\u0002\u0005e\bb\u0002B4E\u0001\u0007!1\u0001\u0005\b\u0005\u001b\u0011\u0003\u0019\u0001B\u0002\u0011\u001d\u00119E\ta\u0001\u0005\u0013BqAa\u0016#\u0001\u0004\tI\u0004\u0003\u0004]E\u0001\u0007!\u0011\u0015\u0005\b\u0005#\u0011\u0003\u0019\u0001B\n\u0011\u001d\u0011\tN\ta\u0001\u0005'\f!C\\8uS\u001aL7-\u0019;j_:dunZ4feB!!Q\u001bBn\u001b\t\u00119NC\u0002\u0003ZJ\nA!\u001e;jY&!!Q\u001cBl\u0005iIe\u000e^3s]\u0006dgj\u001c;jM&\u001c\u0017\r^5p]2{wmZ3s\u0003\r\u001aw.\u001c9jY\u0016\u0014x+\u001b;i\u000bb\u0004(/Z:tS>t7i\u001c3f\u000f\u0016tw\n\u001d;j_:$bBa9\u0003j\n5(q\u001eBz\u0005k\u00149\u0010E\u0003q\u0005K\fi+C\u0002\u0003hJ\u00121eQ8na&dWM],ji\",\u0005\u0010\u001d:fgNLwN\\\"pI\u0016<UM\\(qi&|g\u000eC\u0004\u0003l\u000e\u0002\rA!/\u0002\u0015%t\u0007/\u001e;Rk\u0016\u0014\u0018\u0010\u0003\u0004]G\u0001\u0007!\u0011\u0015\u0005\b\u0005c\u001c\u0003\u0019AA}\u0003Q!(/\u00198tC\u000e$\u0018n\u001c8bY\u000e{g\u000e^3yi\"9\u00111]\u0012A\u0002\u0005\u0015\bb\u0002BiG\u0001\u0007!1\u001b\u0005\b\u0005s\u001c\u0003\u0019\u0001B~\u0003=\u0019Xm]:j_:$\u0015\r^1cCN,\u0007\u0003\u0002B\u007f\u0007\u0007i!Aa@\u000b\u0007\r\u0005a*\u0001\u0005eCR\f'-Y:f\u0013\u0011\u0019)Aa@\u0003#\u0011\u000bG/\u00192bg\u0016\u0014VMZ3sK:\u001cW-\u0001\u0007hKR|%oQ8na&dW\r\u0006\u0007\u0002.\u000e-1QBB\t\u0007'\u0019)\u0002C\u0004\u0002x\u0012\u0002\r!!?\t\u000f\r=A\u00051\u0001\u0003:\u0006\t\u0012N\\5uS\u0006d\u0017J\u001c9viF+XM]=\t\rq#\u0003\u0019\u0001BQ\u0011\u001d\t\u0019\u000f\na\u0001\u0003KDqA!5%\u0001\u0004\u0011\u0019.\u0001\tdY\u0016\f'/U;fef\u001c\u0015m\u00195fgR\u001111\u0004\t\u0005\u0005\u000b\u0019i\"\u0003\u0003\u0004 \u0005M'\u0001\u0002'p]\u001e\f1c\u00197fCJ\u0004&/\u001a)beN,'oQ1dQ\u0016\f\u0011d\u00197fCJ,\u00050Z2vi\u0006\u0014G.Z)vKJL8)Y2iK\u0006\u00192\r\\3be\u000e{W\u000e]5mKJ\u001c\u0015m\u00195fg\u0006y\u0011N\\:feRLe\u000e^8DC\u000eDW\r\u0006\u0006\u0004,\rE21HB\u001f\u0007#\u0002BA!\u0002\u0004.%!1qFAj\u0005\u0011)f.\u001b;\t\u000f\rM\u0012\u00061\u0001\u00046\u0005q\u0001O]3QCJ\u001cX\rZ)vKJL\b\u0003BAP\u0007oIAa!\u000f\u0002\"\nq\u0001K]3QCJ\u001cX\rZ)vKJL\bbBArS\u0001\u0007\u0011Q\u001d\u0005\b\u0007\u007fI\u0003\u0019AB!\u0003-\u0001\u0018M]:fIF+XM]=\u0011\t\r\r3QJ\u0007\u0003\u0007\u000bRAaa\u0012\u0004J\u00051\u0001\u000f[1tKNT1aa\u00133\u0003!1'o\u001c8uK:$\u0017\u0002BB(\u0007\u000b\u0012\u0011BQ1tKN#\u0018\r^3\t\u000f\rM\u0013\u00061\u0001\u0004V\u0005!\u0002/\u0019:tS:<gj\u001c;jM&\u001c\u0017\r^5p]N\u0004b!a4\u0004X\rm\u0013\u0002BB-\u0003?\u00141aU3u!\u0011\u0011)n!\u0018\n\t\r}#q\u001b\u0002\u0015\u0013:$XM\u001d8bY:{G/\u001b4jG\u0006$\u0018n\u001c8\u0002%\u001d,GoQ=qQ\u0016\u0014h)\u001e8di&|gn]\u000b\u0003\u0007K\u0002baa\u001a\u0004l\r=TBAB5\u0015\r\u0011I\u000eQ\u0005\u0005\u0007[\u001aIG\u0001\u0003MSN$\b\u0003BA\u001e\u0007cJAaa\u001d\u0002>\t\u0019b)\u001e8di&|g.\u00138g_Jl\u0017\r^5p]\u0006)1\r\\8tKR\u001111F\u0001\u0010G\",7m\u001b)be\u0006lW\r^3sgRA11FB?\u0007\u000f\u001bY\tC\u0004\u0004\u00001\u0002\ra!!\u0002\u0017E,XM]=QCJ\fWn\u001d\t\u0007\u0005\u000b\u0019\u0019)!4\n\t\r\u0015\u00151\u001b\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u0007\u0013c\u0003\u0019AAs\u0003-9\u0017N^3o!\u0006\u0014\u0018-\\:\t\u000f\r5E\u00061\u0001\u0002f\u0006yQ\r\u001f;sC\u000e$X\r\u001a)be\u0006l7\u000fK\u0003-\u0007#\u001b\u0019\u000b\u0005\u0004\u0003\u0006\rM5qS\u0005\u0005\u0007+\u000b\u0019N\u0001\u0004uQJ|wo\u001d\t\u0005\u00073\u001by*\u0004\u0002\u0004\u001c*\u00191Q\u0014\u001c\u0002\u0015\u0015D8-\u001a9uS>t7/\u0003\u0003\u0004\"\u000em%A\u0007)be\u0006lW\r^3s\u001d>$hi\\;oI\u0016C8-\u001a9uS>t7EABL\u0003=)\u00050Z2vi&|g.\u00128hS:,\u0007C\u00019/'\rq31\u0016\t\u0005\u0005\u000b\u0019i+\u0003\u0003\u00040\u0006M'AB!osJ+g\r\u0006\u0002\u0004(\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIa*\"aa.+\t\u0005E!1\u0005")
public abstract class ExecutionEngine
implements Closeable {
    private final GraphDatabaseQueryService queryService;
    private final Monitors kernelMonitors;
    private final CompilationTracer tracer;
    private final CypherConfiguration config;
    private final MasterCompiler masterCompiler;
    private final CypherQueryCaches queryCaches;
    private final InternalLogProvider logProvider;
    private final Clock clock;
    private final QueryExecutionMonitor defaultQueryExecutionMonitor;
    private final CachingPreParser preParser;
    private final DefaultQueryLanguageLookup defaultLanguageLookup;
    private final QueryCache<QueryCache.CacheKey<InputQuery.CacheKey>, ExecutableQuery> queryCache;
    private final SchemaHelper schemaHelper;

    public static Clock $lessinit$greater$default$8() {
        return ExecutionEngine$.MODULE$.$lessinit$greater$default$8();
    }

    public GraphDatabaseQueryService queryService() {
        return this.queryService;
    }

    public Monitors kernelMonitors() {
        return this.kernelMonitors;
    }

    public CompilationTracer tracer() {
        return this.tracer;
    }

    public CypherConfiguration config() {
        return this.config;
    }

    public MasterCompiler masterCompiler() {
        return this.masterCompiler;
    }

    public CypherQueryCaches queryCaches() {
        return this.queryCaches;
    }

    public InternalLogProvider logProvider() {
        return this.logProvider;
    }

    public Clock clock() {
        return this.clock;
    }

    public QueryExecutionMonitor defaultQueryExecutionMonitor() {
        return this.defaultQueryExecutionMonitor;
    }

    private CachingPreParser preParser() {
        return this.preParser;
    }

    private DefaultQueryLanguageLookup defaultLanguageLookup() {
        return this.defaultLanguageLookup;
    }

    private QueryCache<QueryCache.CacheKey<InputQuery.CacheKey>, ExecutableQuery> queryCache() {
        return this.queryCache;
    }

    private SchemaHelper schemaHelper() {
        return this.schemaHelper;
    }

    public QueryExecution execute(String query, MapValue params, TransactionalContext context, boolean profile, boolean prePopulate, QuerySubscriber subscriber, QueryExecutionMonitor monitor) {
        monitor.startProcessing(context.executingQuery());
        return this.executeSubquery(query, params, context, true, profile, prePopulate, subscriber, monitor);
    }

    public QueryExecution execute(FullyParsedQuery query, MapValue params, TransactionalContext context, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, QuerySubscriber subscriber) {
        queryMonitor.startProcessing(context.executingQuery());
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query.description());
        RecordingNotificationLogger notificationLogger = new RecordingNotificationLogger();
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable)() -> this.doExecute(query, params, context, true, prePopulate, input, queryMonitor, queryTracer, subscriber, (InternalNotificationLogger)notificationLogger));
    }

    public QueryExecutionMonitor execute$default$7() {
        return this.defaultQueryExecutionMonitor();
    }

    public QueryExecution executeSubquery(String query, MapValue params, TransactionalContext context, boolean isOutermostQuery, boolean profile, boolean prePopulate, QuerySubscriber subscriber, QueryExecutionMonitor monitor) {
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query);
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable)() -> {
            boolean couldContainSensitiveFields = isOutermostQuery && this.masterCompiler().supportsAdministrativeCommands();
            RecordingNotificationLogger notificationLogger = new RecordingNotificationLogger();
            DefaultQueryLanguageScope queryLangScope = context.kernelTransaction().defaultQueryLanguageScope();
            CypherVersion defaultLanguage = this.defaultLanguageLookup().dbDefaultQueryLanguage(queryLangScope, context.databaseId(), this.config().systemDefaultLanguage());
            PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, (InternalNotificationLogger)notificationLogger, defaultLanguage, profile, couldContainSensitiveFields, TransactionalContext.DatabaseMode.COMPOSITE.equals((Object)context.databaseMode()));
            return this.doExecute(preParsedQuery, params, context, isOutermostQuery, prePopulate, (InputDataStream)NoInput$.MODULE$, monitor, queryTracer, subscriber, (InternalNotificationLogger)notificationLogger);
        });
    }

    public QueryExecutionMonitor executeSubquery$default$8() {
        return this.defaultQueryExecutionMonitor();
    }

    private <T> T closing(TransactionalContext context, CompilationTracer.QueryCompilationEvent traceEvent, Function0<T> code) {
        Object object;
        try {
            try {
                object = code.apply();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof Status.HasStatus) {
                    Throwable throwable3 = throwable2;
                    context.kernelTransaction().markForTermination(((Status.HasStatus)throwable3).status());
                    context.close();
                    throw throwable3;
                }
                if (throwable2 != null) {
                    Throwable throwable4 = throwable2;
                    context.kernelTransaction().markForTermination((Status)Status.Transaction.QueryExecutionFailedOnTransaction);
                    context.close();
                    throw throwable4;
                }
                throw throwable;
            }
        }
        finally {
            traceEvent.close();
        }
        return (T)object;
    }

    private QueryExecution doExecute(InputQuery query, MapValue params, TransactionalContext context, boolean isOutermostQuery, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, CompilationTracer.QueryCompilationEvent tracer, QuerySubscriber subscriber, InternalNotificationLogger notificationLogger) {
        ExecutableQuery executableQuery;
        context.executingQuery().onPreparseReady(query.resolvedLanguage());
        try {
            executableQuery = this.getOrCompile(context, query, tracer, params, notificationLogger);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ErrorGqlStatusObject) {
                Throwable throwable3 = throwable2;
                if (isOutermostQuery) {
                    Status status;
                    Throwable throwable4 = throwable3;
                    if (throwable4 instanceof Status.HasStatus) {
                        Throwable throwable5 = throwable4;
                        status = ((Status.HasStatus)throwable5).status();
                    } else {
                        status = null;
                    }
                    Status status2 = status;
                    queryMonitor.endFailure(context.executingQuery(), throwable3.getMessage(), status2, (ErrorGqlStatusObject)throwable3);
                }
                throw throwable3;
            }
            if (throwable2 != null) {
                Throwable throwable6 = throwable2;
                if (isOutermostQuery) {
                    Status status;
                    Throwable throwable7 = throwable6;
                    if (throwable7 instanceof Status.HasStatus) {
                        Throwable throwable8 = throwable7;
                        status = ((Status.HasStatus)throwable8).status();
                    } else {
                        status = null;
                    }
                    Status status3 = status;
                    queryMonitor.endFailure(context.executingQuery(), throwable6.getMessage(), status3, null);
                }
                throw throwable6;
            }
            throw throwable;
        }
        ExecutableQuery executableQuery2 = executableQuery;
        String string = query.options().queryOptions().executionMode().name();
        String string2 = "explain";
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.checkParameters(executableQuery2.paramNames(), params, executableQuery2.extractedParams());
        }
        MapValue combinedParams = params.updatedWith(executableQuery2.extractedParams());
        if (isOutermostQuery) {
            context.executingQuery().onObfuscatorReady(executableQuery2.queryObfuscator(), query.options().offset().offset());
            context.executingQuery().onCompilationCompleted(executableQuery2.compilerInfo(), executableQuery2.planDescriptionSupplier(), executableQuery2.deprecationNotificationsProvider(query.options().offset()), executableQuery2.executionPlanCacheKeyHash());
        }
        QueryRuntimeConfig queryConfig = QueryRuntimeConfig$.MODULE$.createFrom(query.options().queryOptions(), query.options().derivedOptions(), this.config());
        return executableQuery2.execute(context, isOutermostQuery, query.options(), combinedParams, prePopulate, input, queryMonitor, subscriber, queryConfig);
    }

    private CompilerWithExpressionCodeGenOption<ExecutableQuery> compilerWithExpressionCodeGenOption(InputQuery inputQuery, CompilationTracer.QueryCompilationEvent tracer, TransactionalContext transactionalContext, MapValue params, InternalNotificationLogger notificationLogger, DatabaseReference sessionDatabase) {
        Function0 & Serializable compiledExpressionCompiler = (Function0 & Serializable)() -> this.masterCompiler().compile(inputQuery.withRecompilationLimitReached(), tracer, transactionalContext, params, notificationLogger, sessionDatabase);
        Function0 & Serializable interpretedExpressionCompiler = (Function0 & Serializable)() -> this.masterCompiler().compile(inputQuery, tracer, transactionalContext, params, notificationLogger, sessionDatabase);
        return new CompilerWithExpressionCodeGenOption<ExecutableQuery>(this, inputQuery, (Function0)compiledExpressionCompiler, (Function0)interpretedExpressionCompiler){
            private final /* synthetic */ ExecutionEngine $outer;
            private final InputQuery inputQuery$1;
            private final Function0 compiledExpressionCompiler$1;
            private final Function0 interpretedExpressionCompiler$1;

            public ExecutableQuery compile() {
                if (this.inputQuery$1.options().compileWhenHot() && this.$outer.config().recompilationLimit() == 0) {
                    return (ExecutableQuery)this.compiledExpressionCompiler$1.apply();
                }
                return (ExecutableQuery)this.interpretedExpressionCompiler$1.apply();
            }

            public ExecutableQuery compileWithExpressionCodeGen() {
                return (ExecutableQuery)this.compiledExpressionCompiler$1.apply();
            }

            public Option<ExecutableQuery> maybeCompileWithExpressionCodeGen(int hitCount, Function0<Object> shouldRecompile) {
                if (this.inputQuery$1.options().compileWhenHot() && this.$outer.config().recompilationLimit() > 0 && hitCount >= this.$outer.config().recompilationLimit() && shouldRecompile.apply$mcZ$sp()) {
                    return new Some(this.compiledExpressionCompiler$1.apply());
                }
                return None$.MODULE$;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.inputQuery$1 = inputQuery$1;
                this.compiledExpressionCompiler$1 = compiledExpressionCompiler$1;
                this.interpretedExpressionCompiler$1 = interpretedExpressionCompiler$1;
            }
        };
    }

    private ExecutableQuery getOrCompile(TransactionalContext context, InputQuery initialInputQuery, CompilationTracer.QueryCompilationEvent tracer, MapValue params, InternalNotificationLogger notificationLogger) {
        block7: {
            ExecutableQuery executableQuery;
            block6: {
                TransactionalContext tc = context.getOrBeginNewIfClosed();
                KernelTransaction.Revertable compilerAuthorization = tc.restrictCurrentTransaction(tc.securityContext().withMode((AccessMode)StaticAccessMode.READ));
                boolean forceReplan = false;
                InputQuery inputQuery = initialInputQuery;
                QueryCache.CacheKey<InputQuery.CacheKey> cacheKey = new QueryCache.CacheKey<InputQuery.CacheKey>(inputQuery.cacheKey(), QueryCache$.MODULE$.extractParameterTypeMap(params, this.config().useParameterSizeHint()), tc.kernelTransaction().dataRead().transactionStateHasChanges(), inputQuery.resolvedLanguage());
                try {
                    for (int n = 0; n < ExecutionEngineConst$.MODULE$.PLAN_BUILDING_TRIES(); ++n) {
                        long schemaToken = this.schemaHelper().readSchemaToken(tc);
                        if (forceReplan) {
                            forceReplan = false;
                            inputQuery = inputQuery.withReplanOption((CypherReplanOption)CypherReplanOption.force$.MODULE$);
                        }
                        CompilerWithExpressionCodeGenOption<ExecutableQuery> compiler = this.compilerWithExpressionCodeGenOption(inputQuery, tracer, tc, params, notificationLogger, new DatabaseReference(null, context){
                            private final TransactionalContext context$3;

                            public String name() {
                                return super.name();
                            }

                            public NormalizedDatabaseName alias() {
                                throw new NotImplementedError();
                            }

                            public Optional<NormalizedDatabaseName> namespace() {
                                throw new NotImplementedError();
                            }

                            public boolean isPrimary() {
                                throw new NotImplementedError();
                            }

                            public UUID id() {
                                throw new NotImplementedError();
                            }

                            public NamedDatabaseId namedDatabaseId() {
                                throw new NotImplementedError();
                            }

                            public String toPrettyString() {
                                throw new NotImplementedError();
                            }

                            public NormalizedDatabaseName fullName() {
                                return this.context$3.databaseId().normalizedName();
                            }

                            public boolean isComposite() {
                                return this.context$3.databaseMode().equals((Object)TransactionalContext.DatabaseMode.COMPOSITE);
                            }

                            public int compareTo(DatabaseReference o) {
                                throw new NotImplementedError();
                            }

                            public String owningDatabaseName() {
                                return this.fullName().name();
                            }

                            public NormalizedCatalogEntry catalogEntry() {
                                throw new NotImplementedError();
                            }

                            public boolean isShard() {
                                return false;
                            }
                            {
                                this.context$3 = context$3;
                            }
                        });
                        ExecutableQuery executableQuery2 = this.queryCache().computeIfAbsentOrStale(cacheKey, tc, compiler, inputQuery.options().queryOptions().replan(), context.executingQuery().id());
                        SchemaHelper.LockedEntities lockedEntities = this.schemaHelper().lockEntities(schemaToken, executableQuery2, tc);
                        if (lockedEntities.successful()) {
                            executableQuery = executableQuery2;
                            break block6;
                        }
                        forceReplan = lockedEntities.needsReplan();
                    }
                    break block7;
                }
                finally {
                    compilerAuthorization.close();
                }
            }
            return executableQuery;
        }
        throw CompilationException$.MODULE$.tooFrequentSchemaChanges();
    }

    public long clearQueryCaches() {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{this.masterCompiler().clearCaches(), this.queryCache().clear(), this.preParser().clearCache()}))).max((Ordering)Ordering.Long$.MODULE$));
    }

    public long clearPreParserCache() {
        return this.preParser().clearCache();
    }

    public long clearExecutableQueryCache() {
        return this.queryCache().clear();
    }

    public long clearCompilerCaches() {
        return this.masterCompiler().clearCaches();
    }

    public void insertIntoCache(PreParsedQuery preParsedQuery, MapValue params, BaseState parsedQuery, Set<InternalNotification> parsingNotifications) {
        this.preParser().insertIntoCache(preParsedQuery);
        this.masterCompiler().insertIntoCache(preParsedQuery, params, parsedQuery, parsingNotifications);
    }

    public java.util.List<FunctionInformation> getCypherFunctions() {
        List informations = this.config().vectorTypeEnabled() ? Function$.MODULE$.functionInfoWithFeatureFlags((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{SemanticFeature.VectorType$.MODULE$.productPrefix()}))).map((Function1)FunctionWithInformation$.MODULE$) : Function$.MODULE$.functionInfo().map((Function1)FunctionWithInformation$.MODULE$);
        scala.collection.immutable.Seq predicateInformations = (scala.collection.immutable.Seq)IterablePredicateExpression$.MODULE$.functionInfo().map((Function1)FunctionWithInformation$.MODULE$);
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)informations.$plus$plus((IterableOnce)predicateInformations)).asJava();
    }

    @Override
    public void close() {
        this.queryCaches().close();
    }

    private void checkParameters(String[] queryParams, MapValue givenParams, MapValue extractedParams) throws ParameterNotFoundException {
        for (int i = 0; i < queryParams.length; ++i) {
            String key2 = queryParams[i];
            if (givenParams.containsKey(key2) || extractedParams.containsKey(key2)) continue;
            String[] missingKeys = (String[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])queryParams), (Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ExecutionEngine.$anonfun$checkParameters$1(givenParams, extractedParams, key)))));
            throw ParameterNotFoundException.expectedParam((String)Predef$.MODULE$.wrapRefArray((Object[])missingKeys).mkString(", "), (Iterable)givenParams.keySet());
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkParameters$1(MapValue givenParams$1, MapValue extractedParams$1, String key) {
        return !givenParams$1.containsKey(key) && !extractedParams$1.containsKey(key);
    }

    public ExecutionEngine(GraphDatabaseQueryService queryService, Monitors kernelMonitors, CompilationTracer tracer, CypherConfiguration config, MasterCompiler masterCompiler, CypherQueryCaches queryCaches, InternalLogProvider logProvider, Clock clock) {
        this.queryService = queryService;
        this.kernelMonitors = kernelMonitors;
        this.tracer = tracer;
        this.config = config;
        this.masterCompiler = masterCompiler;
        this.queryCaches = queryCaches;
        this.logProvider = logProvider;
        this.clock = clock;
        this.defaultQueryExecutionMonitor = (QueryExecutionMonitor)kernelMonitors.newMonitor(QueryExecutionMonitor.class, new String[0]);
        this.preParser = new CachingPreParser(config, queryCaches.preParserCache());
        this.defaultLanguageLookup = (DefaultQueryLanguageLookup)queryService.getDependencyResolver().resolveDependency(DefaultQueryLanguageLookup.class);
        this.queryCache = queryCaches.executableQueryCache();
        this.schemaHelper = new SchemaHelper(this.queryCache(), masterCompiler);
    }
}

