/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.mgt;

import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.CacheManagerAware;
import org.apache.shiro.event.EventBus;
import org.apache.shiro.event.EventBusAware;
import org.apache.shiro.event.support.DefaultEventBus;
import org.apache.shiro.lang.util.Destroyable;
import org.apache.shiro.lang.util.LifecycleUtils;
import org.apache.shiro.mgt.SecurityManager;

public abstract class CachingSecurityManager
implements SecurityManager,
Destroyable,
CacheManagerAware,
EventBusAware {
    private CacheManager cacheManager;
    private EventBus eventBus;

    public CachingSecurityManager() {
        this.setEventBus((EventBus)new DefaultEventBus());
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.afterCacheManagerSet();
    }

    protected void afterCacheManagerSet() {
        this.applyEventBusToCacheManager();
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
        this.afterEventBusSet();
    }

    protected void applyEventBusToCacheManager() {
        if (this.eventBus != null && this.cacheManager != null && this.cacheManager instanceof EventBusAware) {
            ((EventBusAware)this.cacheManager).setEventBus(this.eventBus);
        }
    }

    protected void afterEventBusSet() {
        this.applyEventBusToCacheManager();
    }

    public void destroy() {
        LifecycleUtils.destroy((Object)this.getCacheManager());
        this.cacheManager = null;
        LifecycleUtils.destroy((Object)this.getEventBus());
        this.eventBus = new DefaultEventBus();
    }
}

