/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.realm;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.shiro.authc.LogoutAware;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.CacheManagerAware;
import org.apache.shiro.lang.util.Nameable;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CachingRealm
implements Realm,
Nameable,
CacheManagerAware,
LogoutAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingRealm.class);
    private static final AtomicInteger INSTANCE_COUNT = new AtomicInteger();
    private String name = this.getClass().getName() + "_" + INSTANCE_COUNT.getAndIncrement();
    private boolean cachingEnabled = true;
    private CacheManager cacheManager;

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.afterCacheManagerSet();
    }

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public void setCachingEnabled(boolean cachingEnabled) {
        this.cachingEnabled = cachingEnabled;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void afterCacheManagerSet() {
    }

    @Override
    public void onLogout(PrincipalCollection principals) {
        this.clearCache(principals);
    }

    private static boolean isEmpty(PrincipalCollection pc) {
        return pc == null || pc.isEmpty();
    }

    protected void clearCache(PrincipalCollection principals) {
        if (!CachingRealm.isEmpty(principals)) {
            this.doClearCache(principals);
            LOGGER.trace("Cleared cache entries for account with principals [{}]", (Object)principals);
        }
    }

    protected void doClearCache(PrincipalCollection principals) {
    }

    protected Object getAvailablePrincipal(PrincipalCollection principals) {
        Object primary = null;
        if (!CachingRealm.isEmpty(principals)) {
            Collection thisPrincipals = principals.fromRealm(this.getName());
            primary = !CollectionUtils.isEmpty(thisPrincipals) ? thisPrincipals.iterator().next() : principals.getPrimaryPrincipal();
        }
        return primary;
    }
}

