/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.util.Objects;

public record ConsistencyFlags(boolean checkStructure, boolean checkIndexes, ConstraintFlags checkConstraints, boolean checkGraph, boolean checkCounts, boolean checkPropertyOwners, boolean checkPropertyValues) {
    public static final ConsistencyFlags NONE = new ConsistencyFlags(false, false, ConstraintFlags.NO_CONSTRAINTS, false, false, false, false);
    public static final ConsistencyFlags ALL = new ConsistencyFlags(true, true, ConstraintFlags.ALL_CONSTRAINTS, true, true, true, true);
    public static final ConsistencyFlags DEFAULT = ALL.withoutCheckPropertyOwners().withoutCheckPropertyValues();

    public ConsistencyFlags {
        IllegalArgumentException argumentException = null;
        if (!checkGraph) {
            if (checkCounts) {
                argumentException = ConsistencyFlags.requireNonNullAndAppendException(argumentException, ConsistencyFlags.checkGraphInvariant("checkCounts"));
            }
            if (checkPropertyOwners) {
                argumentException = ConsistencyFlags.requireNonNullAndAppendException(argumentException, ConsistencyFlags.checkGraphInvariant("checkPropertyOwners"));
            }
            if (checkPropertyValues) {
                argumentException = ConsistencyFlags.requireNonNullAndAppendException(argumentException, ConsistencyFlags.checkGraphInvariant("checkPropertyValues"));
            }
        }
        if (argumentException != null) {
            throw argumentException;
        }
    }

    public ConsistencyFlags(boolean checkIndexes, boolean checkGraph, boolean checkCounts, boolean checkPropertyOwners) {
        this(DEFAULT.checkStructure(), checkIndexes, DEFAULT.checkConstraints(), checkGraph, checkCounts, checkPropertyOwners, DEFAULT.checkPropertyValues());
    }

    public ConsistencyFlags withCheckStructure() {
        return new ConsistencyFlags(true, this.checkIndexes, this.checkConstraints, this.checkGraph, this.checkCounts, this.checkPropertyOwners, this.checkPropertyValues);
    }

    public ConsistencyFlags withoutCheckStructure() {
        return new ConsistencyFlags(false, this.checkIndexes, this.checkConstraints, this.checkGraph, this.checkCounts, this.checkPropertyOwners, this.checkPropertyValues);
    }

    public ConsistencyFlags withCheckIndexes() {
        return new ConsistencyFlags(this.checkStructure, true, this.checkConstraints, this.checkGraph, this.checkCounts, this.checkPropertyOwners, this.checkPropertyValues);
    }

    public ConsistencyFlags withoutCheckIndexes() {
        return new ConsistencyFlags(this.checkStructure, false, this.checkConstraints, this.checkGraph, this.checkCounts, this.checkPropertyOwners, this.checkPropertyValues);
    }

    public ConsistencyFlags withCheckConstraints() {
        return new ConsistencyFlags(this.checkStructure, this.checkIndexes, ConstraintFlags.ALL_CONSTRAINTS, this.checkGraph, this.checkCounts, this.checkPropertyOwners, this.checkPropertyValues);
    }

    public ConsistencyFlags withoutCheckConstraints() {
        return new ConsistencyFlags(this.checkStructure, this.checkIndexes, ConstraintFlags.NO_CONSTRAINTS, this.checkGraph, this.checkCounts, this.checkPropertyOwners, this.checkPropertyValues);
    }

    public ConsistencyFlags withoutCheckPropertyConstraints() {
        return new ConsistencyFlags(this.checkStructure, this.checkIndexes, ConstraintFlags.NO_PROPERTY_CONSTRAINTS, this.checkGraph, this.checkCounts, this.checkPropertyOwners, this.checkPropertyValues);
    }

    public ConsistencyFlags withoutCheckRelEndpointConstraints() {
        return new ConsistencyFlags(this.checkStructure, this.checkIndexes, ConstraintFlags.NO_REL_ENDPOINT_CONSTRAINTS, this.checkGraph, this.checkCounts, this.checkPropertyOwners, this.checkPropertyValues);
    }

    public ConsistencyFlags withCheckGraph() {
        return new ConsistencyFlags(this.checkStructure, this.checkIndexes, this.checkConstraints, true, this.checkCounts, this.checkPropertyOwners, this.checkPropertyValues);
    }

    public ConsistencyFlags withoutCheckGraph() {
        return new ConsistencyFlags(this.checkStructure, this.checkIndexes, this.checkConstraints, false, false, false, false);
    }

    public ConsistencyFlags withCheckCounts() {
        return new ConsistencyFlags(this.checkStructure, this.checkIndexes, this.checkConstraints, true, true, this.checkPropertyOwners, this.checkPropertyValues);
    }

    public ConsistencyFlags withoutCheckCounts() {
        return new ConsistencyFlags(this.checkStructure, this.checkIndexes, this.checkConstraints, this.checkGraph, false, this.checkPropertyOwners, this.checkPropertyValues);
    }

    public ConsistencyFlags withCheckPropertyOwners() {
        return new ConsistencyFlags(this.checkStructure, this.checkIndexes, this.checkConstraints, true, this.checkCounts, true, this.checkPropertyValues);
    }

    public ConsistencyFlags withoutCheckPropertyOwners() {
        return new ConsistencyFlags(this.checkStructure, this.checkIndexes, this.checkConstraints, this.checkGraph, this.checkCounts, false, this.checkPropertyValues);
    }

    public ConsistencyFlags withCheckPropertyValues() {
        return new ConsistencyFlags(this.checkStructure, this.checkIndexes, this.checkConstraints, true, this.checkCounts, this.checkPropertyOwners, true);
    }

    public ConsistencyFlags withoutCheckPropertyValues() {
        return new ConsistencyFlags(this.checkStructure, this.checkIndexes, this.checkConstraints, this.checkGraph, this.checkCounts, this.checkPropertyOwners, false);
    }

    private static IllegalArgumentException requireNonNullAndAppendException(IllegalArgumentException argumentException, Exception exception) {
        IllegalArgumentException ex = Objects.requireNonNullElseGet(argumentException, IllegalArgumentException::new);
        ex.addSuppressed(exception);
        return ex;
    }

    private static IllegalArgumentException checkGraphInvariant(String check) {
        return new IllegalArgumentException("'%s' cannot be set to '%s' with 'checkGraph' set to '%s'.".formatted(check, true, false));
    }

    public record ConstraintFlags(boolean propertyConstraints, boolean relEndpointConstraints, boolean labelExistenceConstraints) {
        public static final ConstraintFlags ALL_CONSTRAINTS = new ConstraintFlags(true, true, true);
        public static final ConstraintFlags NO_CONSTRAINTS = new ConstraintFlags(false, false, false);
        public static final ConstraintFlags NO_PROPERTY_CONSTRAINTS = new ConstraintFlags(false, true, true);
        public static final ConstraintFlags NO_REL_ENDPOINT_CONSTRAINTS = new ConstraintFlags(true, false, true);
    }
}

