/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.exceptions.schema;

import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.Log;

public class TokenCapacityExceededKernelException
extends SchemaKernelException {
    public static String detailedMessage(String tokenType) {
        return String.format("The maximum number of %ss available has been reached, no more can be created.", tokenType);
    }

    private TokenCapacityExceededKernelException(ErrorGqlStatusObject gqlStatusObject, Throwable cause, String tokenType) {
        super(gqlStatusObject, (Status)Status.Schema.TokenLimitReached, TokenCapacityExceededKernelException.detailedMessage(tokenType), cause);
    }

    public static TokenCapacityExceededKernelException tokenCapacityExceeded(Throwable cause, String tokenType, Log log) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N59).build();
        TokenCapacityExceededKernelException e = new TokenCapacityExceededKernelException(gql, cause, tokenType);
        log.error(TokenCapacityExceededKernelException.detailedMessage(tokenType), (Throwable)((Object)e));
        return e;
    }
}

