/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.Clock;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import org.neo4j.kernel.api.index.IndexUsageStats;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;

public final class DefaultIndexUsageTracking
implements IndexUsageTracking {
    private final long trackedSince;
    private final LongAdder readCount = new LongAdder();
    private final LongAccumulator lastRead = new LongAccumulator(Long::max, 0L);
    private final Clock clock;

    public DefaultIndexUsageTracking(Clock clock) {
        this.clock = clock;
        this.trackedSince = clock.millis();
    }

    @Override
    public IndexUsageStats getAndReset() {
        return new IndexUsageStats(this.lastRead.longValue(), this.readCount.sumThenReset(), this.trackedSince);
    }

    @Override
    public void queried() {
        this.readCount.increment();
        this.lastRead.accumulate(this.clock.millis());
    }
}

