/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;

@FunctionalInterface
public interface IndexUpdateIgnoreStrategy {
    public static final IndexUpdateIgnoreStrategy NO_IGNORE = new IndexUpdateIgnoreStrategy(){

        @Override
        public boolean ignore(Value[] values) {
            return false;
        }

        @Override
        public boolean ignore(ValueIndexEntryUpdate update) {
            return false;
        }

        @Override
        public ValueIndexEntryUpdate toEquivalentUpdate(ValueIndexEntryUpdate update) {
            return update;
        }
    };

    public boolean ignore(Value[] var1);

    default public boolean ignore(ValueIndexEntryUpdate update) {
        if (update.updateMode() == UpdateMode.CHANGED) {
            return this.ignore(update.beforeValues()) && this.ignore(update.values());
        }
        return this.ignore(update.values());
    }

    default public ValueIndexEntryUpdate toEquivalentUpdate(ValueIndexEntryUpdate update) {
        boolean shouldAdd;
        if (update.updateMode() != UpdateMode.CHANGED) {
            return update;
        }
        Value[] beforeValues = update.beforeValues();
        Value[] afterValues = update.values();
        boolean shouldRemove = !this.ignore(beforeValues);
        boolean bl = shouldAdd = !this.ignore(afterValues);
        if (shouldRemove && shouldAdd) {
            return update;
        }
        IndexDescriptor key = update.indexKey();
        long entityId = update.getEntityId();
        if (shouldRemove) {
            return ValueIndexEntryUpdate.remove(entityId, key, beforeValues);
        }
        if (shouldAdd) {
            return ValueIndexEntryUpdate.add(entityId, key, afterValues);
        }
        throw new IllegalStateException("Attempted a " + String.valueOf((Object)UpdateMode.CHANGED) + " update, which was not applicable to the index");
    }
}

