/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security;

import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SaltedAuthenticationInfo;
import org.apache.shiro.crypto.hash.SimpleHash;
import org.apache.shiro.lang.codec.Hex;
import org.apache.shiro.lang.util.ByteSource;
import org.apache.shiro.subject.PrincipalCollection;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.server.security.FormatException;
import org.neo4j.server.security.SecureHasher;
import org.neo4j.server.security.SecureHasherConfiguration;
import org.neo4j.server.security.SecureHasherConfigurations;

public class SystemGraphCredential
implements Credential {
    private final SecureHasher secureHasher;
    private final SimpleHash hashedCredentials;

    private SystemGraphCredential(SecureHasher secureHasher, SimpleHash hash) {
        this.secureHasher = secureHasher;
        this.hashedCredentials = hash;
    }

    public boolean matchesPassword(final byte[] password) {
        return this.secureHasher.getHashedCredentialsMatcherWithIterations(this.hashedCredentials.getIterations()).doCredentialsMatch(new AuthenticationToken(){

            public Object getCredentials() {
                return password;
            }

            public Object getPrincipal() {
                return null;
            }
        }, (AuthenticationInfo)new SaltedAuthenticationInfo(){

            public Object getCredentials() {
                return SystemGraphCredential.this.hashedCredentials.getBytes();
            }

            public ByteSource getCredentialsSalt() {
                return SystemGraphCredential.this.hashedCredentials.getSalt();
            }

            public PrincipalCollection getPrincipals() {
                return null;
            }
        });
    }

    public static SystemGraphCredential createCredentialForPassword(byte[] password, SecureHasher secureHasher) {
        SimpleHash hash = secureHasher.hash(password);
        return new SystemGraphCredential(secureHasher, hash);
    }

    public String serialize() {
        return SystemGraphCredential.serialize(this);
    }

    public static String serialize(SystemGraphCredential credential) {
        String algorithm = credential.hashedCredentials.getAlgorithmName();
        String iterations = Integer.toString(credential.hashedCredentials.getIterations());
        String encodedSalt = credential.hashedCredentials.getSalt().toHex();
        String encodedPassword = credential.hashedCredentials.toHex();
        return String.join((CharSequence)",", algorithm, encodedPassword, encodedSalt, iterations);
    }

    public static String serialize(byte[] encodedCredential) throws InvalidArgumentException {
        String encryptedPasswordString;
        Pattern validEncryptedPassword = Pattern.compile(String.join((CharSequence)",", "^([0-9])", "([A-Fa-f0-9]+)", "([A-Fa-f0-9]+)"));
        Matcher matcher = validEncryptedPassword.matcher(encryptedPasswordString = new String(encodedCredential, StandardCharsets.UTF_8));
        if (matcher.matches()) {
            String version = matcher.group(1);
            String hash = matcher.group(2);
            String salt = matcher.group(3);
            SecureHasherConfiguration configuration = SecureHasherConfigurations.configurations.get(version);
            if (configuration == null) {
                throw InvalidArgumentException.invalidEncryptionVersion((String)version, SecureHasherConfigurations.configurations.keySet().stream().toList());
            }
            return String.join((CharSequence)",", configuration.algorithm, hash, salt, String.valueOf(configuration.iterations));
        }
        throw InvalidArgumentException.incorrectPasswordFormat();
    }

    public static String maskSerialized(String serialized) throws IllegalArgumentException {
        Pattern validSerialized = Pattern.compile(String.join((CharSequence)",", "^([A-Za-z0-9\\-]+)", "([A-Fa-f0-9]+)", "([A-Fa-f0-9]+)") + "(?:,([0-9]+))?");
        Matcher matcher = validSerialized.matcher(serialized);
        if (matcher.matches()) {
            String algorithm = matcher.group(1);
            String hash = matcher.group(2);
            String salt = matcher.group(3);
            String iterationGroup = matcher.group(4);
            int iterations = iterationGroup != null ? Integer.parseInt(iterationGroup) : 1;
            String version = SecureHasherConfigurations.getVersionForConfiguration(algorithm, iterations);
            return String.join((CharSequence)",", version, hash, salt);
        }
        throw new IllegalArgumentException("Invalid serialized credential.");
    }

    public static SystemGraphCredential deserialize(String part, SecureHasher secureHasher) throws FormatException {
        String[] split = part.split(",", -1);
        if (split.length < 3 || split.length > 4) {
            throw new FormatException("wrong number of credential fields");
        }
        String algorithm = split[0];
        byte[] decodedPassword = Hex.decode((String)split[1]);
        byte[] decodedSalt = Hex.decode((String)split[2]);
        int iterations = split.length == 4 ? Integer.parseInt(split[3]) : 1;
        SimpleHash hash = new SimpleHash(algorithm);
        hash.setBytes(decodedPassword);
        hash.setSalt(ByteSource.Util.bytes((byte[])decodedSalt));
        hash.setIterations(iterations);
        return new SystemGraphCredential(secureHasher, hash);
    }
}

