/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.indexcommand.encode;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.io.fs.ReadableChannel;

public class PeekableChannel
implements ReadableChannel {
    private byte peekedByte;
    private boolean peekedInUse;
    private final ReadableChannel channel;

    public PeekableChannel(ReadableChannel channel) {
        this.channel = channel;
    }

    public byte get() throws IOException {
        if (this.peekedInUse) {
            this.peekedInUse = false;
            return this.peekedByte;
        }
        return this.channel.get();
    }

    public short getShort() throws IOException {
        return this.channel.getShort();
    }

    public int getInt() throws IOException {
        return this.channel.getInt();
    }

    public long getLong() throws IOException {
        return this.channel.getLong();
    }

    public float getFloat() throws IOException {
        return this.channel.getFloat();
    }

    public double getDouble() throws IOException {
        return this.channel.getDouble();
    }

    public void get(byte[] bytes, int length) throws IOException {
        this.channel.get(bytes, length);
    }

    public boolean isOpen() {
        return false;
    }

    public void close() throws IOException {
        this.channel.close();
    }

    byte peek() throws IOException {
        this.peekedByte = this.channel.get();
        this.peekedInUse = true;
        return this.peekedByte;
    }

    public byte getVersion() throws IOException {
        return this.channel.getVersion();
    }

    public long getAppendIndex() throws IOException {
        return this.channel.getAppendIndex();
    }

    public int read(ByteBuffer dst) throws IOException {
        return 0;
    }

    public void beginChecksum() {
    }

    public int getChecksum() {
        return 0;
    }

    public int endChecksumAndValidate() {
        return 0;
    }

    public long position() throws IOException {
        return 0L;
    }

    public void position(long byteOffset) throws IOException {
    }
}

