/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.indexcommand.encode;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import org.neo4j.internal.helpers.TimeUtil;
import org.neo4j.internal.indexcommand.encode.PeekableChannel;
import org.neo4j.internal.indexcommand.encode.ValueType;
import org.neo4j.internal.indexcommand.encode.ValueWriter;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.TemporalUtil;

public class ValueStream {
    static final byte TINY_STRING = -128;
    static final byte FALSE = -112;
    static final byte TRUE = -96;
    static final byte INT_8 = -80;
    static final byte INT_16 = -64;
    static final byte INT_32 = -63;
    static final byte INT_64 = -62;
    static final byte FLOAT_64 = -61;
    static final byte STRING_8 = -60;
    static final byte STRING_16 = -59;
    static final byte STRING_32 = -58;
    static final byte POINT_2D = -57;
    static final byte POINT_3D = -56;
    static final byte DATE = -55;
    static final byte TIME = -54;
    static final byte LOCAL_TIME = -53;
    static final byte LOCAL_DATE_TIME = -52;
    static final byte DATE_TIME_WITH_ZONE_OFFSET = -51;
    static final byte DATE_TIME_WITH_ZONE_NAME = -50;
    static final byte DURATION = -49;
    static final byte BYTES_8 = -48;
    static final byte BYTES_16 = -47;
    static final byte BYTES_32 = -46;
    static final byte ARRAY_8 = -45;
    static final byte ARRAY_16 = -44;
    static final byte ARRAY_32 = -43;
    static final byte FLOAT_ARRAY = -42;
    static final byte DOUBLE_ARRAY = -41;
    static final byte LONG_ARRAY = -40;
    static final byte INT_ARRAY = -39;
    static final byte SHORT_ARRAY = -38;
    static final byte BOOLEAN_ARRAY = -37;
    static final byte CHAR_ARRAY = -36;
    static final byte STRING_ARRAY = -35;
    static final byte DATE_TIME_ARRAY = -34;
    static final byte LOCAL_DATE_TIME_ARRAY = -33;
    static final byte DATE_ARRAY = -32;
    static final byte ZONED_TIME_ARRAY = -31;
    static final byte TIME_ARRAY = -30;
    static final byte DURATION_ARRAY = -29;
    static final byte POINT_ARRAY = -28;
    static final byte NULL = -27;
    static final byte INT_8_VECTOR = -26;
    static final byte INT_16_VECTOR = -25;
    static final byte INT_32_VECTOR = -24;
    static final byte INT_64_VECTOR = -23;
    static final byte FLOAT_32_VECTOR = -22;
    static final byte FLOAT_64_VECTOR = -21;
    private static final long PLUS_2_TO_THE_31 = 0x80000000L;
    private static final long PLUS_2_TO_THE_15 = 32768L;
    private static final long PLUS_2_TO_THE_7 = 128L;
    private static final long MINUS_2_TO_THE_4 = -16L;
    private static final long MINUS_2_TO_THE_7 = -128L;
    private static final long MINUS_2_TO_THE_15 = -32768L;
    private static final long MINUS_2_TO_THE_31 = Integer.MIN_VALUE;
    private static final char PACKED_CHAR_START_CHAR = ' ';
    private static final char PACKED_CHAR_END_CHAR = '~';
    private static final String[] PACKED_CHARS = ValueStream.prePackChars();

    public static void write(WritableChannel out, AnyValue value) throws IOException {
        value.writeTo((AnyValueWriter)new ValueWriter(out));
    }

    public static Value readValue(PeekableChannel in) throws IOException {
        ValueType valType = ValueStream.peekNextType(in);
        return switch (valType) {
            case ValueType.BOOLEAN -> Values.booleanValue((boolean)ValueStream.readBoolean(in));
            case ValueType.INTEGER -> Values.longValue((long)ValueStream.readLong(in));
            case ValueType.FLOAT -> Values.doubleValue((double)ValueStream.readDouble(in));
            case ValueType.STRING -> Values.utf8Value((byte[])ValueStream.readUTF8(in));
            case ValueType.POINT_2D -> ValueStream.readPoint2D(in);
            case ValueType.POINT_3D -> ValueStream.readPoint3D(in);
            case ValueType.DURATION -> ValueStream.readDuration(in);
            case ValueType.DATE -> ValueStream.readDate(in);
            case ValueType.LOCAL_TIME -> ValueStream.readLocalTime(in);
            case ValueType.TIME -> ValueStream.readTime(in);
            case ValueType.LOCAL_DATE_TIME -> ValueStream.readLocalDateTime(in);
            case ValueType.DATE_TIME_WITH_ZONE_OFFSET -> ValueStream.readDateTimeWithZoneOffset(in);
            case ValueType.DATE_TIME_WITH_ZONE_NAME -> ValueStream.readDateTimeWithZoneName(in);
            case ValueType.BYTES -> Values.byteArray((byte[])ValueStream.readBytes(in, ValueStream.unpackBytesHeader(in)));
            case ValueType.ARRAY -> ValueStream.readArray(in);
            case ValueType.NULL -> Values.NO_VALUE;
            case ValueType.INT_8_VECTOR -> ValueStream.readInt8Vector(in);
            case ValueType.INT_16_VECTOR -> ValueStream.readInt16Vector(in);
            case ValueType.INT_32_VECTOR -> ValueStream.readInt32Vector(in);
            case ValueType.INT_64_VECTOR -> ValueStream.readInt64Vector(in);
            case ValueType.FLOAT_32_VECTOR -> ValueStream.readFloat32Vector(in);
            case ValueType.FLOAT_64_VECTOR -> ValueStream.readFloat64Vector(in);
            default -> throw new IllegalArgumentException("Unknown value type: " + String.valueOf((Object)valType));
        };
    }

    private static Value readArray(PeekableChannel in) throws IOException {
        int size = ValueStream.unpackArrayHeader(in);
        byte arrayType = in.get();
        return switch (arrayType) {
            case -42 -> Values.floatArray((float[])ValueStream.readFloats(in, size));
            case -41 -> Values.doubleArray((double[])ValueStream.readDoubles(in, size));
            case -40 -> Values.longArray((long[])ValueStream.readLongs(in, size));
            case -39 -> Values.intArray((int[])ValueStream.readInts(in, size));
            case -38 -> Values.shortArray((short[])ValueStream.readShorts(in, size));
            case -37 -> Values.booleanArray((boolean[])ValueStream.readBooleans(in, size));
            case -36 -> Values.charArray((char[])ValueStream.readChars(in, size));
            case -35 -> Values.stringArray((String[])ValueStream.readStrings(in, size));
            case -34 -> Values.dateTimeArray((ZonedDateTime[])ValueStream.readDateTimeWithZoneNames(in, size));
            case -33 -> Values.localDateTimeArray((LocalDateTime[])ValueStream.readLocalDateTimes(in, size));
            case -32 -> Values.dateArray((LocalDate[])ValueStream.readDates(in, size));
            case -31 -> Values.localTimeArray((LocalTime[])ValueStream.readLocalTimes(in, size));
            case -30 -> Values.timeArray((OffsetTime[])ValueStream.readTimes(in, size));
            case -29 -> Values.durationArray((DurationValue[])ValueStream.readDurations(in, size));
            case -28 -> Values.pointArray((PointValue[])ValueStream.readPoints(in, size));
            default -> throw new IllegalArgumentException("Unknown array type: " + arrayType);
        };
    }

    private static LocalDate[] readDates(PeekableChannel in, int size) throws IOException {
        LocalDate[] data = new LocalDate[size];
        for (int i = 0; i < size; ++i) {
            data[i] = ValueStream.readRawDate(in);
        }
        return data;
    }

    private static LocalTime[] readLocalTimes(PeekableChannel in, int size) throws IOException {
        LocalTime[] data = new LocalTime[size];
        for (int i = 0; i < size; ++i) {
            data[i] = ValueStream.readRawLocalTime(in);
        }
        return data;
    }

    private static OffsetTime[] readTimes(PeekableChannel in, int size) throws IOException {
        OffsetTime[] data = new OffsetTime[size];
        for (int i = 0; i < size; ++i) {
            data[i] = ValueStream.readRawTime(in);
        }
        return data;
    }

    private static DurationValue[] readDurations(PeekableChannel in, int size) throws IOException {
        DurationValue[] data = new DurationValue[size];
        for (int i = 0; i < size; ++i) {
            data[i] = ValueStream.readDuration(in);
        }
        return data;
    }

    private static PointValue[] readPoints(PeekableChannel in, int size) throws IOException {
        PointValue[] data = new PointValue[size];
        for (int i = 0; i < size; ++i) {
            data[i] = (PointValue)ValueStream.readValue(in);
        }
        return data;
    }

    private static LocalDateTime[] readLocalDateTimes(PeekableChannel in, int size) throws IOException {
        LocalDateTime[] data = new LocalDateTime[size];
        for (int i = 0; i < size; ++i) {
            data[i] = ValueStream.readRawLocalDateTime(in);
        }
        return data;
    }

    private static ZonedDateTime[] readDateTimeWithZoneNames(PeekableChannel in, int size) throws IOException {
        ZonedDateTime[] data = new ZonedDateTime[size];
        for (int i = 0; i < size; ++i) {
            byte typeByte = in.get();
            data[i] = switch (typeByte) {
                case -51 -> ValueStream.readRawDateTimeWithZoneOffset(in);
                case -50 -> ValueStream.readRawDateTimeWithZoneName(in);
                default -> throw new IllegalArgumentException("Unknown value type: " + typeByte);
            };
        }
        return data;
    }

    private static String[] readStrings(PeekableChannel in, int size) throws IOException {
        String[] data = new String[size];
        for (int i = 0; i < size; ++i) {
            data[i] = ValueStream.readString(in);
        }
        return data;
    }

    private static char[] readChars(PeekableChannel in, int size) throws IOException {
        char[] data = new char[size];
        for (int i = 0; i < size; ++i) {
            data[i] = ValueStream.readString(in).charAt(0);
        }
        return data;
    }

    private static boolean[] readBooleans(PeekableChannel in, int size) throws IOException {
        boolean[] data = new boolean[size];
        for (int i = 0; i < size; ++i) {
            data[i] = ValueStream.readBoolean(in);
        }
        return data;
    }

    private static float[] readFloats(PeekableChannel in, int size) throws IOException {
        float[] data = new float[size];
        for (int i = 0; i < size; ++i) {
            data[i] = (float)ValueStream.readDouble(in);
        }
        return data;
    }

    private static double[] readDoubles(PeekableChannel in, int size) throws IOException {
        double[] data = new double[size];
        for (int i = 0; i < size; ++i) {
            data[i] = ValueStream.readDouble(in);
        }
        return data;
    }

    private static long[] readLongs(PeekableChannel in, int size) throws IOException {
        long[] data = new long[size];
        for (int i = 0; i < size; ++i) {
            data[i] = ValueStream.readLong(in);
        }
        return data;
    }

    private static int[] readInts(PeekableChannel in, int size) throws IOException {
        int[] data = new int[size];
        for (int i = 0; i < size; ++i) {
            data[i] = ValueStream.readInteger(in);
        }
        return data;
    }

    private static short[] readShorts(PeekableChannel in, int size) throws IOException {
        short[] data = new short[size];
        for (int i = 0; i < size; ++i) {
            data[i] = (short)ValueStream.readInteger(in);
        }
        return data;
    }

    private static Value readInt8Vector(PeekableChannel in) throws IOException {
        in.get();
        int dimensions = ValueStream.readInteger(in);
        byte[] array = ValueStream.readRawBytes(in, dimensions);
        return Values.int8Vector((byte[])array);
    }

    private static Value readInt16Vector(PeekableChannel in) throws IOException {
        in.get();
        int dimensions = ValueStream.readInteger(in);
        short[] array = new short[dimensions];
        for (int i = 0; i < dimensions; ++i) {
            array[i] = in.getShort();
        }
        return Values.int16Vector((short[])array);
    }

    private static Value readInt32Vector(PeekableChannel in) throws IOException {
        in.get();
        int dimensions = ValueStream.readInteger(in);
        int[] array = new int[dimensions];
        for (int i = 0; i < dimensions; ++i) {
            array[i] = in.getInt();
        }
        return Values.int32Vector((int[])array);
    }

    private static Value readInt64Vector(PeekableChannel in) throws IOException {
        in.get();
        int dimensions = ValueStream.readInteger(in);
        long[] array = new long[dimensions];
        for (int i = 0; i < dimensions; ++i) {
            array[i] = in.getLong();
        }
        return Values.int64Vector((long[])array);
    }

    private static Value readFloat32Vector(PeekableChannel in) throws IOException {
        in.get();
        int dimensions = ValueStream.readInteger(in);
        float[] array = new float[dimensions];
        for (int i = 0; i < dimensions; ++i) {
            array[i] = in.getFloat();
        }
        return Values.float32Vector((float[])array);
    }

    private static Value readFloat64Vector(PeekableChannel in) throws IOException {
        in.get();
        int dimensions = ValueStream.readInteger(in);
        double[] array = new double[dimensions];
        for (int i = 0; i < dimensions; ++i) {
            array[i] = in.getDouble();
        }
        return Values.float64Vector((double[])array);
    }

    private static ValueType peekNextType(PeekableChannel in) throws IOException {
        return ValueStream.type(in.peek());
    }

    private static ValueType type(byte markerByte) {
        byte markerHighNibble = (byte)(markerByte & 0xF0);
        if (markerHighNibble == -128) {
            return ValueType.STRING;
        }
        if ((long)markerByte >= -16L) {
            return ValueType.INTEGER;
        }
        return switch (markerByte) {
            case -112, -96 -> ValueType.BOOLEAN;
            case -80, -64, -63, -62 -> ValueType.INTEGER;
            case -61 -> ValueType.FLOAT;
            case -128, -60, -59, -58 -> ValueType.STRING;
            case -57 -> ValueType.POINT_2D;
            case -56 -> ValueType.POINT_3D;
            case -55 -> ValueType.DATE;
            case -54 -> ValueType.TIME;
            case -53 -> ValueType.LOCAL_TIME;
            case -52 -> ValueType.LOCAL_DATE_TIME;
            case -51 -> ValueType.DATE_TIME_WITH_ZONE_OFFSET;
            case -50 -> ValueType.DATE_TIME_WITH_ZONE_NAME;
            case -49 -> ValueType.DURATION;
            case -48, -47, -46 -> ValueType.BYTES;
            case -45, -44, -43 -> ValueType.ARRAY;
            case -27 -> ValueType.NULL;
            case -26 -> ValueType.INT_8_VECTOR;
            case -25 -> ValueType.INT_16_VECTOR;
            case -24 -> ValueType.INT_32_VECTOR;
            case -23 -> ValueType.INT_64_VECTOR;
            case -22 -> ValueType.FLOAT_32_VECTOR;
            case -21 -> ValueType.FLOAT_64_VECTOR;
            default -> ValueType.RESERVED;
        };
    }

    private static String[] prePackChars() {
        int size = 95;
        String[] packedChars = new String[size];
        for (int i = 0; i < size; ++i) {
            packedChars[i] = String.valueOf((char)(i + 32));
        }
        return packedChars;
    }

    static void write(WritableChannel out, boolean value) throws IOException {
        out.put(value ? (byte)-96 : -112);
    }

    public static void writeNoValue(WritableChannel out) throws IOException {
        out.put((byte)-27);
    }

    static void write(WritableChannel out, long value) throws IOException {
        if (value >= -16L && value < 128L) {
            out.put((byte)value);
        } else if (value >= -128L && value < -16L) {
            out.put((byte)-80).put((byte)value);
        } else if (value >= -32768L && value < 32768L) {
            out.put((byte)-64).putShort((short)value);
        } else if (value >= Integer.MIN_VALUE && value < 0x80000000L) {
            out.put((byte)-63).putInt((int)value);
        } else {
            out.put((byte)-62).putLong(value);
        }
    }

    static void write(WritableChannel out, double value) throws IOException {
        out.put((byte)-61).putDouble(value);
    }

    static void write(WritableChannel out, char character) throws IOException {
        if (character >= ' ' && character <= '~') {
            ValueStream.write(out, PACKED_CHARS[character - 32]);
        } else {
            ValueStream.write(out, String.valueOf(character));
        }
    }

    static void write(WritableChannel out, byte[] value) throws IOException {
        ValueStream.packBytesHeader(out, value.length);
        out.put(value, 0, value.length);
    }

    static void write(WritableChannel out, String value) throws IOException {
        byte[] encoded = value.getBytes(StandardCharsets.UTF_8);
        ValueStream.packStringHeader(out, encoded.length);
        out.put(encoded, encoded.length);
    }

    static void writeUTF8(WritableChannel out, byte[] bytes, int offset, int length) throws IOException {
        ValueStream.packStringHeader(out, length);
        out.put(bytes, offset, length);
    }

    static void packBytesHeader(WritableChannel out, int size) throws IOException {
        ValueStream.packHeader(out, size, (byte)-48, (byte)-47, (byte)-46);
    }

    static void packStringHeader(WritableChannel out, int size) throws IOException {
        ValueStream.packHeader(out, size, (byte)-128, (byte)-60, (byte)-59, (byte)-58);
    }

    static void packArrayHeader(WritableChannel out, int size) throws IOException {
        ValueStream.packHeader(out, size, (byte)-45, (byte)-44, (byte)-43);
    }

    private static void packHeader(WritableChannel out, int size, byte marker8, byte marker16, byte marker32) throws IOException {
        if (size <= 127) {
            out.put(marker8).put((byte)size);
        } else if (size <= Short.MAX_VALUE) {
            out.put(marker16).putShort((short)size);
        } else {
            out.put(marker32).putInt(size);
        }
    }

    private static void packHeader(WritableChannel out, int size, byte marker4, byte marker8, byte marker16, byte marker32) throws IOException {
        if (size < 16) {
            out.put((byte)(marker4 | size));
        } else {
            ValueStream.packHeader(out, size, marker8, marker16, marker32);
        }
    }

    static void writePoint(WritableChannel out, CoordinateReferenceSystem crs, double[] coordinate) throws IOException {
        if (coordinate.length == 2) {
            out.put((byte)-57);
            ValueStream.write(out, crs.getCode());
            ValueStream.write(out, coordinate[0]);
            ValueStream.write(out, coordinate[1]);
        } else if (coordinate.length == 3) {
            out.put((byte)-56);
            ValueStream.write(out, crs.getCode());
            ValueStream.write(out, coordinate[0]);
            ValueStream.write(out, coordinate[1]);
            ValueStream.write(out, coordinate[2]);
        } else {
            throw new IllegalArgumentException("Point with 2D or 3D coordinate expected, got crs=" + String.valueOf(crs) + ", coordinate=" + Arrays.toString(coordinate));
        }
    }

    static void writeDuration(WritableChannel out, long months, long days, long seconds, int nanos) throws IOException {
        out.put((byte)-49);
        ValueStream.write(out, months);
        ValueStream.write(out, days);
        ValueStream.write(out, seconds);
        ValueStream.write(out, nanos);
    }

    static void writeDate(WritableChannel out, LocalDate localDate) throws IOException {
        long epochDay = localDate.toEpochDay();
        out.put((byte)-55);
        ValueStream.write(out, epochDay);
    }

    static void writeLocalTime(WritableChannel out, LocalTime localTime) throws IOException {
        long nanoOfDay = localTime.toNanoOfDay();
        out.put((byte)-53);
        ValueStream.write(out, nanoOfDay);
    }

    static void writeTime(WritableChannel out, OffsetTime offsetTime) throws IOException {
        long nanosOfDayLocal = offsetTime.toLocalTime().toNanoOfDay();
        int offsetSeconds = offsetTime.getOffset().getTotalSeconds();
        out.put((byte)-54);
        ValueStream.write(out, nanosOfDayLocal);
        ValueStream.write(out, offsetSeconds);
    }

    static void writeLocalDateTime(WritableChannel out, LocalDateTime localDateTime) throws IOException {
        long epochSecond = localDateTime.toEpochSecond(ZoneOffset.UTC);
        int nano = localDateTime.getNano();
        out.put((byte)-52);
        ValueStream.write(out, epochSecond);
        ValueStream.write(out, nano);
    }

    static void writeDateTime(WritableChannel out, ZonedDateTime zonedDateTime) throws IOException {
        long epochSecondLocal = zonedDateTime.toLocalDateTime().toEpochSecond(ZoneOffset.UTC);
        int nano = zonedDateTime.getNano();
        ZoneId zone = zonedDateTime.getZone();
        if (zone instanceof ZoneOffset) {
            int offsetSeconds = ((ZoneOffset)zone).getTotalSeconds();
            out.put((byte)-51);
            ValueStream.write(out, epochSecondLocal);
            ValueStream.write(out, nano);
            ValueStream.write(out, offsetSeconds);
        } else {
            String zoneId = zone.getId();
            out.put((byte)-50);
            ValueStream.write(out, epochSecondLocal);
            ValueStream.write(out, nano);
            ValueStream.write(out, zoneId);
        }
    }

    static void writeInt8Vector(WritableChannel out, byte[] coordinates) throws IOException {
        out.put((byte)-26);
        ValueStream.write(out, coordinates.length);
        out.put(coordinates, 0, coordinates.length);
    }

    static void writeInt16Vector(WritableChannel out, short[] coordinates) throws IOException {
        out.put((byte)-25);
        ValueStream.write(out, coordinates.length);
        for (short v : coordinates) {
            out.putShort(v);
        }
    }

    static void writeInt32Vector(WritableChannel out, int[] coordinates) throws IOException {
        out.put((byte)-24);
        ValueStream.write(out, coordinates.length);
        for (int v : coordinates) {
            out.putInt(v);
        }
    }

    static void writeInt64Vector(WritableChannel out, long[] coordinates) throws IOException {
        out.put((byte)-23);
        ValueStream.write(out, coordinates.length);
        for (long v : coordinates) {
            out.putLong(v);
        }
    }

    static void writeFloat32Vector(WritableChannel out, float[] coordinates) throws IOException {
        out.put((byte)-22);
        ValueStream.write(out, coordinates.length);
        for (float v : coordinates) {
            out.putFloat(v);
        }
    }

    static void writeFloat64Vector(WritableChannel out, double[] coordinates) throws IOException {
        out.put((byte)-21);
        ValueStream.write(out, coordinates.length);
        for (double v : coordinates) {
            out.putDouble(v);
        }
    }

    private static boolean readBoolean(PeekableChannel in) throws IOException {
        byte markerByte = in.get();
        return switch (markerByte) {
            case -96 -> true;
            case -112 -> false;
            default -> throw new IllegalStateException("Unexpected: " + markerByte);
        };
    }

    private static long readLong(PeekableChannel in) throws IOException {
        byte markerByte = in.get();
        if ((long)markerByte >= -16L) {
            return markerByte;
        }
        return switch (markerByte) {
            case -80 -> in.get();
            case -64 -> in.getShort();
            case -63 -> in.getInt();
            case -62 -> in.getLong();
            default -> throw new IllegalStateException("Unexpected: " + markerByte);
        };
    }

    private static byte[] readBytes(PeekableChannel in, int size) throws IOException {
        return ValueStream.readRawBytes(in, size);
    }

    private static String readString(PeekableChannel in) throws IOException {
        return new String(ValueStream.readUTF8(in), StandardCharsets.UTF_8);
    }

    private static int unpackBytesHeader(PeekableChannel in) throws IOException {
        byte markerByte = in.get();
        return switch (markerByte) {
            case -48 -> ValueStream.readUINT8(in);
            case -47 -> ValueStream.readUINT16(in);
            case -46 -> ValueStream.readUINT32(in, ValueType.BYTES);
            default -> throw new IllegalStateException("Unexpected: " + markerByte);
        };
    }

    private static int unpackArrayHeader(PeekableChannel in) throws IOException {
        byte markerByte = in.get();
        return switch (markerByte) {
            case -45 -> ValueStream.readUINT8(in);
            case -44 -> ValueStream.readUINT16(in);
            case -43 -> ValueStream.readUINT32(in, ValueType.BYTES);
            default -> throw new IllegalStateException("Unexpected: " + markerByte);
        };
    }

    private static int readStringHeader(PeekableChannel in) throws IOException {
        int size;
        byte markerByte = in.get();
        byte markerHighNibble = (byte)(markerByte & 0xF0);
        int markerLowNibble = markerByte & 0xF;
        if (markerHighNibble == -128) {
            size = markerLowNibble;
        } else {
            switch (markerByte) {
                case -60: {
                    size = ValueStream.readUINT8(in);
                    break;
                }
                case -59: {
                    size = ValueStream.readUINT16(in);
                    break;
                }
                case -58: {
                    size = ValueStream.readUINT32(in, ValueType.STRING);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected: " + markerByte);
                }
            }
        }
        return size;
    }

    private static byte[] readUTF8(PeekableChannel in) throws IOException {
        int size = ValueStream.readStringHeader(in);
        return ValueStream.readRawBytes(in, size);
    }

    private static int readUINT8(PeekableChannel in) throws IOException {
        return in.get() & 0xFF;
    }

    private static int readUINT16(PeekableChannel in) throws IOException {
        return in.getShort() & 0xFFFF;
    }

    private static long readUINT32(PeekableChannel in) throws IOException {
        return (long)in.getInt() & 0xFFFFFFFFL;
    }

    private static int readUINT32(PeekableChannel in, ValueType type) throws IOException {
        long longSize = ValueStream.readUINT32(in);
        if (longSize <= Integer.MAX_VALUE) {
            return (int)longSize;
        }
        throw new IllegalStateException(String.format("%s_32 too long for Java", new Object[]{type}));
    }

    private static byte[] readRawBytes(PeekableChannel in, int size) throws IOException {
        if (size == 0) {
            return new byte[0];
        }
        byte[] heapBuffer = new byte[size];
        in.get(heapBuffer, heapBuffer.length);
        return heapBuffer;
    }

    private static double readDouble(PeekableChannel in) throws IOException {
        byte markerByte = in.get();
        if (markerByte == -61) {
            return in.getDouble();
        }
        throw new IllegalStateException("Unexpected: " + markerByte);
    }

    private static int readInteger(PeekableChannel in) throws IOException {
        byte markerByte = in.get();
        if ((long)markerByte >= -16L) {
            return markerByte;
        }
        return switch (markerByte) {
            case -80 -> in.get();
            case -64 -> in.getShort();
            case -63 -> (short)in.getInt();
            case -62 -> throw new IllegalStateException("Unexpectedly large Integer value unpacked (" + in.getLong() + ")");
            default -> throw new IllegalStateException("Unexpected: " + markerByte);
        };
    }

    private static PointValue readPoint2D(PeekableChannel in) throws IOException {
        in.get();
        int crsCode = ValueStream.readInteger(in);
        CoordinateReferenceSystem crs = CoordinateReferenceSystem.get((int)crsCode);
        double[] coordinates = new double[]{ValueStream.readDouble(in), ValueStream.readDouble(in)};
        return Values.pointValue((CoordinateReferenceSystem)crs, (double[])coordinates);
    }

    private static PointValue readPoint3D(PeekableChannel in) throws IOException {
        in.get();
        int crsCode = ValueStream.readInteger(in);
        CoordinateReferenceSystem crs = CoordinateReferenceSystem.get((int)crsCode);
        double[] coordinates = new double[]{ValueStream.readDouble(in), ValueStream.readDouble(in), ValueStream.readDouble(in)};
        return Values.pointValue((CoordinateReferenceSystem)crs, (double[])coordinates);
    }

    private static DurationValue readDuration(PeekableChannel in) throws IOException {
        in.get();
        long months = ValueStream.readLong(in);
        long days = ValueStream.readLong(in);
        long seconds = ValueStream.readLong(in);
        long nanos = ValueStream.readInteger(in);
        return DurationValue.duration((long)months, (long)days, (long)seconds, (long)nanos);
    }

    private static DateValue readDate(PeekableChannel in) throws IOException {
        return DateValue.date((LocalDate)ValueStream.readRawDate(in));
    }

    private static LocalDate readRawDate(PeekableChannel in) throws IOException {
        in.get();
        long epochDay = ValueStream.readLong(in);
        return DateValue.epochDateRaw((long)epochDay);
    }

    private static LocalTimeValue readLocalTime(PeekableChannel in) throws IOException {
        return LocalTimeValue.localTime((LocalTime)ValueStream.readRawLocalTime(in));
    }

    private static LocalTime readRawLocalTime(PeekableChannel in) throws IOException {
        in.get();
        long nanoOfDay = ValueStream.readLong(in);
        return LocalTimeValue.localTimeRaw((long)nanoOfDay);
    }

    private static TimeValue readTime(PeekableChannel in) throws IOException {
        return TimeValue.time((OffsetTime)ValueStream.readRawTime(in));
    }

    private static OffsetTime readRawTime(PeekableChannel in) throws IOException {
        in.get();
        long nanosOfDayLocal = ValueStream.readLong(in);
        int offsetSeconds = ValueStream.readInteger(in);
        return TimeValue.timeRaw((long)TemporalUtil.nanosOfDayToUTC((long)nanosOfDayLocal, (int)offsetSeconds), (ZoneOffset)TimeUtil.zoneOffsetOfTotalSeconds((int)offsetSeconds));
    }

    private static LocalDateTime readRawLocalDateTime(PeekableChannel in) throws IOException {
        in.get();
        long epochSecond = ValueStream.readLong(in);
        long nano = ValueStream.readLong(in);
        return LocalDateTimeValue.localDateTimeRaw((long)epochSecond, (long)nano);
    }

    private static LocalDateTimeValue readLocalDateTime(PeekableChannel in) throws IOException {
        return LocalDateTimeValue.localDateTime((LocalDateTime)ValueStream.readRawLocalDateTime(in));
    }

    private static DateTimeValue readDateTimeWithZoneOffset(PeekableChannel in) throws IOException {
        in.get();
        long epochSecondLocal = ValueStream.readLong(in);
        long nano = ValueStream.readLong(in);
        int offsetSeconds = ValueStream.readInteger(in);
        return DateTimeValue.datetime((ZonedDateTime)ValueStream.newZonedDateTime(epochSecondLocal, nano, TimeUtil.zoneOffsetOfTotalSeconds((int)offsetSeconds)));
    }

    private static ZonedDateTime readRawDateTimeWithZoneOffset(PeekableChannel in) throws IOException {
        long epochSecondLocal = ValueStream.readLong(in);
        long nano = ValueStream.readLong(in);
        int offsetSeconds = ValueStream.readInteger(in);
        return ValueStream.newZonedDateTime(epochSecondLocal, nano, TimeUtil.zoneOffsetOfTotalSeconds((int)offsetSeconds));
    }

    private static DateTimeValue readDateTimeWithZoneName(PeekableChannel in) throws IOException {
        in.get();
        long epochSecondLocal = ValueStream.readLong(in);
        long nano = ValueStream.readLong(in);
        String zoneId = ValueStream.readString(in);
        return DateTimeValue.datetime((ZonedDateTime)ValueStream.newZonedDateTime(epochSecondLocal, nano, ZoneId.of(zoneId)));
    }

    private static ZonedDateTime readRawDateTimeWithZoneName(PeekableChannel in) throws IOException {
        long epochSecondLocal = ValueStream.readLong(in);
        long nano = ValueStream.readLong(in);
        String zoneId = ValueStream.readString(in);
        return ValueStream.newZonedDateTime(epochSecondLocal, nano, ZoneId.of(zoneId));
    }

    private static ZonedDateTime newZonedDateTime(long epochSecondLocal, long nano, ZoneId zoneId) {
        Instant instant = Instant.ofEpochSecond(epochSecondLocal, nano);
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
        return ZonedDateTime.of(localDateTime, zoneId);
    }
}

