/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.util.Map;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.SettingMigrator;
import org.neo4j.configuration.SettingMigrators;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.logging.InternalLog;

public class BoltSettingsMigrator
implements SettingMigrator {
    public static final String SETTING_KEEP_ALIVE_FOR_REQUESTS = "server.bolt.connection_keep_alive_for_requests";
    public static final String SETTING_KEEP_ALIVE_FOR_REQUESTS_STREAMING = "STREAMING";

    public void migrate(Map<String, String> values, Map<String, String> defaultValues, InternalLog log) {
        if (SETTING_KEEP_ALIVE_FOR_REQUESTS_STREAMING.equalsIgnoreCase(values.get(SETTING_KEEP_ALIVE_FOR_REQUESTS))) {
            log.warn("Use of deprecated value %s for setting %s. Support for this value will be removed in a future release.", new Object[]{SETTING_KEEP_ALIVE_FOR_REQUESTS_STREAMING, SETTING_KEEP_ALIVE_FOR_REQUESTS});
        }
        SettingMigrators.migrateSettingNameChange(values, (InternalLog)log, (String)"internal.dbms.loopback_file", (Setting)BoltConnector.unix_socket_path);
        SettingMigrators.migrateSettingNameChange(values, (InternalLog)log, (String)"internal.dbms.loopback_delete", (Setting)BoltConnector.unix_socket_delete);
        SettingMigrators.migrateSettingNameChange(values, (InternalLog)log, (String)"internal.dbms.loopback_enabled", (Setting)GraphDatabaseInternalSettings.enable_aura_profile);
    }
}

