/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm.state;

import org.neo4j.bolt.fsm.Context;
import org.neo4j.bolt.fsm.error.StateMachineException;
import org.neo4j.bolt.fsm.error.state.IllegalTransitionException;
import org.neo4j.bolt.fsm.state.AbstractState;
import org.neo4j.bolt.fsm.state.State;
import org.neo4j.bolt.fsm.state.StateReference;
import org.neo4j.bolt.fsm.state.transition.StateTransition;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;

final class SingleTransitionState
extends AbstractState {
    private final StateTransition<?> transition;

    SingleTransitionState(StateReference reference, StateTransition<?> transition) {
        super(reference);
        this.transition = transition;
    }

    @Override
    public State.Factory builderOf() {
        return State.builder(this.reference()).withTransition(this.transition);
    }

    @Override
    public StateReference process(Context ctx, RequestMessage message, ResponseHandler handler) throws StateMachineException {
        StateTransition<?> transition = this.transition;
        if (!transition.requestType().isInstance(message)) {
            throw IllegalTransitionException.illegalTransition(this, message);
        }
        return transition.process(ctx, message, handler);
    }
}

