/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connection.hint;

import java.time.Duration;
import org.neo4j.bolt.protocol.common.connection.hint.AbstractSingleKeyConnectionHintProvider;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

public final class KeepAliveConnectionHintProvider
extends AbstractSingleKeyConnectionHintProvider {
    private final Config config;

    public KeepAliveConnectionHintProvider(Config config) {
        this.config = config;
    }

    @Override
    public boolean isApplicable() {
        return this.config.get(BoltConnector.connection_keep_alive_type) == BoltConnector.KeepAliveRequestType.ALL;
    }

    @Override
    protected String getKey() {
        return "connection.recv_timeout_seconds";
    }

    @Override
    protected AnyValue getValue() {
        Duration keepAliveInterval = (Duration)this.config.get(BoltConnector.connection_keep_alive);
        Integer keepAliveProbes = (Integer)this.config.get(BoltConnector.connection_keep_alive_probes);
        return Values.longValue((long)(keepAliveInterval.toSeconds() * (long)keepAliveProbes.intValue()));
    }
}

