/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.connection;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.util.AttributeKey;
import java.time.Clock;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.neo4j.bolt.fsm.StateMachine;
import org.neo4j.bolt.negotiation.message.ProtocolCapability;
import org.neo4j.bolt.protocol.common.BoltProtocol;
import org.neo4j.bolt.protocol.common.connection.Job;
import org.neo4j.bolt.protocol.common.connector.Connector;
import org.neo4j.bolt.protocol.common.connector.connection.authentication.AuthenticationFlag;
import org.neo4j.bolt.protocol.common.connector.connection.listener.ConnectionListener;
import org.neo4j.bolt.protocol.common.connector.tx.TransactionOwner;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.io.pipeline.PipelineContext;
import org.neo4j.bolt.security.error.AuthenticationException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.net.TrackedNetworkConnection;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.io.value.PackstreamValueReader;

public interface Connection
extends TrackedNetworkConnection,
TransactionOwner {
    public static final AttributeKey<Connection> CONNECTION_ATTR = AttributeKey.valueOf(Connection.class, (String)"connection");

    public static Connection getConnection(Channel channel) {
        Connection connection = (Connection)channel.attr(CONNECTION_ATTR).get();
        Objects.requireNonNull(connection, "connection");
        return connection;
    }

    public static void setAttribute(Channel channel, Connection connection) {
        channel.attr(CONNECTION_ATTR).set((Object)connection);
    }

    public Connector connector();

    default public Clock clock() {
        return this.connector().clock();
    }

    default public String connectorId() {
        return this.connector().id();
    }

    public ByteBufAllocator allocator();

    public void modifyPipeline(BiConsumer<Channel, ChannelPipeline> var1);

    default public void modifyPipeline(Consumer<ChannelPipeline> modifier) {
        this.modifyPipeline((Channel ch, ChannelPipeline pipeline) -> modifier.accept((ChannelPipeline)pipeline));
    }

    public ChannelFuture write(Object var1);

    public ChannelFuture write(Object var1, ChannelPromise var2);

    public ChannelFuture writeAndFlush(Object var1);

    public ChannelFuture writeAndFlush(Object var1, ChannelPromise var2);

    public void flush();

    public void registerListener(ConnectionListener var1);

    public void removeListener(ConnectionListener var1);

    public void notifyListeners(Consumer<ConnectionListener> var1);

    public void notifyListenersSafely(String var1, Consumer<ConnectionListener> var2);

    public BoltProtocol protocol();

    public Set<ProtocolCapability> selectedProtocolCapabilities();

    public boolean hasSelectedProtocolCapability(ProtocolCapability var1);

    public void selectProtocol(BoltProtocol var1, Set<ProtocolCapability> var2);

    public PackstreamValueReader<Connection> valueReader(PackstreamBuf var1);

    public PipelineContext writerContext(PackstreamBuf var1);

    public StateMachine fsm();

    @Override
    public LoginContext loginContext();

    public AuthenticationFlag logon(Map<String, Object> var1) throws AuthenticationException;

    public void logoff();

    public void impersonate(String var1) throws AuthenticationException;

    public void clearImpersonation();

    public void resolveDefaultDatabase();

    public boolean isIdling();

    public boolean hasPendingJobs();

    public void submit(RequestMessage var1);

    public void submit(Job var1);

    public boolean inWorkerThread();

    public boolean isInterrupted();

    public void interrupt();

    public boolean reset();

    public boolean isActive();

    public boolean isClosing();

    public boolean isClosed();

    public void close();

    public Future<?> closeFuture();

    public static interface Factory {
        public Connection create(Connector var1, String var2, Channel var3);
    }
}

