/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.fsm.response;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Closeable;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.fsm.response.RecordHandler;
import org.neo4j.bolt.protocol.io.pipeline.PipelineContext;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.signal.FrameSignal;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.values.AnyValue;

public class NetworkRecordHandler
implements RecordHandler,
Closeable {
    public static final short RECORD_TAG = 113;
    private final Connection connection;
    private final int numberOfFields;
    private final int bufferSize;
    private final int flushThreshold;
    private PackstreamBuf buffer;
    private PipelineContext writerContext;
    private final List<ByteBuf> pendingMessages = new LinkedList<ByteBuf>();

    public NetworkRecordHandler(Connection connection, int numberOfFields, int bufferSize, int flushThreshold) {
        this.connection = connection;
        this.numberOfFields = numberOfFields;
        this.bufferSize = bufferSize;
        this.flushThreshold = flushThreshold;
    }

    @Override
    public void onBegin() {
        if (this.buffer == null) {
            this.buffer = PackstreamBuf.wrap(this.connection.allocator().buffer(this.bufferSize));
            this.writerContext = this.connection.writerContext(this.buffer);
        }
        this.buffer.writeStructHeader(new StructHeader(1L, 113)).writeListHeader(this.numberOfFields);
    }

    @Override
    public void onField(AnyValue value) {
        this.writerContext.writeValue(value);
    }

    @Override
    public void onCompleted() {
        ByteBuf buffer = this.buffer.raw();
        this.pendingMessages.add(buffer.readRetainedSlice(buffer.readableBytes()));
        buffer.markWriterIndex();
        if (this.flushThreshold == 0 || this.buffer.raw().writerIndex() >= this.flushThreshold) {
            this.flush();
        }
    }

    @Override
    public void onFailure() {
        this.close();
    }

    private void writePending() {
        ReferenceCountUtil.release((Object)this.buffer);
        this.buffer = null;
        this.pendingMessages.forEach(message -> {
            this.connection.write(message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            this.connection.write((Object)FrameSignal.MESSAGE_END).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        });
        this.pendingMessages.clear();
    }

    private void flush() {
        this.writePending();
        this.connection.flush();
        this.buffer = null;
        this.writerContext = null;
    }

    @Override
    public void close() {
        if (this.buffer == null) {
            return;
        }
        this.writePending();
    }
}

