/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.fsm.transition.ready;

import org.neo4j.bolt.fsm.Context;
import org.neo4j.bolt.fsm.error.StateMachineException;
import org.neo4j.bolt.fsm.error.state.InternalStateTransitionException;
import org.neo4j.bolt.fsm.state.StateReference;
import org.neo4j.bolt.protocol.common.fsm.error.CapabilityViolationStateTransitionException;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.fsm.transition.SimpleImpersonationStateTransition;
import org.neo4j.bolt.protocol.common.message.request.connection.RouteMessage;
import org.neo4j.dbms.routing.RoutingException;
import org.neo4j.dbms.routing.RoutingResult;
import org.neo4j.dbms.routing.result.RoutingResultFormat;
import org.neo4j.values.virtual.MapValue;

public final class RouteStateTransition
extends SimpleImpersonationStateTransition<RouteMessage> {
    private static final RouteStateTransition INSTANCE = new RouteStateTransition();

    private RouteStateTransition() {
        super(RouteMessage.class);
    }

    public static RouteStateTransition getInstance() {
        return INSTANCE;
    }

    @Override
    public StateReference doProcess(Context ctx, RouteMessage message, ResponseHandler handler) throws StateMachineException {
        MapValue routingTable;
        if (ctx.connection().connector().localQueryExecutionOnly()) {
            throw new CapabilityViolationStateTransitionException("Routing is not supported on this connector");
        }
        String databaseName = message.getDatabaseName();
        if (databaseName == null) {
            ctx.connection().resolveDefaultDatabase();
            databaseName = ctx.connection().selectedDefaultDatabase();
        }
        try {
            String user = ctx.connection().username();
            RoutingResult result = ctx.connection().connector().routingService().route(databaseName, user, message.getRequestContext());
            routingTable = RoutingResultFormat.buildMap((RoutingResult)result);
        }
        catch (RoutingException ex) {
            throw new InternalStateTransitionException("Failed to retrieve routing table", ex);
        }
        handler.onRoutingTable(databaseName, routingTable);
        return ctx.state();
    }
}

