/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.fsm.transition.ready;

import org.neo4j.bolt.fsm.Context;
import org.neo4j.bolt.fsm.state.StateReference;
import org.neo4j.bolt.fsm.state.transition.AbstractStateTransition;
import org.neo4j.bolt.protocol.common.connection.BoltDriverMetricsMonitor;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.message.request.generic.TelemetryMessage;

public class TelemetryStateTransition
extends AbstractStateTransition<TelemetryMessage> {
    private static final TelemetryStateTransition INSTANCE = new TelemetryStateTransition();

    private TelemetryStateTransition() {
        super(TelemetryMessage.class);
    }

    public static TelemetryStateTransition getInstance() {
        return INSTANCE;
    }

    @Override
    public StateReference process(Context ctx, TelemetryMessage message, ResponseHandler handler) {
        BoltDriverMetricsMonitor metricsMonitor = ctx.connection().connector().driverMetricsMonitor();
        switch (message.interfaceType()) {
            case EXECUTE_QUERY: {
                metricsMonitor.executeInterfaceCalled();
                break;
            }
            case MANAGED_TRANSACTION: {
                metricsMonitor.managedTransactionFunctionsInterfaceCalled();
                break;
            }
            case UNMANAGED_TRANSACTION: {
                metricsMonitor.unmanagedTransactionInterfaceCalled();
                break;
            }
            case TRANSACTION_FUNCTION: {
                metricsMonitor.implicitTransactionInterfaceCalled();
            }
        }
        return ctx.state();
    }
}

