/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.Stack;
import org.neo4j.bolt.protocol.error.ClientRequestComplexityExceeded;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.io.Type;

public class AuthenticationProtocolLimiterHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(AuthenticationProtocolLimiterHandler.class);
    private final int maxElements;
    private final int maxMessageDepth;
    private final Stack<DecoderLevel> levels = new Stack();

    public AuthenticationProtocolLimiterHandler(int maxElements, int maxMessageDepth) {
        this.maxElements = maxElements;
        this.maxMessageDepth = maxMessageDepth;
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        if (!msg.isReadable()) {
            ctx.fireChannelRead((Object)msg.retain());
            return;
        }
        msg.markReaderIndex();
        PackstreamBuf buffer = PackstreamBuf.wrap(msg);
        boolean rootEncountered = false;
        block4: while (msg.isReadable()) {
            Type type = buffer.peekType();
            if (this.levels.isEmpty()) {
                if (rootEncountered) {
                    throw PackstreamReaderException.illegalElement("secondary root", "Excepted single root element", "Encountered illegal secondary root element within message");
                }
                rootEncountered = true;
                if (type != Type.STRUCT) {
                    throw PackstreamReaderException.illegalElement("root", "Expected struct", "Encountered illegal root element: Expected struct");
                }
            }
            switch (type) {
                case LIST: 
                case MAP: {
                    this.pushLevel(type, buffer.readLengthPrefixMarker(type));
                    continue block4;
                }
                case STRUCT: {
                    this.pushLevel(type, buffer.readStructHeader().length());
                    continue block4;
                }
            }
            buffer.skip(type);
            if (this.flipMapKey(type)) continue;
            this.popLevel();
        }
        msg.resetReaderIndex();
        ctx.fireChannelRead((Object)msg.retain());
    }

    private boolean flipMapKey(Type type) throws PackstreamReaderException {
        if (this.levels.isEmpty()) {
            return false;
        }
        DecoderLevel currentLevel = this.levels.peek();
        if (currentLevel.type == Type.MAP) {
            boolean bl = currentLevel.expectingKey = !currentLevel.expectingKey;
            if (!currentLevel.expectingKey) {
                if (type != Type.STRING) {
                    throw PackstreamReaderException.illegalElement("map", "Expected string key", "Encountered illegal map element: Expected string key");
                }
                return true;
            }
        }
        return false;
    }

    private void pushLevel(Type type, long remainingElements) throws PackstreamReaderException {
        if (this.levels.size() + 1 > this.maxMessageDepth) {
            throw new ClientRequestComplexityExceeded("Message has exceeded maximum permitted complexity of " + this.maxMessageDepth + " levels");
        }
        if (remainingElements > (long)this.maxElements) {
            throw new ClientRequestComplexityExceeded("Message has exceeded maximum permitted complexity of " + this.maxElements + " elements");
        }
        this.flipMapKey(type);
        if (remainingElements == 0L) {
            this.popLevel();
            return;
        }
        this.levels.push(new DecoderLevel(type, remainingElements));
    }

    private void popLevel() {
        while (!this.levels.isEmpty()) {
            DecoderLevel currentLevel = this.levels.peek();
            if (--currentLevel.remainingElements > 0L) {
                return;
            }
            this.levels.pop();
        }
    }

    private static final class DecoderLevel {
        private final Type type;
        private long remainingElements;
        private boolean expectingKey = true;

        public DecoderLevel(Type type, long remainingElements) {
            this.type = type;
            this.remainingElements = remainingElements;
        }
    }
}

