/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.message.decoder.connection;

import java.util.Collections;
import java.util.List;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.message.decoder.MessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.transaction.AbstractTransactionInitiatingMessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.util.TransactionInitiatingMetadataParser;
import org.neo4j.bolt.protocol.common.message.request.connection.RouteMessage;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.io.Type;
import org.neo4j.packstream.io.value.PackstreamValueReader;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.util.PackstreamConditions;
import org.neo4j.values.virtual.MapValue;

public final class DefaultRouteMessageDecoder
implements MessageDecoder<RouteMessage> {
    private static final DefaultRouteMessageDecoder INSTANCE = new DefaultRouteMessageDecoder();

    private DefaultRouteMessageDecoder() {
    }

    public static DefaultRouteMessageDecoder getInstance() {
        return INSTANCE;
    }

    @Override
    public short getTag() {
        return 102;
    }

    @Override
    public RouteMessage read(Connection ctx, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        PackstreamConditions.requireLength(header, 3);
        PackstreamValueReader<Connection> valueReader = ctx.valueReader(buffer);
        MapValue routingContext = valueReader.readMap();
        List<String> bookmarkList = this.readBookmarks(buffer, valueReader);
        MapValue meta = valueReader.readMap();
        String databaseName = TransactionInitiatingMetadataParser.readDatabaseName(meta);
        String impersonatedUser = TransactionInitiatingMetadataParser.readImpersonatedUser(meta);
        return new RouteMessage(routingContext, bookmarkList, databaseName, impersonatedUser);
    }

    protected List<String> readBookmarks(PackstreamBuf buffer, PackstreamValueReader<Connection> valueReader) throws PackstreamReaderException {
        if (buffer.peekType() == Type.NONE) {
            return Collections.emptyList();
        }
        return AbstractTransactionInitiatingMessageDecoder.convertBookmarks(valueReader.readList());
    }
}

