/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.message.encoder;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.bolt.negotiation.message.ProtocolCapability;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.message.response.FailureMessage;
import org.neo4j.bolt.protocol.common.message.response.FailureMetadata;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.struct.StructWriter;

public final class FailureMessageEncoder
implements StructWriter<Connection, FailureMessage> {
    private static final FailureMessageEncoder INSTANCE = new FailureMessageEncoder();
    public static final Map<String, Object> DEFAULT_DIAGNOSTIC_RECORD = Map.of("OPERATION", "", "OPERATION_CODE", "0", "CURRENT_SCHEMA", "/", "_position", Map.of("offset", -1, "line", -1, "column", -1));

    private FailureMessageEncoder() {
    }

    public static FailureMessageEncoder getInstance() {
        return INSTANCE;
    }

    @Override
    public Class<FailureMessage> getType() {
        return FailureMessage.class;
    }

    @Override
    public short getTag(FailureMessage payload) {
        return 127;
    }

    @Override
    public long getLength(FailureMessage payload) {
        return 1L;
    }

    @Override
    public void write(Connection ctx, PackstreamBuf buffer, FailureMessage payload) {
        this.writeMetadata(ctx, buffer, payload.metadata(), false);
    }

    private void writeMetadata(Connection ctx, PackstreamBuf buffer, FailureMetadata payload, boolean isCause) {
        int size;
        Map<String, Object> diagnosticRecord = FailureMessageEncoder.getDiagnosticRecord(ctx, payload, isCause);
        int n = size = payload.cause() != null ? 6 : 5;
        if (diagnosticRecord.isEmpty()) {
            --size;
        }
        if (isCause) {
            --size;
        }
        buffer.writeMapHeader(size);
        if (!isCause) {
            buffer.writeString("neo4j_code");
            buffer.writeString(payload.status().code().serialize());
        }
        buffer.writeString("message");
        buffer.writeString(payload.message());
        buffer.writeString("gql_status");
        buffer.writeString(payload.gqlStatus());
        buffer.writeString("description");
        buffer.writeString(payload.description());
        if (!diagnosticRecord.isEmpty()) {
            buffer.writeString("diagnostic_record");
            buffer.writeMap(diagnosticRecord);
        }
        if (payload.cause() != null) {
            buffer.writeString("cause");
            this.writeMetadata(ctx, buffer, payload.cause(), true);
        }
    }

    private static Map<String, Object> getDiagnosticRecord(Connection ctx, FailureMetadata payload, boolean isCause) {
        HashMap<String, Object> diagnosticRecord = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : payload.diagnosticRecord().entrySet()) {
            if (FailureMessageEncoder.isDefaultDiagnosticRecordEntry(entry)) continue;
            diagnosticRecord.put(entry.getKey(), entry.getValue());
        }
        if (!isCause && ctx.hasSelectedProtocolCapability(ProtocolCapability.FABRIC)) {
            diagnosticRecord.put("__legacy_message", payload.legacyMessage());
        }
        return diagnosticRecord;
    }

    private static boolean isDefaultDiagnosticRecordEntry(Map.Entry<String, Object> entry) {
        return DEFAULT_DIAGNOSTIC_RECORD.containsKey(entry.getKey()) && DEFAULT_DIAGNOSTIC_RECORD.get(entry.getKey()).equals(entry.getValue());
    }
}

