/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.io.reader;

import org.neo4j.bolt.protocol.io.StructType;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.exceptions.Neo4jException;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructArgumentException;
import org.neo4j.packstream.error.struct.IllegalStructSizeException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.struct.StructReader;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Values;

public final class Point3dReader<CTX>
implements StructReader<CTX, PointValue> {
    private static final Point3dReader<?> INSTANCE = new Point3dReader();

    private Point3dReader() {
    }

    public static <CTX> Point3dReader<CTX> getInstance() {
        return INSTANCE;
    }

    @Override
    public short getTag() {
        return StructType.POINT_3D.getTag();
    }

    @Override
    public PointValue read(CTX ctx, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        CoordinateReferenceSystem crs;
        if (header.length() != 4L) {
            throw IllegalStructSizeException.illegalStructSize(4L, header.length());
        }
        long crsCode = buffer.readInt();
        double x = buffer.readFloat64();
        double y = buffer.readFloat64();
        double z = buffer.readFloat64();
        if (crsCode > Integer.MAX_VALUE || crsCode < Integer.MIN_VALUE) {
            throw IllegalStructArgumentException.crsOutOfBounds();
        }
        try {
            crs = CoordinateReferenceSystem.get((int)((int)crsCode));
        }
        catch (InvalidArgumentException ex) {
            throw IllegalStructArgumentException.invalidCRS(String.valueOf(crsCode), (Neo4jException)ex);
        }
        try {
            return Values.pointValue((CoordinateReferenceSystem)crs, (double[])new double[]{x, y, z});
        }
        catch (InvalidArgumentException ex) {
            throw IllegalStructArgumentException.invalidCoordinateArguments("coords", "point", new double[]{x, y, z}, String.format("Illegal CRS/coords combination (crs=%s, x=%s, y=%s, z=%s)", crs, x, y, z), ex);
        }
    }
}

