/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.io.reader;

import java.util.List;
import org.neo4j.bolt.protocol.io.StructType;
import org.neo4j.packstream.error.reader.LimitExceededException;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructArgumentException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.io.Type;
import org.neo4j.packstream.io.TypeMarker;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.struct.StructReader;
import org.neo4j.values.storable.Float32Vector;
import org.neo4j.values.storable.Float64Vector;
import org.neo4j.values.storable.Int16Vector;
import org.neo4j.values.storable.Int32Vector;
import org.neo4j.values.storable.Int64Vector;
import org.neo4j.values.storable.Int8Vector;
import org.neo4j.values.storable.Values;
import org.neo4j.values.storable.VectorValue;

public final class VectorReader<CTX>
implements StructReader<CTX, VectorValue> {
    private static final VectorReader INSTANCE = new VectorReader();

    private VectorReader() {
    }

    public static <CTX> VectorReader<CTX> getInstance() {
        return INSTANCE;
    }

    @Override
    public short getTag() {
        return StructType.VECTOR.getTag();
    }

    @Override
    public VectorValue read(Object o, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        long tagLength = buffer.readLengthPrefixMarker(Type.BYTES);
        if (tagLength != 1L) {
            throw LimitExceededException.protocolMessageLengthLimitOverflow(1L, tagLength);
        }
        TypeMarker tag = TypeMarker.byEncoded(buffer.raw().readUnsignedByte());
        long length = buffer.readLengthPrefixMarker(Type.BYTES);
        if (length > Integer.MAX_VALUE) {
            throw LimitExceededException.protocolMessageLengthLimitOverflow(Integer.MAX_VALUE, length);
        }
        return switch (tag) {
            case TypeMarker.INT8 -> this.readInt8Vector(buffer, (int)length);
            case TypeMarker.INT16 -> this.readInt16Vector(buffer, (int)length);
            case TypeMarker.INT32 -> this.readInt32Vector(buffer, (int)length);
            case TypeMarker.INT64 -> this.readInt64Vector(buffer, (int)length);
            case TypeMarker.FLOAT32 -> this.readFloat32Vector(buffer, (int)length);
            case TypeMarker.FLOAT64 -> this.readFloat64Vector(buffer, (int)length);
            default -> throw IllegalStructArgumentException.wrongTypeForFieldName("type", Short.toString(tag.getValue()), List.of("INT8", "INT16", "INT32", "INT64", "FLOAT32", "FLOAT64"), tag.name(), "Given type is not a valid vector value type");
        };
    }

    private Int8Vector readInt8Vector(PackstreamBuf buffer, int length) {
        byte[] coordinates = new byte[length];
        buffer.raw().readBytes(coordinates);
        return Values.int8Vector((byte[])coordinates);
    }

    private Int16Vector readInt16Vector(PackstreamBuf buffer, int length) {
        int actualLength = length >>> 1;
        short[] coordinates = new short[actualLength];
        for (int i = 0; i < actualLength; ++i) {
            coordinates[i] = buffer.raw().readShort();
        }
        return Values.int16Vector((short[])coordinates);
    }

    private Int32Vector readInt32Vector(PackstreamBuf buffer, int length) {
        int actualLength = length >>> 2;
        int[] coordinates = new int[actualLength];
        for (int i = 0; i < actualLength; ++i) {
            coordinates[i] = buffer.raw().readInt();
        }
        return Values.int32Vector((int[])coordinates);
    }

    private Int64Vector readInt64Vector(PackstreamBuf buffer, int length) {
        int actualLength = length >>> 3;
        long[] coordinates = new long[actualLength];
        for (int i = 0; i < actualLength; ++i) {
            coordinates[i] = buffer.raw().readLong();
        }
        return Values.int64Vector((long[])coordinates);
    }

    private Float32Vector readFloat32Vector(PackstreamBuf buffer, int length) throws IllegalStructArgumentException {
        int actualLength = length >>> 2;
        float[] coordinates = new float[actualLength];
        for (int i = 0; i < actualLength; ++i) {
            float value = buffer.raw().readFloat();
            if (!Float.isFinite(value)) {
                throw IllegalStructArgumentException.floatOverflow(Float.toString(value), "Coercing to a 32 bit Float", TypeMarker.FLOAT32.name());
            }
            coordinates[i] = value;
        }
        return Values.float32Vector((float[])coordinates);
    }

    private Float64Vector readFloat64Vector(PackstreamBuf buffer, int length) throws IllegalStructArgumentException {
        int actualLength = length >>> 3;
        double[] coordinates = new double[actualLength];
        for (int i = 0; i < actualLength; ++i) {
            double value = buffer.raw().readDouble();
            if (!Double.isFinite(value)) {
                throw IllegalStructArgumentException.floatOverflow(Double.toString(value), "Coercing to a 32 bit Float", TypeMarker.FLOAT64.name());
            }
            coordinates[i] = value;
        }
        return Values.float64Vector((double[])coordinates);
    }
}

