/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.tx.statement;

import java.util.List;
import java.util.Optional;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.tx.error.statement.StatementException;
import org.neo4j.graphdb.QueryStatistics;

public interface Statement {
    public long id();

    public List<String> fieldNames();

    public long executionTime();

    public Optional<QueryStatistics> statistics();

    public boolean hasRemaining();

    public void consume(ResponseHandler var1, long var2) throws StatementException;

    public void discard(ResponseHandler var1, long var2) throws StatementException;

    public void terminate();

    public void registerListener(Listener var1);

    public void removeListener(Listener var1);

    public void close();

    public static interface Listener {
        default public void onCompleted(Statement statement) {
        }

        default public void onTerminated(Statement statement) {
        }

        default public void onClosed(Statement statement) {
        }
    }
}

