/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.txtracking;

import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.bolt.txtracking.SystemLastTransactionIdProvider;
import org.neo4j.bolt.txtracking.TransactionIdTrackerException;
import org.neo4j.bolt.txtracking.TransactionIdTrackerMonitor;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.kernel.database.AbstractDatabase;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.time.Stopwatch;
import org.neo4j.time.SystemNanoClock;

public class TransactionIdTracker {
    private final DatabaseManagementService managementService;
    private final TransactionIdTrackerMonitor monitor;
    private final SystemNanoClock clock;
    private final Log log;

    public TransactionIdTracker(DatabaseManagementService managementService, Monitors monitors, SystemNanoClock clock, LogProvider logProvider) {
        this.managementService = managementService;
        this.monitor = (TransactionIdTrackerMonitor)monitors.newMonitor(TransactionIdTrackerMonitor.class, new String[0]);
        this.clock = clock;
        this.log = logProvider.getLog(this.getClass());
    }

    public long newestTransactionId(NamedDatabaseId namedDatabaseId) {
        AbstractDatabase db = TransactionIdTracker.lookupDatabase(this.lookupDatabaseApi(namedDatabaseId));
        try {
            return TransactionIdTracker.transactionIdStore(db).getLastCommittedTransactionId();
        }
        catch (RuntimeException e) {
            throw TransactionIdTracker.databaseUnavailable(namedDatabaseId, e);
        }
    }

    public void awaitUpToDate(NamedDatabaseId namedDatabaseId, long oldestAcceptableTxId, Duration timeout) {
        AbstractDatabase db = TransactionIdTracker.lookupDatabase(this.lookupDatabaseApi(namedDatabaseId));
        if (oldestAcceptableTxId <= 1L) {
            return;
        }
        long lastTransactionId = -1L;
        try {
            Stopwatch startTime = this.clock.startStopWatch();
            boolean waited = false;
            do {
                if (TransactionIdTracker.isNotAvailable(db)) {
                    throw TransactionIdTracker.databaseUnavailable(namedDatabaseId);
                }
                lastTransactionId = TransactionIdTracker.currentTransactionId(db);
                if (oldestAcceptableTxId <= lastTransactionId) {
                    this.log.debug("Done waiting for bookmark on database '%s' after %s (awaited:%s, reached:%s)", new Object[]{namedDatabaseId, waited ? startTime.elapsed() : Duration.ZERO, oldestAcceptableTxId, lastTransactionId});
                    return;
                }
                this.waitWhenNotUpToDate();
                waited = true;
            } while (!startTime.hasTimedOut(timeout));
            throw TransactionIdTracker.unreachableDatabaseVersion(db, lastTransactionId, oldestAcceptableTxId);
        }
        catch (RuntimeException e) {
            if (TransactionIdTracker.isNotAvailable(db)) {
                throw TransactionIdTracker.databaseUnavailable(namedDatabaseId, e);
            }
            throw TransactionIdTrackerException.unreachableDatabaseVersion(db, lastTransactionId, oldestAcceptableTxId, e);
        }
    }

    private void waitWhenNotUpToDate() {
        this.monitor.onWaitWhenNotUpToDate();
        LockSupport.parkNanos(100L);
    }

    private static long currentTransactionId(AbstractDatabase db) {
        Optional systemLastTransactionIdProvider;
        if (db.isSystem() && (systemLastTransactionIdProvider = db.getDependencyResolver().resolveOptionalDependency(SystemLastTransactionIdProvider.class)).isPresent()) {
            return ((SystemLastTransactionIdProvider)systemLastTransactionIdProvider.get()).lastTransactionId();
        }
        return TransactionIdTracker.transactionIdStore(db).getLastClosedTransactionId();
    }

    private static TransactionIdStore transactionIdStore(AbstractDatabase db) {
        return (TransactionIdStore)db.getDependencyResolver().resolveDependency(TransactionIdStore.class);
    }

    private GraphDatabaseAPI lookupDatabaseApi(NamedDatabaseId namedDatabaseId) {
        try {
            return (GraphDatabaseAPI)this.managementService.database(namedDatabaseId.name());
        }
        catch (DatabaseNotFoundException e) {
            throw namedDatabaseId.isSystemDatabase() ? TransactionIdTracker.databaseUnavailable(namedDatabaseId) : TransactionIdTracker.databaseNotFound(namedDatabaseId);
        }
    }

    private static AbstractDatabase lookupDatabase(GraphDatabaseAPI dbApi) {
        DependencyResolver dependencyResolver = dbApi.getDependencyResolver();
        if (dependencyResolver == null) {
            throw TransactionIdTracker.databaseUnavailable(dbApi.databaseId());
        }
        AbstractDatabase db = (AbstractDatabase)dependencyResolver.resolveDependency(AbstractDatabase.class);
        if (TransactionIdTracker.isNotAvailable(db)) {
            throw TransactionIdTracker.databaseUnavailable(dbApi.databaseId());
        }
        return db;
    }

    private static boolean isNotAvailable(AbstractDatabase db) {
        return !db.getDatabaseAvailabilityGuard().isAvailable();
    }

    private static TransactionIdTrackerException databaseNotFound(NamedDatabaseId namedDatabaseId) {
        return TransactionIdTrackerException.databaseNotFound(namedDatabaseId.name());
    }

    private static TransactionIdTrackerException databaseUnavailable(NamedDatabaseId namedDatabaseId) {
        return TransactionIdTracker.databaseUnavailable(namedDatabaseId, null);
    }

    private static TransactionIdTrackerException databaseUnavailable(NamedDatabaseId namedDatabaseId, Throwable cause) {
        return TransactionIdTrackerException.databaseUnavailable(namedDatabaseId.name(), cause);
    }

    private static TransactionIdTrackerException unreachableDatabaseVersion(AbstractDatabase db, long lastTransactionId, long oldestAcceptableTxId) {
        return TransactionIdTrackerException.unreachableDatabaseVersion(db, lastTransactionId, oldestAcceptableTxId, null);
    }
}

