/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.util.Arrays;
import java.util.Comparator;

public final class MathUtil {
    public static final double DEFAULT_EPSILON = 1.0E-8;

    private MathUtil() {
        throw new AssertionError();
    }

    public static double portion(double ... n) {
        assert (n.length > 0);
        double first = n[0];
        if (Math.abs(first) < 1.0E-8) {
            return 0.0;
        }
        double total = Arrays.stream(n).sum();
        return first / total;
    }

    public static int compare(double x, double y, double eps) {
        return MathUtil.equals(x, y, eps) ? 0 : (x < y ? -1 : 1);
    }

    public static boolean equals(double x, double y, double eps) {
        return Math.abs(x - y) <= eps;
    }

    public static long roundUp(long value, long multiplier) {
        return (value + multiplier - 1L) / multiplier * multiplier;
    }

    public static final class Erf {
        private static final double PP0 = 0.12837916709551256;
        private static final double PP1 = -0.3250421072470015;
        private static final double PP2 = -0.02848174957559851;
        private static final double PP3 = -0.005770270296489442;
        private static final double PP4 = -2.3763016656650163E-5;
        private static final double QQ1 = 0.39791722395915535;
        private static final double QQ2 = 0.0650222499887673;
        private static final double QQ3 = 0.005081306281875766;
        private static final double QQ4 = 1.3249473800432164E-4;
        private static final double QQ5 = -3.960228278775368E-6;
        private static final double PA0 = -0.0023621185607526594;
        private static final double PA1 = 0.41485611868374833;
        private static final double PA2 = -0.3722078760357013;
        private static final double PA3 = 0.31834661990116175;
        private static final double PA4 = -0.11089469428239668;
        private static final double PA5 = 0.035478304325618236;
        private static final double PA6 = -0.002166375594868791;
        private static final double QA1 = 0.10642088040084423;
        private static final double QA2 = 0.540397917702171;
        private static final double QA3 = 0.07182865441419627;
        private static final double QA4 = 0.12617121980876164;
        private static final double QA5 = 0.01363708391202905;
        private static final double QA6 = 0.011984499846799107;
        private static final double RA0 = -0.009864944034847148;
        private static final double RA1 = -0.6938585727071818;
        private static final double RA2 = -10.558626225323291;
        private static final double RA3 = -62.375332450326006;
        private static final double RA4 = -162.39666946257347;
        private static final double RA5 = -184.60509290671104;
        private static final double RA6 = -81.2874355063066;
        private static final double RA7 = -9.814329344169145;
        private static final double SA1 = 19.651271667439257;
        private static final double SA2 = 137.65775414351904;
        private static final double SA3 = 434.56587747522923;
        private static final double SA4 = 645.3872717332679;
        private static final double SA5 = 429.00814002756783;
        private static final double SA6 = 108.63500554177944;
        private static final double SA7 = 6.570249770319282;
        private static final double SA8 = -0.0604244152148581;
        private static final double RB0 = -0.0098649429247001;
        private static final double RB1 = -0.799283237680523;
        private static final double RB2 = -17.757954917754752;
        private static final double RB3 = -160.63638485582192;
        private static final double RB4 = -637.5664433683896;
        private static final double RB5 = -1025.0951316110772;
        private static final double RB6 = -483.5191916086514;
        private static final double SB1 = 30.33806074348246;
        private static final double SB2 = 325.7925129965739;
        private static final double SB3 = 1536.729586084437;
        private static final double SB4 = 3199.8582195085955;
        private static final double SB5 = 2553.0504064331644;
        private static final double SB6 = 474.52854120695537;
        private static final double SB7 = -22.44095244658582;
        private static final double TINY = 1.0E-300;
        private static final double ONE = 1.0;
        private static final double ERX = 0.8450629115104675;
        private static final double EFX = 0.1283791670955126;
        private static final double EFX8 = 1.0270333367641007;

        private Erf() {
        }

        public static double erf(double x) {
            double S;
            double R;
            int hx = (int)(Double.doubleToRawLongBits(x) >> 32);
            int ix = hx & Integer.MAX_VALUE;
            if (ix >= 0x7FF00000) {
                int i = hx >>> 31 << 1;
                return (double)(1 - i) + 1.0 / x;
            }
            if (ix < 1072365568) {
                if (ix < 0x3E300000) {
                    if (ix < 0x800000) {
                        return 0.125 * (8.0 * x + 1.0270333367641007 * x);
                    }
                    return x + 0.1283791670955126 * x;
                }
                double z = x * x;
                double r = 0.12837916709551256 + z * (-0.3250421072470015 + z * (-0.02848174957559851 + z * (-0.005770270296489442 + z * -2.3763016656650163E-5)));
                double s = 1.0 + z * (0.39791722395915535 + z * (0.0650222499887673 + z * (0.005081306281875766 + z * (1.3249473800432164E-4 + z * -3.960228278775368E-6))));
                double y = r / s;
                return x + x * y;
            }
            if (ix < 1072955392) {
                double s = Math.abs(x) - 1.0;
                double P = -0.0023621185607526594 + s * (0.41485611868374833 + s * (-0.3722078760357013 + s * (0.31834661990116175 + s * (-0.11089469428239668 + s * (0.035478304325618236 + s * -0.002166375594868791)))));
                double Q = 1.0 + s * (0.10642088040084423 + s * (0.540397917702171 + s * (0.07182865441419627 + s * (0.12617121980876164 + s * (0.01363708391202905 + s * 0.011984499846799107)))));
                if (hx >= 0) {
                    return 0.8450629115104675 + P / Q;
                }
                return -0.8450629115104675 - P / Q;
            }
            if (ix >= 1075314688) {
                if (hx >= 0) {
                    return 1.0;
                }
                return -1.0;
            }
            x = Math.abs(x);
            double s = 1.0 / (x * x);
            if (ix < 1074191214) {
                R = -0.009864944034847148 + s * (-0.6938585727071818 + s * (-10.558626225323291 + s * (-62.375332450326006 + s * (-162.39666946257347 + s * (-184.60509290671104 + s * (-81.2874355063066 + s * -9.814329344169145))))));
                S = 1.0 + s * (19.651271667439257 + s * (137.65775414351904 + s * (434.56587747522923 + s * (645.3872717332679 + s * (429.00814002756783 + s * (108.63500554177944 + s * (6.570249770319282 + s * -0.0604244152148581)))))));
            } else {
                R = -0.0098649429247001 + s * (-0.799283237680523 + s * (-17.757954917754752 + s * (-160.63638485582192 + s * (-637.5664433683896 + s * (-1025.0951316110772 + s * -483.5191916086514)))));
                S = 1.0 + s * (30.33806074348246 + s * (325.7925129965739 + s * (1536.729586084437 + s * (3199.8582195085955 + s * (2553.0504064331644 + s * (474.52854120695537 + s * -22.44095244658582))))));
            }
            double z = Double.longBitsToDouble(Double.doubleToRawLongBits(x) & 0xFFFFFFFFL);
            double r = Math.exp(-z * z - 0.5625) * Math.exp((z - x) * (z + x) + R / S);
            if (hx >= 0) {
                return 1.0 - r / x;
            }
            return r / x - 1.0;
        }
    }

    public static class CommonToleranceComparator
    implements Comparator<Double> {
        private final double epsilon;

        public CommonToleranceComparator(double epsilon) {
            this.epsilon = epsilon;
        }

        @Override
        public int compare(Double x, Double y) {
            return MathUtil.compare(x, y, this.epsilon);
        }
    }
}

