/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.compound;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.neo4j.shaded.lucene9.analysis.CharArraySet;
import org.neo4j.shaded.lucene9.analysis.TokenFilter;
import org.neo4j.shaded.lucene9.analysis.TokenFilterFactory;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.analysis.compound.HyphenationCompoundWordTokenFilter;
import org.neo4j.shaded.lucene9.analysis.compound.hyphenation.HyphenationTree;
import org.neo4j.shaded.lucene9.util.IOUtils;
import org.neo4j.shaded.lucene9.util.ResourceLoader;
import org.neo4j.shaded.lucene9.util.ResourceLoaderAware;
import org.xml.sax.InputSource;

public class HyphenationCompoundWordTokenFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "hyphenationCompoundWord";
    private CharArraySet dictionary;
    private HyphenationTree hyphenator;
    private final String dictFile;
    private final String hypFile;
    private final String encoding;
    private final int minWordSize;
    private final int minSubwordSize;
    private final int maxSubwordSize;
    private final boolean onlyLongestMatch;
    private final boolean noSubMatches;
    private final boolean noOverlappingMatches;

    public HyphenationCompoundWordTokenFilterFactory(Map<String, String> args) {
        super(args);
        this.dictFile = this.get(args, "dictionary");
        this.encoding = this.get(args, "encoding");
        this.hypFile = this.require(args, "hyphenator");
        this.minWordSize = this.getInt(args, "minWordSize", 5);
        this.minSubwordSize = this.getInt(args, "minSubwordSize", 2);
        this.maxSubwordSize = this.getInt(args, "maxSubwordSize", 15);
        this.onlyLongestMatch = this.getBoolean(args, "onlyLongestMatch", false);
        this.noSubMatches = this.getBoolean(args, "noSubMatches", false);
        this.noOverlappingMatches = this.getBoolean(args, "noOverlappingMatches", false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public HyphenationCompoundWordTokenFilterFactory() {
        throw HyphenationCompoundWordTokenFilterFactory.defaultCtorException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inform(ResourceLoader loader) throws IOException {
        InputStream stream = null;
        try {
            if (this.dictFile != null) {
                this.dictionary = this.getWordSet(loader, this.dictFile, false);
            }
            stream = loader.openResource(this.hypFile);
            InputSource is = new InputSource(stream);
            is.setEncoding(this.encoding);
            is.setSystemId(this.hypFile);
            this.hyphenator = HyphenationCompoundWordTokenFilter.getHyphenationTree(is);
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(stream);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(stream);
    }

    @Override
    public TokenFilter create(TokenStream input) {
        return new HyphenationCompoundWordTokenFilter(input, this.hyphenator, this.dictionary, this.minWordSize, this.minSubwordSize, this.maxSubwordSize, this.onlyLongestMatch, this.noSubMatches, this.noOverlappingMatches);
    }
}

