/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.core;

import java.util.Map;
import org.neo4j.shaded.lucene9.analysis.TokenizerFactory;
import org.neo4j.shaded.lucene9.analysis.core.LetterTokenizer;
import org.neo4j.shaded.lucene9.util.AttributeFactory;

public class LetterTokenizerFactory
extends TokenizerFactory {
    public static final String NAME = "letter";
    private final int maxTokenLen;

    public LetterTokenizerFactory(Map<String, String> args) {
        super(args);
        this.maxTokenLen = this.getInt(args, "maxTokenLen", 255);
        if (this.maxTokenLen > 0x100000 || this.maxTokenLen <= 0) {
            throw new IllegalArgumentException("maxTokenLen must be greater than 0 and less than 1048576 passed: " + this.maxTokenLen);
        }
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public LetterTokenizerFactory() {
        throw LetterTokenizerFactory.defaultCtorException();
    }

    @Override
    public LetterTokenizer create(AttributeFactory factory) {
        return new LetterTokenizer(factory, this.maxTokenLen);
    }
}

