/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.en;

import java.io.IOException;
import org.neo4j.shaded.lucene9.analysis.TokenFilter;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.analysis.en.KStemmer;
import org.neo4j.shaded.lucene9.analysis.tokenattributes.CharTermAttribute;
import org.neo4j.shaded.lucene9.analysis.tokenattributes.KeywordAttribute;

public final class KStemFilter
extends TokenFilter {
    private final KStemmer stemmer = new KStemmer();
    private final CharTermAttribute termAttribute = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAtt = this.addAttribute(KeywordAttribute.class);

    public KStemFilter(TokenStream in) {
        super(in);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        char[] term = this.termAttribute.buffer();
        int len = this.termAttribute.length();
        if (!this.keywordAtt.isKeyword() && this.stemmer.stem(term, len)) {
            this.termAttribute.setEmpty().append(this.stemmer.asCharSequence());
        }
        return true;
    }
}

